/*
  by Luigi Auriemma

informations retrieved from the following resources:
- http://mark0.net/soft-trid-e.html (a very stripped-down version of it)
- http://toorcon.techpathways.com/uploads/headersig.txt

consider that I need only a quick check based on the first bytes because
this function is used only rarely and needs to be fast and simple
*/

typedef struct {
    signed char     signlen;    // max 127
    unsigned char   *sign;
    unsigned char   *ext;
} sign_ext_db_t;
static sign_ext_db_t sign_ext_db[] = {  // do NOT use const, I use a little trick for a faster job (-1 to strlen)
    // priorities
    { -1, "<res", "res" },
    {  4, "PK\x03\x04", "zip" },
    {  4, "PK\x06\x08", "zip" },
    {  4, "PK\x01\x02", "zip" },
    {  4, "PK\x05\x05", "zip" },
    {  4, "PK\x06\x06", "zip" },
    {  4, "PK\x06\x07", "zip" },
    {  4, "PK\x05\x06", "zip" },
    {  4, "PK\x07\x08", "zip" },
    {  4, "PK\x30\x30", "zip" },
    {  2, "\x1f\x8b", "gz" },
    {  2, "\x1f\x9e", "gz" },
    {  2, "\x1f\x1e", "z" },
    {  2, "\x1f\x9d", "z" },
    {  2, "\x1f\xa0", "z" },
    {  3, "FSB", "fsb" },
    {  3, "FEV", "fev" },
    {  4, "WW", "waaw" },
    {  4, "OQ", "jp2" },
    {  3, "BSB", "bsb" },
    { -1, "<?xml", "xml" },
    { -1, "TZif", "timezone" },
    { -1, "\xff""txf", "txf" },
    {  4, "\x00""XET", "tex" },
    {  4, "CBIN", "cap" },
    { -1, "<html", "htm" },
    { -1, "<!DOCTYPE", "htm" },
    {  4, "\x7f""ELF", "bin" },
    { -1, "//[[gM", "aiw" },
    {  4, "77M", "77m" }, // extension invented
    { 16, "GMOTORMAS10\0\0\0\0\0", "mas" },
    { 16, "\xC8\xCF\xD2\xD8\xCE\xD8\xE6\xC9\xCA\xDD\xD8\xBE\xBB\xA6\xBF\x90", "mas" },
    { 16, "CUBEMAS4.10\0\0\0\0\0", "mas" },
    {  5, "sc666", "nko" },
    {  5, "\x00""sreV", "pbo" },
    { -1, "#!/usr/bin/python", "py" },
    { -1, "#!/usr/bin/perl", "pl" },
    { -1, "#!/usr/bin/sh", "sh" },
    { -1, "#!/usr/bin/csh", "sh" },
    { -1, "#!/usr/bin/bash", "sh" },
    { 4,  "RIFX", "wav" },
    { 4,  "<Roo", "xml" },  // not really xml
    { 99, "\x48\x79\x70\x65\x72\x54\x65\x72\x6D\x69\x6E\x61\x6C\x20\x31\x2E\x30\x20\x2D\x2D\x20\x48\x79\x70\x65\x72\x54\x65\x72\x6D\x69\x6E\x61\x6C\x20\x64\x61\x74\x61\x20\x66\x69\x6C\x65\x0D\x0A\x50\x6C\x65\x61\x73\x65\x20\x64\x6F\x20\x6E\x6F\x74\x20\x61\x74\x74\x65\x6D\x70\x74\x20\x74\x6F\x20\x6D\x6F\x64\x69\x66\x79\x20\x74\x68\x69\x73\x20\x66\x69\x6C\x65\x20\x64\x69\x72\x65\x63\x74\x6C\x79\x2E\x0D\x0A", "ht" },
    { 96, "\xFF\xFF\xFF\x5D\x00\x00\x00\x02\x00\x01\x00\x00\x00\xFC\xFF\x35\x00\x00\x00\x09\x00\x29\x00\x00\x00\x56\x75\x65\x20\x64\x27\x45\x73\x70\x72\x69\x74\x20\x2D\x20\xA9\x32\x30\x30\x31\x20\x65\x2D\x6F\x6E\x20\x73\x6F\x66\x74\x77\x61\x72\x65\x2C\x20\x69\x6E\x63\x2E\x00\xFE\xFF\x0C\x00\x00\x00\x02\x00\x90\x01\x00\x00\xFD\xFF\x10\x00\x00\x00\x09\x00\x04\x00\x00\x00\x76\x6F\x62\x00\x00\xFF", "vob" },
    { 96, "\xFF\xFF\xFF\x5D\x00\x00\x00\x02\x00\x01\x00\x00\x00\xFC\xFF\x35\x00\x00\x00\x09\x00\x29\x00\x00\x00\x56\x75\x65\x20\x64\x27\x45\x73\x70\x72\x69\x74\x20\x2D\x20\xA9\x32\x30\x30\x31\x20\x65\x2D\x6F\x6E\x20\x73\x6F\x66\x74\x77\x61\x72\x65\x2C\x20\x69\x6E\x63\x2E\x00\xFE\xFF\x0C\x00\x00\x00\x02\x00\x90\x01\x00\x00\xFD\xFF\x10\x00\x00\x00\x09\x00\x04\x00\x00\x00\x66\x6E\x63\x00\x00\xFF", "fnc" },
    { 94, "\xFF\xFE\x57\x00\x69\x00\x6E\x00\x64\x00\x6F\x00\x77\x00\x73\x00\x20\x00\x52\x00\x65\x00\x67\x00\x69\x00\x73\x00\x74\x00\x72\x00\x79\x00\x20\x00\x45\x00\x64\x00\x69\x00\x74\x00\x6F\x00\x72\x00\x20\x00\x56\x00\x65\x00\x72\x00\x73\x00\x69\x00\x6F\x00\x6E\x00\x20\x00\x35\x00\x2E\x00\x30\x00\x30\x00\x0D\x00\x0A\x00\x0D\x00\x0A\x00\x5B\x00\x48\x00\x4B\x00\x45\x00\x59\x00\x5F\x00", "reg" },
    { 91, "\x7B\x00\x7B\x00\x4B\x00\x65\x00\x79\x00\x57\x00\x61\x00\x6C\x00\x6C\x00\x65\x00\x74\x00\x5F\x00\x4F\x00\x62\x00\x6A\x00\x65\x00\x63\x00\x74\x00\x7D\x00\x7D\x00\x7B\x00\x7B\x00\x42\x00\x69\x00\x6E\x00\x61\x00\x72\x00\x79\x00\x7D\x00\x7D\x00\x7B\x00\x7B\x00\x43\x00\x72\x00\x79\x00\x70\x00\x74\x00\x53\x00\x74\x00\x6F\x00\x72\x00\x61\x00\x67\x00\x65\x00\x7D\x00\x7D", "kwo" },
    { 90, "\x0D\x0A\x09\x09\x2F\x2F\x20\x63\x6F\x6D\x62\x75\x73\x74\x69\x6F\x6E\x20\x62\x79\x20\x64\x69\x73\x63\x72\x65\x65\x74\x2E\x20\x57\x6F\x72\x6B\x73\x70\x61\x63\x65\x20\x46\x69\x6C\x65\x2E\x0D\x0A\x0D\x0A\x53\x63\x72\x69\x70\x74\x49\x6E\x66\x6F\x20\x32\x20\x30\x20\x31\x0D\x0A\x0D\x0A\x52\x6F\x6F\x74\x4D\x65\x74\x72\x69\x63\x73\x20\x36\x34\x30\x20\x34\x38\x30\x20", "cws" },
    { 88, "\xEF\xBB\xBF\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x75\x74\x66\x2D\x38\x22\x3F\x3E\x0D\x0A\x3C\x54\x65\x73\x74\x43\x61\x73\x65\x20\x4E\x61\x6D\x65\x3D\x22\x4D\x69\x63\x72\x6F\x73\x6F\x66\x74\x46\x69\x64\x64\x6C\x65\x72\x57\x65\x62\x54\x65\x73\x74\x22\x20\x49\x64\x3D\x22", "webtest" },
    { 87, "\x54\x68\x69\x73\x20\x69\x73\x20\x61\x6E\x20\x53\x48\x56\x20\x66\x6F\x72\x6D\x61\x74\x20\x65\x6D\x62\x72\x6F\x69\x64\x65\x72\x79\x20\x66\x69\x6C\x65\x3A\x20\x70\x6C\x65\x61\x73\x65\x20\x76\x69\x65\x77\x20\x74\x68\x65\x20\x74\x68\x75\x6D\x62\x6E\x61\x69\x6C\x20\x69\x6D\x61\x67\x65\x20\x66\x6F\x72\x20\x6D\x6F\x72\x65\x20\x64\x65\x74\x61\x69\x6C\x08", "shv" },
    { 86, "\x45\x6D\x62\x72\x6F\x69\x64\x65\x72\x79\x20\x64\x69\x73\x6B\x20\x63\x72\x65\x61\x74\x65\x64\x20\x75\x73\x69\x6E\x67\x20\x73\x6F\x66\x74\x77\x61\x72\x65\x20\x6C\x69\x63\x65\x6E\x73\x65\x64\x20\x66\x72\x6F\x6D\x20\x56\x69\x6B\x69\x6E\x67\x20\x53\x65\x77\x69\x6E\x67\x20\x4D\x61\x63\x68\x69\x6E\x65\x73\x20\x41\x42\x2C\x20\x53\x77\x65\x64\x65\x6E", "phv" },
    { 85, "\xAC\xED\x00\x05\x73\x72\x00\x12\x62\x67\x62\x6C\x69\x74\x7A\x2E\x50\x6F\x73\x69\x74\x69\x6F\x6E\x44\x42\x00\x75\xA2\x33\x8B\x84\x46\xD2\x02\x00\x08\x49\x00\x05\x61\x6B\x74\x4E\x6F\x4C\x00\x06\x61\x75\x74\x68\x6F\x72\x74\x00\x12\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x53\x74\x72\x69\x6E\x67\x3B\x4C\x00\x07\x63\x6F\x6D\x6D\x65\x6E\x74", "pdb" },
    { 83, "\x01\x00\x00\x00\x63\xFB\x76\x68\x73\x41\xFB\x52\x20\x6E\x69\xFB\xF0\x20\x69\x61\x01\x63\x00\x00\x20\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3F\x00\x00\x00\x3F\x00\x00\x00\x3F\x00\x00\x00\x00\x01\x00\x00\x00\x63\x63\x69\xFC\x64\x63\x64\x64\x63\x64\x68\x43\x68\x61\x72\x74\x64\x63\x64\x63\x64\x63\x64\x63\x63", "clo" },
    { 82, "\x23\x20\x64\x6F\x77\x6E\x6C\x6F\x61\x64\x20\x74\x68\x65\x20\x66\x72\x65\x65\x20\x47\x6F\x6F\x67\x6C\x65\x20\x56\x69\x64\x65\x6F\x20\x50\x6C\x61\x79\x65\x72\x20\x66\x72\x6F\x6D\x20\x68\x74\x74\x70\x3A\x2F\x2F\x76\x69\x64\x65\x6F\x2E\x67\x6F\x6F\x67\x6C\x65\x2E\x63\x6F\x6D\x2F\x0A\x67\x76\x70\x5F\x76\x65\x72\x73\x69\x6F\x6E\x3A", "gvp" },
    { 81, "\x48\x2B\x42\x45\x44\x56\x20\x50\x72\x6F\x64\x75\x63\x74\x73\x20\x4C\x69\x63\x65\x6E\x73\x65\x20\x4B\x65\x79\x20\x46\x69\x6C\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1A", "key" },
    { 80, "\x61\x70\x70\x6C\x69\x63\x61\x74\x69\x6F\x6E\x2F\x78\x2D\x69\x6E\x73\x70\x69\x72\x61\x74\x69\x6F\x6E\x20\x20\x20\x20\x43\x72\x65\x61\x74\x65\x64\x20\x62\x79\x20\x73\x6F\x66\x74\x77\x61\x72\x65\x20\x66\x72\x6F\x6D\x20\x49\x6E\x73\x70\x69\x72\x61\x74\x69\x6F\x6E\x20\x53\x6F\x66\x74\x77\x61\x72\x65\x2C\x20\x49\x6E\x63\x2E", "isf" },
    { 80, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x69\x73\x6F\x2D\x38\x38\x35\x39\x2D\x31\x22\x20\x3F\x3E\x0D\x0A\x3C\x5A\x41\x70\x70\x6C\x69\x63\x61\x74\x69\x6F\x6E\x20\x4E\x61\x6D\x65\x3D\x22\x41\x70\x70\x22\x20\x43\x61\x70\x74\x69\x6F\x6E\x3D\x22", "zgeproj" },
    { 78, "\xFF\xFE\x3C\x00\x3F\x00\x78\x00\x6D\x00\x6C\x00\x20\x00\x76\x00\x65\x00\x72\x00\x73\x00\x69\x00\x6F\x00\x6E\x00\x3D\x00\x22\x00\x31\x00\x2E\x00\x30\x00\x22\x00\x20\x00\x65\x00\x6E\x00\x63\x00\x6F\x00\x64\x00\x69\x00\x6E\x00\x67\x00\x3D\x00\x22\x00\x75\x00\x6E\x00\x69\x00\x63\x00\x6F\x00\x64\x00\x65\x00\x22\x00", "xml" },
    { 77, "\x00\x01\x00\x00\x00\xFF\xFF\xFF\xFF\x01\x00\x00\x00\x00\x00\x00\x00\x04\x01\x00\x00\x00\x1C\x53\x79\x73\x74\x65\x6D\x2E\x43\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x73\x2E\x41\x72\x72\x61\x79\x4C\x69\x73\x74\x03\x00\x00\x00\x06\x5F\x69\x74\x65\x6D\x73\x05\x5F\x73\x69\x7A\x65\x08\x5F\x76\x65\x72\x73\x69\x6F\x6E", "trs" },
    { 76, "\x6B\x55\x74\x5A\x00\x6F\x70\x79\x72\x69\x67\x68\x74\x20\x28\x63\x29\x20\x31\x39\x39\x30\x2D\x31\x39\x39\x39\x20\x53\x74\x69\x72\x6C\x69\x6E\x67\x20\x54\x65\x63\x68\x6E\x6F\x6C\x6F\x67\x69\x65\x73\x2C\x20\x4C\x74\x64\x2E\x20\x41\x6C\x6C\x20\x52\x69\x67\x68\x74\x73\x20\x52\x65\x73\x65\x72\x76\x65\x64\x2E", "dbg" },
    { 76, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0A\x3C\x53\x43\x52\x45\x45\x4D\x5F\x50\x52\x4F\x4A\x45\x43\x54\x20\x78\x6D\x6C\x6E\x73\x3A\x73\x63\x72\x65\x65\x6D\x3D\x22\x68\x74\x74\x70\x3A\x2F\x2F\x77\x77\x77\x2E\x73\x63\x72\x65\x65\x6D\x2E\x6F\x72\x67\x2F\x22\x3E", "screem" },
    { 75, "\x47\x30\x34\x20\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x20\x62\x65\x67\x69\x6E\x20\x46\x49\x4C\x45\x20\x49\x44\x45\x4E\x54\x49\x46\x49\x43\x41\x54\x49\x4F\x4E\x20\x52\x45\x43\x4F\x52\x44\x20\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x2A", "art" },
    { 74, "\x4D\x49\x4D\x45\x2D\x56\x65\x72\x73\x69\x6F\x6E\x3A\x20\x31\x2E\x30\x0D\x0A\x43\x6F\x6E\x74\x65\x6E\x74\x2D\x54\x79\x70\x65\x3A\x20\x6D\x75\x6C\x74\x69\x70\x61\x72\x74\x2F\x6D\x69\x78\x65\x64\x3B\x20\x63\x68\x61\x72\x73\x65\x74\x3D\x75\x73\x2D\x61\x73\x63\x69\x69\x3B\x20\x6E\x61\x6D\x65\x3D\x22", "a2b" },
    { 73, "\x7B\x00\x7B\x00\x4B\x00\x65\x00\x79\x00\x57\x00\x61\x00\x6C\x00\x6C\x00\x65\x00\x74\x00\x5F\x00\x4F\x00\x62\x00\x6A\x00\x65\x00\x63\x00\x74\x00\x7D\x00\x7D\x00\x7B\x00\x7B\x00\x42\x00\x69\x00\x6E\x00\x61\x00\x72\x00\x79\x00\x7D\x00\x7D\x00\x7B\x00\x7B\x00\x53\x00\x6B\x00\x69\x00\x6E\x00\x7D", "kws" },
    { 72, "\x27\x20\x50\x68\x6F\x65\x6E\x69\x78\x20\x67\x65\x6E\x65\x72\x61\x74\x65\x64\x20\x70\x72\x6F\x6A\x65\x63\x74\x20\x66\x69\x6C\x65\x2E\x0D\x0A\x27\x20\x54\x68\x69\x73\x20\x66\x69\x6C\x65\x20\x6D\x61\x79\x20\x62\x65\x20\x65\x64\x69\x74\x65\x64\x20\x6D\x61\x6E\x75\x61\x6C\x6C\x79\x2E\x0D\x0A", "pbp" },
    { 72, "\x23\x21\x47\x46\x4B\x4E\x54\x20\x32\x2E\x30\x0D\x0A\x23\x20\x54\x68\x69\x73\x20\x69\x73\x20\x61\x6E\x20\x61\x75\x74\x6F\x6D\x61\x74\x69\x63\x61\x6C\x6C\x79\x20\x67\x65\x6E\x65\x72\x61\x74\x65\x64\x20\x66\x69\x6C\x65\x2E\x20\x44\x6F\x20\x6E\x6F\x74\x20\x65\x64\x69\x74\x2E\x0D\x0A\x23\x2F", "knt" },
    { 69, "\x54\x68\x69\x73\x20\x66\x69\x6C\x65\x20\x68\x61\x73\x20\x62\x65\x65\x6E\x20\x63\x6C\x6F\x61\x6B\x65\x64\x2E\x20\x20\x54\x68\x65\x20\x6F\x72\x69\x67\x69\x6E\x61\x6C\x20\x6D\x65\x73\x73\x61\x67\x65\x20\x6D\x61\x79\x20\x62\x65\x20\x72\x65\x74\x72\x69\x65\x76\x65\x64\x20\x62\x79", "clk" },
    { 69, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22\x3F\x3E\x0D\x0A\x3C\x70\x72\x6F\x66\x69\x6C\x65\x73\x3E\x0D\x0A\x09\x3C\x70\x72\x6F\x66\x69\x6C\x65\x20\x67\x75\x69\x64\x3D\x22\x7B", "lgp" },
    { 68, "\x32\x03\x10\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\xFF\x00\x00\x80\x80\x00\x00\xFF\xFF\x00\x80\x00\x80\x00\xFF\x00\xFF\x00\x80\x00\x00\x00\xFF\x00\x00\x00\x00\x80\x00\x00\x00\xFF\x00\x00\x80\x80\x00\x00\xFF\xFF\x00\x00\x80\x80\x80\x00\xC0\xC0\xC0\x00\xFF\xFF\xFF\x00", "pcs" },
    { 66, "\x3C\x63\x6D\x6C\x3A\x6D\x6F\x6C\x65\x63\x75\x6C\x65\x20\x78\x6D\x6C\x6E\x73\x3A\x63\x6D\x6C\x3D\x22\x68\x74\x74\x70\x3A\x2F\x2F\x77\x77\x77\x2E\x78\x6D\x6C\x2D\x63\x6D\x6C\x2E\x6F\x72\x67\x2F\x73\x63\x68\x65\x6D\x61\x2F\x63\x6D\x6C\x32\x2F\x63\x6F\x72\x65\x22\x0A", "cml" },
    { 65, "\x56\x65\x72\x73\x69\x6F\x6E\x3D\x4E\x6F\x72\x64\x20\x4D\x6F\x64\x75\x6C\x61\x72\x20\x47\x32\x20\x46\x69\x6C\x65\x20\x46\x6F\x72\x6D\x61\x74\x20\x31\x0D\x0A\x54\x79\x70\x65\x3D\x50\x65\x72\x66\x6F\x72\x6D\x61\x6E\x63\x65\x0D\x0A\x56\x65\x72\x73\x69\x6F\x6E\x3D", "prf2" },
    { 64, "\x3C\x53\x48\x41\x52\x50\x20\x57\x5A\x44\x20\x44\x41\x54\x41\x3E\x0D\x0A\x3C\x44\x41\x54\x41\x20\x54\x59\x50\x45\x3E\x0D\x0A\x53\x43\x48\x45\x44\x55\x4C\x45\x0D\x0A\x3C\x2F\x44\x41\x54\x41\x20\x54\x59\x50\x45\x3E\x0D\x0A\x3C\x54\x49\x54\x4C\x45\x3E\x0D\x0A", "wzd" },
    { 64, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0A\x3C\x56\x54\x4B\x46\x69\x6C\x65\x20\x74\x79\x70\x65\x3D\x22\x55\x6E\x73\x74\x72\x75\x63\x74\x75\x72\x65\x64\x47\x72\x69\x64\x22\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22", "vtu" },
    { 64, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x49\x53\x4F\x2D\x38\x38\x35\x39\x2D\x31\x22\x3F\x3E\x0D\x0A\x3C\x4C\x45\x4E\x45\x58\x3E\x0D\x0A\x20\x3C\x56\x45\x52\x53\x49\x4F\x4E\x3E", "lef" },
    { 63, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22\x3F\x3E\x0D\x0A\x3C\x6D\x75\x76\x65\x65\x50\x72\x6F\x6A\x65\x63\x74\x3E\x3C\x76\x65\x72\x73\x69\x6F\x6E\x3E", "rvl" },
    { 62, "\x7B\x46\x78\x70\x61\x6E\x73\x69\x6F\x6E\x49\x6E\x73\x74\x61\x6C\x6C\x53\x79\x73\x74\x65\x6D\x7D\x0D\x0A\x7B\x55\x6E\x69\x6E\x73\x74\x61\x6C\x6C\x53\x63\x72\x69\x70\x74\x7D\x0D\x0A\x41\x50\x50\x4C\x49\x43\x41\x54\x49\x4F\x4E\x5F\x4E\x41\x4D\x45\x2C", "fus" },
    { 62, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0A\x3C\x56\x54\x4B\x46\x69\x6C\x65\x20\x74\x79\x70\x65\x3D\x22\x53\x74\x72\x75\x63\x74\x75\x72\x65\x64\x47\x72\x69\x64\x22\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22", "vts" },
    { 62, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22\x3F\x3E\x0A\x3C\x50\x72\x65\x6D\x69\x65\x72\x65\x44\x61\x74\x61\x20\x56\x65\x72\x73\x69\x6F\x6E\x3D\x22", "prproj" },
    { 61, "\x23\x20\x54\x68\x69\x73\x20\x69\x73\x20\x61\x6E\x20\x4B\x65\x79\x68\x6F\x6C\x65\x20\x45\x54\x41\x20\x66\x69\x6C\x65\x2E\x20\x54\x68\x65\x20\x63\x6F\x6E\x74\x65\x6E\x74\x73\x20\x61\x72\x65\x20\x61\x75\x74\x6F\x6D\x61\x74\x69\x63\x61\x6C\x6C\x79", "eta" },
    { 60, "\x44\x50\x72\x6F\x74\x65\x6C\x20\x66\x6F\x72\x20\x57\x69\x6E\x64\x6F\x77\x73\x20\x2D\x20\x53\x63\x68\x65\x6D\x61\x74\x69\x63\x20\x43\x61\x70\x74\x75\x72\x65\x20\x42\x69\x6E\x61\x72\x79\x20\x46\x69\x6C\x65\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "sch" },
    { 60, "\x43\x6F\x6D\x70\x72\x65\x73\x73\x65\x64\x20\x62\x79\x20\x44\x41\x54\x41\x43\x4F\x4D\x50\x20\x76\x20\x31\x2E\x30\x20\x28\x63\x29\x20\x31\x39\x39\x31\x2D\x2D\x31\x39\x39\x38\x20\x41\x6E\x64\x72\x65\x77\x20\x4B\x61\x64\x61\x74\x63\x68\x0D\x0A", "emd" },
    { 60, "\x3C\x46\x61\x7A\x7A\x74\x41\x6E\x6E\x6F\x75\x6E\x63\x65\x6D\x65\x6E\x74\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x27\x31\x2E\x30\x27\x3E\x0D\x0A\x3C\x65\x6E\x74\x72\x79\x20\x6E\x61\x6D\x65\x3D\x27\x45\x6F\x6E\x5A\x4E\x65\x74\x77\x6F\x72\x6B\x5C", "fza" },
    { 60, "\x3C\x3F\x61\x6F\x6D\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22\x3F\x3E\x0A\x3C\x41\x64\x6F\x62\x65\x44\x6F\x77\x6E\x6C\x6F\x61\x64\x4D\x61\x6E\x61\x67\x65\x72", "aom" },
    { 60, "\x31\x54\x68\x69\x73\x20\x69\x73\x20\x61\x20\x68\x6F\x6D\x65\x77\x6F\x72\x64\x20\x66\x69\x6C\x65\x20\x77\x69\x74\x68\x20\x64\x65\x73\x6B\x6D\x61\x74\x65\x20\x63\x68\x61\x72\x2F\x61\x74\x74\x72\x69\x62\x75\x74\x65\x20\x70\x61\x69\x72\x73\x0A", "hmw" },
    { 59, "\xEF\xBB\xBF\x0D\x0A\x4D\x69\x63\x72\x6F\x73\x6F\x66\x74\x20\x56\x69\x73\x75\x61\x6C\x20\x53\x74\x75\x64\x69\x6F\x20\x53\x6F\x6C\x75\x74\x69\x6F\x6E\x20\x46\x69\x6C\x65\x2C\x20\x46\x6F\x72\x6D\x61\x74\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "sln" },
    { 59, "\x56\x65\x72\x73\x69\x6F\x6E\x3D\x4E\x6F\x72\x64\x20\x4D\x6F\x64\x75\x6C\x61\x72\x20\x47\x32\x20\x46\x69\x6C\x65\x20\x46\x6F\x72\x6D\x61\x74\x20\x31\x0D\x0A\x54\x79\x70\x65\x3D\x50\x61\x74\x63\x68\x0D\x0A\x56\x65\x72\x73\x69\x6F\x6E\x3D", "pch2" },
    { 59, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x75\x74\x66\x2D\x38\x22\x20\x3F\x3E\x0D\x0A\x3C\x63\x6F\x6C\x6C\x61\x67\x65\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22", "cxf" },
    { 58, "\x5B\x42\x65\x67\x69\x6E\x5D\x0D\x0A\x44\x65\x66\x69\x6E\x69\x74\x69\x6F\x6E\x3A\x20\x54\x68\x65\x20\x46\x72\x61\x63\x74\x61\x6C\x20\x4D\x61\x70\x70\x65\x72\x20\x4D\x61\x70\x20\x46\x69\x6C\x65\x0D\x0A\x46\x6F\x72\x6D\x61\x74\x3A\x20", "fmp" },
    { 58, "\x4D\x69\x63\x72\x6F\x73\x6F\x66\x74\x20\x56\x69\x73\x75\x61\x6C\x20\x53\x74\x75\x64\x69\x6F\x20\x53\x6F\x6C\x75\x74\x69\x6F\x6E\x20\x46\x69\x6C\x65\x2C\x20\x46\x6F\x72\x6D\x61\x74\x20\x56\x65\x72\x73\x69\x6F\x6E\x20\x39\x2E\x30\x30", "sln" },
    { 58, "\x4D\x69\x63\x72\x6F\x73\x6F\x66\x74\x20\x56\x69\x73\x75\x61\x6C\x20\x53\x74\x75\x64\x69\x6F\x20\x53\x6F\x6C\x75\x74\x69\x6F\x6E\x20\x46\x69\x6C\x65\x2C\x20\x46\x6F\x72\x6D\x61\x74\x20\x56\x65\x72\x73\x69\x6F\x6E\x20\x38\x2E\x30\x30", "sln" },
    { 58, "\x4D\x69\x63\x72\x6F\x73\x6F\x66\x74\x20\x56\x69\x73\x75\x61\x6C\x20\x53\x74\x75\x64\x69\x6F\x20\x53\x6F\x6C\x75\x74\x69\x6F\x6E\x20\x46\x69\x6C\x65\x2C\x20\x46\x6F\x72\x6D\x61\x74\x20\x56\x65\x72\x73\x69\x6F\x6E\x20\x37\x2E\x30\x30", "sln" },
    { 57, "\xFF\xFE\x3C\x00\x73\x00\x6F\x00\x75\x00\x6E\x00\x64\x00\x5F\x00\x66\x00\x6F\x00\x72\x00\x67\x00\x65\x00\x5F\x00\x70\x00\x72\x00\x6F\x00\x6A\x00\x65\x00\x63\x00\x74\x00\x20\x00\x76\x00\x65\x00\x72\x00\x73\x00\x69\x00\x6F\x00\x6E", "frg" },
    { 56, "\xEF\xBB\xBF\x3C\x43\x61\x73\x44\x6F\x63\x75\x6D\x65\x6E\x74\x20\x44\x6F\x63\x56\x65\x72\x73\x69\x6F\x6E\x3D\x22\x32\x2E\x30\x22\x3E\x3C\x45\x6E\x74\x72\x69\x65\x73\x20\x5A\x6F\x6F\x6D\x46\x61\x63\x74\x6F\x72\x3D\x22\x31\x22", "gcw" },
    { 56, "\x53\x43\x36\x38\x20\x4D\x75\x73\x69\x63\x2D\x66\x69\x6C\x65\x20\x2F\x20\x28\x63\x29\x20\x28\x42\x65\x4E\x29\x6A\x61\x6D\x69\x6E\x20\x47\x65\x72\x61\x72\x64\x20\x2F\x20\x53\x61\x73\x48\x69\x70\x41\x2D\x44\x65\x76\x20\x20\x00", "sc68" },
    { 56, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0D\x0A\x3C\x4D\x4D\x43\x5F\x43\x6F\x6E\x73\x6F\x6C\x65\x46\x69\x6C\x65\x20\x43\x6F\x6E\x73\x6F\x6C\x65\x56\x65\x72\x73\x69\x6F\x6E\x3D\x22", "msc" },
    { 55, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22\x3F\x3E\x0A\x3C\x21\x44\x4F\x43\x54\x59\x50\x45\x20\x70\x6C\x69\x73\x74\x20", "nib" },
    { 55, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22\x20\x73\x74\x61\x6E\x64\x61\x6C\x6F\x6E\x65\x3D\x22\x79\x65\x73\x22\x3F\x3E", "aip" },
    { 54, "\xFF\xD8\xFF\xE1\x07\xFC\x45\x78\x69\x66\x00\x00\x49\x49\x2A\x00\x08\x00\x00\x00\x09\x00\x0F\x01\x02\x00\x06\x00\x00\x00\x7A\x00\x00\x00\x10\x01\x02\x00\x13\x00\x00\x00\x80\x00\x00\x00\x12\x01\x03\x00\x01\x00\x00\x00", "thm" },
    { 54, "\x4D\x69\x63\x72\x6F\x73\x6F\x66\x74\x20\x56\x69\x73\x75\x61\x6C\x20\x53\x74\x75\x64\x69\x6F\x20\x53\x6F\x6C\x75\x74\x69\x6F\x6E\x20\x46\x69\x6C\x65\x2C\x20\x46\x6F\x72\x6D\x61\x74\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "sln" },
    { 54, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22\x20\x73\x74\x61\x6E\x64\x61\x6C\x6F\x6E\x65\x3D\x22\x6E\x6F\x22\x3F\x3E", "sgt" },
    { 54, "\x02\x44\x00\x00\x00\xFF\xFF\x4F\x00\x50\x00\x53\x00\x20\x00\x48\x00\x65\x00\x61\x00\x64\x00\x65\x00\x72\x00\x20\x00\x56\x00\x65\x00\x72\x00\x73\x00\x69\x00\x6F\x00\x6E\x00\x20\x00\x31\x00\x31\x00\x2E\x00\x30\x00\x20", "ops" },
    { 54, "\x01\x44\x00\x00\x00\xFF\xFF\x4F\x00\x50\x00\x53\x00\x20\x00\x48\x00\x65\x00\x61\x00\x64\x00\x65\x00\x72\x00\x20\x00\x56\x00\x65\x00\x72\x00\x73\x00\x69\x00\x6F\x00\x6E\x00\x20\x00\x31\x00\x30\x00\x2E\x00\x30\x00\x20", "ops" },
    { 53, "\x41\x6C\x42\x1A\xFF\x0A\x0D\x00\x50\x68\x49\x6E\x00\x00\x04\x46\x56\x65\x72\x00\x01\x01\x00\x00\x00\x02\x41\x46\x6C\x61\x00\x02\x01\x00\x00\x00\x00\x00\x00\x00\x02\x46\x53\x69\x7A\x00\x02\x01\x00\x00\x00\x00\x00", "pkg" },
    { 53, "\x00\x00\x0F\xFF\xFF\xFF\xFF\xFF\x01\x00\x45\x00\x56\x00\x45\x00\x52\x00\x4D\x00\x4F\x00\x52\x00\x45\x00\x20\x00\x53\x00\x4F\x00\x46\x00\x54\x00\x57\x00\x41\x00\x52\x00\x45\x00\x20\x00\x49\x00\x4E\x00\x43\x00\x2E", "eio" },
    { 52, "\x6C\x00\x00\x00\x49\x6E\x66\x6F\x72\x6D\x61\x74\x69\x76\x65\x20\x47\x72\x61\x70\x68\x69\x63\x73\x20\x43\x6F\x72\x70\x2E\x20\x53\x65\x63\x75\x72\x65\x20\x43\x6F\x6E\x74\x65\x6E\x74\x20\x46\x6F\x72\x6D\x61\x74", "csf" },
    { 52, "\x4C\x65\x78\x74\x65\x6B\x20\x49\x6E\x74\x65\x72\x6E\x61\x74\x69\x6F\x6E\x61\x6C\x20\x4C\x61\x6E\x67\x75\x61\x67\x65\x20\x49\x64\x65\x6E\x74\x69\x66\x69\x63\x61\x74\x69\x6F\x6E\x20\x4D\x6F\x64\x75\x6C\x65\x2E", "lid" },
    { 52, "\x47\x65\x6F\x74\x69\x66\x66\x5F\x49\x6E\x66\x6F\x72\x6D\x61\x74\x69\x6F\x6E\x3A\x0A\x20\x20\x20\x56\x65\x72\x73\x69\x6F\x6E\x3A\x20\x31\x0A\x20\x20\x20\x4B\x65\x79\x5F\x52\x65\x76\x69\x73\x69\x6F\x6E\x3A\x20", "lgo" },
    { 52, "\x2A\x52\x65\x67\x43\x6C\x65\x61\x6E\x65\x72\x20\x4C\x61\x6E\x67\x75\x61\x67\x65\x50\x61\x63\x6B\x2A\x0D\x0A\x2A\x52\x47\x20\x56\x65\x72\x73\x69\x6F\x6E\x20\x3A\x20\x34\x2E\x33\x2A\x0D\x0A\x0D\x0A\x2F\x2F\x20", "rlg" },
    { 52, "\x23\x23\x23\x20\x53\x74\x72\x61\x6E\x64\x65\x64\x20\x49\x49\x20\x4D\x61\x70\x66\x69\x6C\x65\x20\xA9\x62\x79\x20\x55\x6E\x72\x65\x61\x6C\x20\x53\x6F\x66\x74\x77\x61\x72\x65\x20\x32\x30\x30\x34\x2D\x32\x30\x30", "s2" },
    { 52, "\x05\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x05\x00\x00\x00\x01\x00\x00\x00\x20\x00\x00\x00\x10\x00\x00\x00\x00\x02\x00\x00\x50\x01\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", "xnk" },
    { 51, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0D\x0A\x3C\x43\x6C\x69\x63\x6B\x54\x6F\x44\x76\x64\x50\x72\x6F\x6A\x65\x63\x74\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22", "ctd" },
    { 51, "\x23\x20\x45\x41\x47\x4C\x45\x20\x50\x61\x72\x61\x6D\x65\x74\x65\x72\x20\x46\x69\x6C\x65\x20\x28\x67\x65\x6E\x65\x72\x61\x74\x65\x64\x20\x62\x79\x20\x45\x41\x47\x4C\x45\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "usr" },
    { 50, "\x45\x4E\x49\x47\x4D\x41\x20\x42\x49\x4E\x41\x52\x59\x20\x46\x49\x4C\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x69\x6E\x61\x6C\x65\x28\x52\x29\x20\x4E\x6F\x74\x65\x50\x61\x64\x20", "mus" },
    { 50, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22\x3F\x3E\x0D\x0A\x3C\x63\x3A\x63\x6F\x6E\x74\x61\x63\x74", "contact" },
    { 50, "\x2D\x2D\x2D\x2D\x2D\x42\x45\x47\x49\x4E\x20\x50\x47\x50\x20\x50\x55\x42\x4C\x49\x43\x20\x4B\x45\x59\x20\x42\x4C\x4F\x43\x4B\x2D\x2D\x2D\x2D\x2D\x0D\x0A\x56\x65\x72\x73\x69\x6F\x6E\x3A\x20\x50\x47\x50", "pgp" },
    { 50, "\x23\x20\x4D\x69\x63\x72\x6F\x73\x6F\x66\x74\x20\x44\x65\x76\x65\x6C\x6F\x70\x65\x72\x20\x53\x74\x75\x64\x69\x6F\x20\x50\x72\x6F\x6A\x65\x63\x74\x20\x46\x69\x6C\x65\x20\x2D\x20\x4E\x61\x6D\x65\x3D\x22", "dsp" },
    { 49, "\xFF\xFE\x3B\x00\x20\x00\x45\x00\x6D\x00\x45\x00\x64\x00\x69\x00\x74\x00\x6F\x00\x72\x00\x20\x00\x53\x00\x79\x00\x6E\x00\x74\x00\x61\x00\x78\x00\x20\x00\x46\x00\x69\x00\x6C\x00\x65\x00\x0D\x00\x0A", "esy" },
    { 49, "\xEF\xBB\xBF\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0D\x0A\x3C\x50\x72\x6F\x6A\x65\x63\x74\x5F\x44\x61\x74\x61\x20\x56\x65\x72\x73\x69\x6F\x6E\x3D\x22", "camproj" },
    { 49, "\x41\x56\x50\x20\x41\x6E\x74\x69\x76\x69\x72\x61\x6C\x20\x44\x61\x74\x61\x62\x61\x73\x65\x2E\x20\x28\x63\x29\x4B\x61\x73\x70\x65\x72\x73\x6B\x79\x20\x4C\x61\x62\x20\x31\x39\x39\x37\x2D\x32\x30\x30", "avc" },
    { 49, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0D\x0A\x3C\x66\x69\x72\x65\x66\x6C\x79\x5F\x70\x72\x6F\x6A\x65\x63\x74\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22", "prj" },
    { 49, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0A\x3C\x61\x75\x64\x61\x63\x69\x74\x79\x70\x72\x6F\x6A\x65\x63\x74\x20\x70\x72\x6F\x6A\x6E\x61\x6D\x65\x3D\x22", "aup" },
    { 49, "\x3B\x0D\x3B\x20\x53\x70\x61\x63\x65\x43\x41\x44\x28\x74\x6D\x29\x20\x4D\x6F\x64\x65\x6C\x20\x52\x6F\x63\x6B\x65\x74\x20\x53\x6F\x66\x74\x77\x61\x72\x65\x0D\x3B\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "roc" },
    { 48, "\x50\x49\x41\x46\x49\x4C\x45\x56\x45\x52\x53\x49\x4F\x4E\x5F\x32\x2E\x30\x2C\x53\x54\x42\x56\x45\x52\x31\x2C\x63\x6F\x6D\x70\x72\x65\x73\x73\x0D\x0A\x70\x6D\x7A\x6C\x69\x62\x63\x6F\x64\x65\x63", "stb" },
    { 48, "\x50\x49\x41\x46\x49\x4C\x45\x56\x45\x52\x53\x49\x4F\x4E\x5F\x32\x2E\x30\x2C\x43\x54\x42\x56\x45\x52\x31\x2C\x63\x6F\x6D\x70\x72\x65\x73\x73\x0D\x0A\x70\x6D\x7A\x6C\x69\x62\x63\x6F\x64\x65\x63", "ctb" },
    { 48, "\x48\x45\x41\x44\x45\x52\x20\x52\x45\x43\x4F\x52\x44\x2A\x2A\x2A\x2A\x2A\x2A\x2A\x4C\x49\x42\x52\x41\x52\x59\x20\x48\x45\x41\x44\x45\x52\x20\x52\x45\x43\x4F\x52\x44\x21\x21\x21\x21\x21\x21\x21", "xpt" },
    { 48, "\x45\x4E\x49\x47\x4D\x41\x20\x42\x49\x4E\x41\x52\x59\x20\x46\x49\x4C\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x69\x6E\x61\x6C\x65\x28\x52\x29\x20\x47\x75\x69\x74\x61\x72", "mus" },
    { 47, "\x50\x68\x6F\x74\x6F\x64\x65\x78\x28\x52\x29\x20\x50\x72\x6F\x53\x68\x6F\x77\x28\x54\x4D\x29\x20\x57\x6F\x72\x6B\x73\x70\x61\x63\x65\x20\x46\x69\x6C\x65\x20\x56\x65\x72\x73\x69\x6F\x6E\x3D", "ppr" },
    { 47, "\x4D\x69\x63\x72\x6F\x73\x6F\x66\x74\x20\x28\x52\x29\x20\x46\x75\x6C\x6C\x2D\x74\x65\x78\x74\x20\x69\x6E\x64\x65\x78\x20\x66\x6F\x72\x6D\x61\x74\x20\x56\x65\x72\x73\x69\x6F\x6E\x20\x31\x2E", "ffx" },
    { 47, "\x45\x4E\x49\x47\x4D\x41\x20\x42\x49\x4E\x41\x52\x59\x20\x46\x49\x4C\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x72\x69\x6E\x74\x4D\x75\x73\x69\x63\x21\x28\x52\x29\x20", "mus" },
    { 46, "\x00\x01\x00\x00\x00\xFF\xFF\xFF\xFF\x01\x00\x00\x00\x00\x00\x00\x00\x0C\x02\x00\x00\x00\x47\x44\x72\x61\x77\x54\x6F\x6F\x6C\x73\x2C\x20\x56\x65\x72\x73\x69\x6F\x6E\x3D\x31\x2E\x30\x2E", "cwr" },
    { 45, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x49\x53\x4F\x2D\x38\x38\x35\x39\x2D\x31\x22\x3F\x3E\x0D\x0A", "wsp" },
    { 44, "\xD0\xCF\x11\xE0\xA1\xB1\x1A\xE1\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3E\x00\x03\x00\xFE\xFF\x09\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "anb" },
    { 44, "\xD0\xCF\x11\xE0\xA1\xB1\x1A\xE1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3E\x00\x03\x00\xFE\xFF\x09\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "fpx" },
    { 44, "\x4E\x56\x46\x20\x01\x00\x00\x00\x20\x00\x00\x00\x56\x46\x4D\x54\x01\x00\x00\x00\x14\x00\x00\x00\x00\x7D\x00\x00\x00\x00\x01\x00\x40\x1F\x00\x00\x80\x3E\x00\x00\x02\x00\x10\x00", "nvf" },
    { 44, "\x3C\x42\x75\x72\x6E\x57\x69\x7A\x61\x72\x64\x3E\x3C\x43\x6F\x6E\x74\x65\x6E\x74\x3E\x3C\x43\x6F\x6E\x74\x65\x6E\x74\x46\x69\x6C\x65\x20\x46\x69\x6C\x65\x6E\x61\x6D\x65\x3D\x22", "msdvd" },
    { 44, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x27\x31\x2E\x30\x27\x3F\x3E\x3C\x66\x69\x72\x65\x66\x6C\x79\x5F\x66\x6F\x72\x6D\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22", "frm" },
    { 44, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0D\x0A\x3C\x4F\x76\x65\x72\x44\x72\x69\x76\x65\x4D\x65\x64\x69\x61\x20\x69\x64\x3D\x22\x44", "odm" },
    { 44, "\x22\x4B\x41\x52\x41\x4F\x4B\x45\x20\x53\x4F\x4E\x47\x20\x4C\x49\x53\x54\x20\x43\x52\x45\x41\x54\x4F\x52\x20\x43\x44\x20\x53\x45\x4C\x45\x43\x54\x49\x4F\x4E\x20\x46\x49\x4C\x45", "ksl" },
    { 44, "\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x3F\xB0\x00\x00\x00\x00\x00\x00\x00\x00\x50\x61\x6E\x61\x73\x6F\x6E\x69\x63\x20\x4E\x65\x74\x77\x6F\x72\x6B\x20\x43\x61\x6D\x65\x72\x61", "pnc" },
    { 43, "\xFF\xFF\x01\x00\x1D\x00\x43\x43\x75\x73\x74\x6F\x6D\x4E\x61\x74\x75\x72\x61\x6C\x4D\x65\x64\x69\x61\x53\x74\x72\x6F\x6B\x65\x46\x69\x6C\x65\xC4\x1D\x00\x00\x02\x00\x00\x00", "npm" },
    { 43, "\xEF\xBB\xBF\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x75\x74\x66\x2D\x38\x22\x3F\x3E\x0D\x0A", "application" },
    { 43, "\x49\x44\x33\x03\x00\x00\x00\x00\x0A\x23\x54\x49\x54\x32\x00\x00\x00\x10\x00\x00\x00\x41\x6C\x62\x75\x6D\x57\x72\x61\x70\x20\x41\x6C\x62\x75\x6D\x54\x41\x4C\x42\x00\x00\x00", "mp3" },
    { 43, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x20\x3D\x20\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x20\x3D\x20\x22\x75\x74\x66\x2D\x38\x22\x20\x3F\x3E", "proj" },
    { 42, "\xFF\xFE\x32\x00\x30\x00\x30\x00\x09\x00\x50\x00\x49\x00\x54\x00\x5F\x00\x43\x00\x4F\x00\x4E\x00\x54\x00\x41\x00\x43\x00\x54\x00\x09\x00\x32\x00\x30\x00\x32\x00\x09\x00", "ncc" },
    { 42, "\x45\x4E\x49\x47\x4D\x41\x20\x42\x49\x4E\x41\x52\x59\x20\x46\x49\x4C\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x69\x6E\x61\x6C\x65\x28\x52\x29\x20", "mus" },
    { 42, "\x30\x31\x4F\x52\x44\x4E\x41\x4E\x43\x45\x20\x53\x55\x52\x56\x45\x59\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20", "ntf" },
    { 42, "\x23\x20\x6F\x74\x6F\x20\x70\x72\x6F\x6A\x65\x63\x74\x20\x66\x69\x6C\x65\x20\x67\x65\x6E\x65\x72\x61\x74\x65\x64\x20\x62\x79\x20\x61\x75\x74\x6F\x70\x61\x6E\x6F\x0D\x0A", "oto" },
    { 42, "\x23\x0D\x0A\x23\x20\x43\x6F\x6E\x66\x69\x67\x75\x72\x61\x74\x69\x6F\x6E\x20\x66\x69\x6C\x65\x20\x66\x6F\x72\x20\x6F\x6C\x73\x72\x2E\x6F\x72\x67\x20\x6F\x6C\x73\x72\x64", "olsr" },
    { 42, "\x1C\x01\x00\x00\x02\x00\x04\x1C\x01\x14\x00\x02\x00\x14\x1C\x01\x16\x00\x02\x00\x08\x1C\x01\x1E\x00\x0A\x46\x72\x65\x65\x48\x61\x6E\x64\x31\x30\x1C\x01\x28\x00\x08\x31", "fh10" },
    { 42, "\x04\x03\x02\x01\x1A\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x03\x00\x00\x00\x02\x00\x00\x00\x01\x00\x00\x00\x0A\x00\x00\x00\x53\x63\x65\x6E\x65\x20\x52\x6F\x6F\x74", "ive" },
    { 41, "\xEF\xBB\xBF\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x75\x74\x66\x2D\x38\x22\x3F\x3E", "xrm-ms" },
    { 41, "\x53\x69\x67\x6E\x61\x74\x75\x72\x65\x20\x66\x69\x6C\x65\x20\x73\x79\x73\x74\x65\x6D\x20\x28\x63\x29\x20\x50\x61\x6E\x64\x61\x20\x53\x6F\x66\x74\x77\x61\x72\x65\x2E", "sig" },
    { 41, "\x3A\x01\x01\x00\x00\x20\x00\x00\x00\x2D\x2D\x3E\x20\x47\x65\x6E\x65\x72\x61\x74\x65\x64\x20\x62\x79\x20\x52\x65\x70\x6F\x72\x74\x53\x6D\x69\x74\x68\x20\x3C\x2D\x2D", "rpt" },
    { 41, "\x28\x54\x68\x69\x73\x20\x66\x69\x6C\x65\x20\x6D\x75\x73\x74\x20\x62\x65\x20\x63\x6F\x6E\x76\x65\x72\x74\x65\x64\x20\x77\x69\x74\x68\x20\x42\x69\x6E\x48\x65\x78\x20", "hqx" },
    { 41, "\x00\x01\x24\x24\x24\x24\x29\x28\x63\x29\x32\x30\x30\x30\x20\x49\x6E\x73\x70\x69\x72\x61\x74\x69\x6F\x6E\x20\x53\x6F\x66\x74\x77\x61\x72\x65\x2C\x20\x49\x6E\x63\x2E", "kid" },
    { 40, "\xFF\xFE\x3C\x00\x3F\x00\x78\x00\x6D\x00\x6C\x00\x20\x00\x76\x00\x65\x00\x72\x00\x73\x00\x69\x00\x6F\x00\x6E\x00\x3D\x00\x22\x00\x31\x00\x2E\x00\x30\x00\x22\x00", "vmc" },
    { 40, "\x5B\x56\x65\x72\x73\x69\x6F\x6E\x5D\x0D\x0A\x09\x42\x6C\x61\x63\x6B\x57\x69\x64\x6F\x77\x20\x57\x45\x42\x20\x46\x69\x6C\x65\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "web" },
    { 40, "\x5B\x46\x4C\x45\x58\x49\x54\x20\x4D\x75\x6C\x74\x69\x73\x68\x6F\x74\x20\x53\x75\x72\x76\x65\x79\x20\x52\x61\x77\x20\x44\x61\x74\x61\x20\x46\x69\x6C\x65\x3A\x76", "rsy" },
    { 40, "\x53\x74\x61\x6E\x66\x6F\x72\x64\x20\x52\x65\x73\x65\x61\x72\x63\x68\x20\x53\x79\x73\x74\x65\x6D\x73\x20\x4F\x70\x74\x69\x6D\x6C\x65\x6C\x74\x20\x46\x69\x6C\x65", "op2" },
    { 40, "\x4D\x43\x57\x20\x54\x65\x63\x68\x6E\x6F\x67\x6F\x6C\x69\x65\x73\x20\x49\x6E\x63\x2E\x20\x54\x61\x72\x67\x65\x74\x45\x78\x70\x72\x65\x73\x73\x20\x66\x69\x6C\x65", "mte" },
    { 40, "\x3C\x73\x76\x67\x20\x78\x6D\x6C\x6E\x73\x3D\x22\x68\x74\x74\x70\x3A\x2F\x2F\x77\x77\x77\x2E\x77\x33\x2E\x6F\x72\x67\x2F\x32\x30\x30\x30\x2F\x73\x76\x67\x22\x20", "fmd" },
    { 40, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22\x3F\x3E\x0D\x0A", "cdm" },
    { 40, "\x2F\x2F\x20\x48\x79\x64\x72\x6F\x43\x41\x44\x20\x53\x74\x6F\x72\x61\x67\x65\x20\x43\x68\x61\x6D\x62\x65\x72\x20\x44\x65\x66\x69\x6E\x69\x74\x69\x6F\x6E\x0D\x0A", "hcc" },
    { 39, "\xEF\xBB\xBF\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22", "xml" },
    { 39, "\x52\x69\x6A\x6E\x64\x61\x65\x6C\x20\x45\x6E\x63\x72\x79\x70\x74\x65\x64\x20\x46\x69\x6C\x65\x20\x28\x50\x6F\x77\x65\x72\x41\x72\x63\x68\x69\x76\x65\x72\x20", "pae" },
    { 39, "\x47\x00\x4F\x00\x4C\x00\x44\x00\x20\x00\x50\x00\x61\x00\x72\x00\x73\x00\x65\x00\x72\x00\x20\x00\x54\x00\x61\x00\x62\x00\x6C\x00\x65\x00\x73\x00\x2F\x00\x76", "cgt" },
    { 39, "\x42\x69\x65\x77\x20\x58\x6C\x61\x74\x20\x54\x61\x62\x6C\x65\x2E\x20\x43\x6F\x6E\x76\x65\x72\x74\x73\x20\x66\x72\x6F\x6D\x20\x72\x75\x73\x73\x69\x61\x6E\x20", "xlt" },
    { 39, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22\x20\x3F\x3E", "xml" },
    { 39, "\x3C\x21\x44\x4F\x43\x54\x59\x50\x45\x20\x6B\x73\x75\x64\x6F\x6B\x75\x2D\x67\x72\x61\x70\x68\x3E\x0A\x3C\x6B\x73\x75\x64\x6F\x6B\x75\x2D\x67\x72\x61\x70\x68", "xml" },
    { 38, "\x57\x69\x6E\x64\x6F\x77\x73\x20\x52\x65\x67\x69\x73\x74\x72\x79\x20\x45\x64\x69\x74\x6F\x72\x20\x56\x65\x72\x73\x69\x6F\x6E\x20\x35\x2E\x30\x30\x0D\x0A", "reg" },
    { 38, "\x54\x68\x69\x73\x20\x69\x73\x20\x46\x53\x43\x20\x52\x61\x74\x65\x72\x27\x73\x20\x70\x72\x69\x6D\x61\x72\x79\x20\x64\x61\x74\x61\x20\x66\x69\x6C\x65\x2E", "dat" },
    { 38, "\x4D\x65\x74\x61\x73\x65\x71\x75\x6F\x69\x61\x20\x44\x6F\x63\x75\x6D\x65\x6E\x74\x0D\x0A\x46\x6F\x72\x6D\x61\x74\x20\x54\x65\x78\x74\x20\x56\x65\x72\x20", "mqo" },
    { 38, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0D\x0A\x3C\x21\x2D\x2D\x20\x41\x72\x74\x77\x65\x61\x76\x65\x72\x20", "xml" },
    { 38, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x75\x74\x66\x2D\x38\x22\x3F\x3E", "resx" },
    { 38, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22\x3F\x3E", "djx" },
    { 38, "\x34\x42\x41\x53\x1A\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1E\x00\x00\x00\x39\x73\x33\x33\x53\x54\x41\x4E\x44\x41\x52\x44\x00", "" },
    { 38, "\x00\x00\x01\x5C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "nii" },
    { 37, "\x90\xFF\x57\x50\x53\x32\x30\x30\x31\xAE\x20\x66\x6F\x72\x20\x57\x69\x6E\x64\x6F\x77\x73\x20\x4B\x69\x6E\x67\x73\x6F\x66\x74\xA9\x20\x32\x30\x30\x31", "wps" },
    { 37, "\x56\x45\x52\x53\x49\x4F\x4E\x20\x31\x2E\x30\x0D\x0A\x55\x4E\x49\x54\x53\x20\x50\x69\x78\x65\x6C\x73\x0D\x0A\x42\x45\x47\x49\x4E\x20\x56\x50\x42\x5F", "frm" },
    { 37, "\x56\x42\x41\x33\x32\x20\x56\x69\x72\x75\x73\x20\x44\x61\x74\x61\x62\x61\x73\x65\x20\x55\x70\x64\x61\x74\x65\x2C\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "udb" },
    { 37, "\x4F\x7A\x69\x45\x78\x70\x6C\x6F\x72\x65\x72\x20\x54\x72\x61\x63\x6B\x20\x50\x6F\x69\x6E\x74\x20\x46\x69\x6C\x65\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "plt" },
    { 37, "\x4D\x65\x74\x61\x73\x65\x71\x75\x6F\x69\x61\x20\x50\x61\x6C\x65\x74\x74\x65\x0D\x0A\x46\x6F\x72\x6D\x61\x74\x20\x54\x65\x78\x74\x20\x56\x65\x72\x20", "mqp" },
    { 37, "\x4C\x45\x4F\x4C\x5A\x57\x20\x2D\x20\x28\x63\x29\x20\x4C\x65\x6F\x6E\x61\x72\x64\x75\x73\x20\x4C\x65\x6F\x6E\x61\x72\x64\x69\x20\x31\x39\x39\x33\x1A", "pll" },
    { 37, "\x49\x6E\x74\x65\x72\x40\x63\x74\x69\x76\x65\x20\x50\x61\x67\x65\x72\x20\x42\x61\x63\x6B\x75\x70\x2F\x52\x65\x73\x74\x6F\x72\x65\x20\x46\x69\x6C\x65", "ipd" },
    { 37, "\x48\x65\x6C\x69\x78\x20\x53\x74\x72\x6F\x6E\x67\x68\x6F\x6C\x64\x20\x45\x6E\x63\x72\x79\x70\x74\x65\x64\x20\x46\x69\x6C\x65\x1A\x73\x61\x66\x65\x25", "saf" },
    { 37, "\x44\x69\x67\x69\x74\x61\x6C\x20\x54\x72\x61\x69\x6E\x65\x72\x20\x45\x6E\x63\x72\x79\x70\x74\x65\x64\x20\x53\x63\x6F\x72\x65\x20\x46\x69\x6C\x65\x1A", "edf" },
    { 37, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22\x3F", "mscx" },
    { 37, "\x01\x00\x20\x00\x00\x00\x80\x02\x43\x41\x2D\x56\x4F\x20\x41\x70\x70\x6C\x69\x63\x61\x74\x69\x6F\x6E\x20\x45\x78\x70\x6F\x72\x74\x20\x46\x69\x6C\x65", "aef" },
    { 36, "\xFF\xFE\x73\x00\x63\x00\x72\x00\x65\x00\x65\x00\x6E\x00\x20\x00\x6D\x00\x6F\x00\x64\x00\x65\x00\x20\x00\x69\x00\x64\x00\x3A\x00\x69\x00\x3A\x00", "rdp" },
    { 36, "\x52\x34\x20\x43\x68\x65\x61\x74\x43\x6F\x64\x65\x00\x01\x00\x00\x55\x73\x65\x72\x20\x63\x68\x65\x61\x74\x20\x63\x6F\x64\x65\x20\x76\x31\x2E\x30", "dat" },
    { 36, "\x4D\x53\x4D\x43\x6F\x6D\x70\x72\x65\x73\x73\x65\x64\x45\x6C\x65\x63\x74\x72\x6F\x6E\x69\x63\x73\x57\x6F\x72\x6B\x62\x65\x6E\x63\x68\x58\x4D\x4C", "ms8" },
    { 36, "\x41\x64\x64\x69\x63\x74\x20\x44\x69\x63\x74\x69\x6F\x6E\x61\x72\x79\x20\x43\x6F\x6D\x70\x69\x6C\x65\x72\x2C\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "adm" },
    { 36, "\x3C\x47\x52\x41\x50\x48\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3E\x0D\x0A\x09\x3C\x46\x49\x4C\x54\x45\x52\x20\x49\x44\x3D\x22", "xgr" },
    { 36, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x27\x31\x2E\x30\x27\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x27\x75\x74\x66\x2D\x38\x27", "bpr" },
    { 36, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x75\x74\x66\x2D\x38\x22", "dae" },
    { 36, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54\x46\x2D\x38\x22", "xrp" },
    { 36, "\x3B\x0D\x0A\x3B\x20\x48\x6F\x6E\x64\x61\x74\x61\x20\x4B\x2D\x4D\x61\x6E\x61\x67\x65\x72\x20\x43\x61\x6C\x69\x62\x72\x61\x74\x69\x6F\x6E\x0D\x0A", "kal" },
    { 36, "\x22\x46\x49\x4C\x45\x22\x3D\x22\x58\x74\x65\x71\x20\x53\x79\x73\x74\x65\x6D\x73\x20\x58\x2D\x53\x65\x74\x75\x70\x20\x50\x6C\x75\x67\x69\x6E\x20", "xpl" },
    { 36, "\x1C\x27\x6A\x09\x7B\x4B\x4B\x0C\xA8\x8D\x36\x08\x3C\x35\x51\x54\x00\x00\x00\x00\xF3\xD6\xB0\xB1\x3E\x87\x40\xF5\x96\xE6\xC1\xEF\xA5\xCF\x91\xF7", "model" },
    { 36, "\x1C\x01\x00\x00\x02\x00\x04\x1C\x01\x14\x00\x02\x00\x14\x1C\x01\x16\x00\x02\x00\x09\x1C\x01\x1E\x00\x0A\x46\x72\x65\x65\x48\x61\x6E\x64\x31\x31", "fh11" },
    { 35, "\x62\x69\x7A\x20\x76\x31\x2E\x30\x20\x28\x63\x29\x20\x44\x49\x56\x49\x53\x49\x4F\x4E\x20\x4C\x74\x64\x20\x31\x39\x39\x32\x00\x22\x00\x00\x00", "biz" },
    { 35, "\x50\x52\x4F\x53\x50\x41\x43\x45\x20\x53\x43\x48\x45\x4D\x41\x54\x49\x43\x20\x46\x49\x4C\x45\x0D\x0A\x3B\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "psa" },
    { 35, "\x50\x43\x42\x0D\x0A\x44\x61\x74\x61\x20\x53\x74\x72\x75\x63\x74\x75\x72\x65\x20\x41\x63\x63\x65\x73\x73\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "pcb" },
    { 35, "\x4F\x70\x65\x72\x61\x20\x48\x6F\x74\x6C\x69\x73\x74\x20\x76\x65\x72\x73\x69\x6F\x6E\x20\x32\x2E\x30\x0D\x0A\x4F\x70\x74\x69\x6F\x6E\x73\x3A", "adr" },
    { 35, "\x4D\x65\x74\x61\x73\x65\x71\x75\x6F\x69\x61\x20\x42\x72\x75\x73\x68\x0D\x0A\x46\x6F\x72\x6D\x61\x74\x20\x54\x65\x78\x74\x20\x56\x65\x72\x20", "mqb" },
    { 35, "\x43\x56\x6D\x4C\x69\x73\x74\x4D\x44\x46\x30\x30\x30\x31\x0D\x0A\x7B\x0D\x0A\x48\x65\x61\x64\x65\x72\x0D\x0A\x7B\x0D\x0A\x0D\x0A\x30\x0D\x0A", "mtp" },
    { 35, "\x41\x4C\x49\x43\x01\x00\x00\x00\x17\x00\x00\x00\x41\x6C\x69\x63\x65\x20\x41\x72\x63\x68\x69\x76\x65\x20\x56\x65\x72\x73\x69\x6F\x6E\x20\x31", "spv" },
    { 35, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x27\x31\x2E\x30\x27\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x27\x75\x74\x66\x2D\x38", "jsf" },
    { 35, "\x2F\x2F\x20\x48\x79\x64\x72\x6F\x43\x41\x44\x20\x55\x6E\x69\x74\x20\x48\x79\x64\x72\x6F\x67\x72\x61\x70\x68\x20\x74\x61\x62\x6C\x65\x0D\x0A", "huh" },
    { 35, "\x2A\x49\x6E\x66\x6F\x20\x31\x3A\x20\x44\x65\x73\x6B\x54\x6F\x70\x20\x47\x75\x69\x74\x61\x72\x69\x73\x74\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "dtg" },
    { 35, "\x00\x00\x00\x0C\x6A\x50\x20\x20\x0D\x0A\x87\x0A\x00\x00\x00\x14\x66\x74\x79\x70\x6A\x70\x32\x20\x00\x00\x00\x00\x6A\x70\x32\x20\x00\x00\x00", "jp2" },
    { 34, "\x54\x65\x72\x72\x61\x42\x79\x74\x65\x20\x4C\x6F\x63\x61\x74\x69\x6F\x6E\x20\x46\x69\x6C\x65\x20\x43\x6F\x70\x79\x72\x69\x67\x68\x74\x20", "loc" },
    { 34, "\x51\x75\x69\x63\x6B\x20\x41\x72\x63\x68\x69\x76\x65\x20\xA9\x32\x30\x30\x33\x20\x4A\x75\x6C\x69\x61\x6E\x20\x53\x70\x65\x6E\x63\x65\x72", "ata" },
    { 34, "\x50\x65\x72\x46\x4F\x52\x4D\x20\x43\x6F\x6D\x6D\x75\x6E\x69\x63\x61\x74\x6F\x72\x20\x46\x69\x6C\x65\x20\x50\x61\x63\x6B\x65\x74\x20\x76", "fpk" },
    { 34, "\x4F\x7A\x69\x45\x78\x70\x6C\x6F\x72\x65\x72\x20\x57\x61\x79\x70\x6F\x69\x6E\x74\x20\x46\x69\x6C\x65\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "wpt" },
    { 34, "\x4F\x7A\x69\x45\x78\x70\x6C\x6F\x72\x65\x72\x20\x4D\x61\x70\x20\x44\x61\x74\x61\x20\x46\x69\x6C\x65\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "map" },
    { 34, "\x4D\x61\x70\x20\x53\x6C\x69\x63\x65\x73\x20\x43\x61\x6C\x69\x62\x72\x61\x74\x69\x6F\x6E\x20\x64\x61\x74\x61\x20\x66\x69\x6C\x65\x20\x76", "gsi" },
    { 34, "\x45\x6C\x65\x63\x74\x72\x6F\x6E\x69\x63\x73\x20\x57\x6F\x72\x6B\x62\x65\x6E\x63\x68\x20\x43\x69\x72\x63\x75\x69\x74\x20\x46\x69\x6C\x65", "ewb" },
    { 34, "\x45\x58\x54\x45\x4E\x44\x45\x44\x20\x43\x50\x43\x20\x44\x53\x4B\x20\x46\x69\x6C\x65\x0D\x0A\x44\x69\x73\x6B\x2D\x49\x6E\x66\x6F\x0D\x0A", "dsk" },
    { 34, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0D\x0A\x3C\x50\x41\x43\x4B\x41\x47\x45\x3E\x0D\x0A", "rmp" },
    { 34, "\x2A\x2A\x20\x54\x68\x69\x73\x20\x66\x69\x6C\x65\x20\x63\x6F\x6E\x74\x61\x69\x6E\x73\x20\x61\x6E\x20\x53\x51\x4C\x69\x74\x65\x20\x32\x2E", "" },
    { 34, "\x2A\x2A\x20\x51\x75\x65\x73\x74\x69\x6F\x6E\x6E\x61\x69\x72\x65\x20\x66\x6F\x72\x20\x51\x75\x69\x7A\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "qzd" },
    { 34, "\x23\x20\x50\x65\x70\x61\x6B\x75\x72\x61\x20\x44\x65\x73\x69\x67\x6E\x65\x72\x20\x57\x6F\x72\x6B\x20\x49\x6E\x66\x6F\x20\x76\x65\x72\x20", "pdo" },
    { 34, "\x0D\x0A\x20\x46\x41\x53\x34\x2D\x46\x49\x4C\x45\x20\x3B\x20\x44\x6F\x20\x6E\x6F\x74\x20\x63\x68\x61\x6E\x67\x65\x20\x69\x74\x21\x0D\x0A", "fas" },
    { 34, "\x01\x53\x59\x53\x54\x45\x4D\x45\x20\x44\x27\x41\x52\x43\x48\x49\x56\x41\x47\x45\x20\x50\x55\x4B\x41\x4C\x4C\x20\x53\x2E\x41\x2E\x50\x2E", "sap" },
    { 34, "\x00\x00\x00\x20\x66\x74\x79\x70\x4D\x34\x41\x20\x00\x00\x00\x00\x4D\x34\x41\x20\x6D\x70\x34\x32\x69\x73\x6F\x6D\x00\x00\x00\x00\x00\x00", "m4a" },
    { 34, "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xC2\xEA\x81\x60\xB3\x14\x11\xCF\xBD\x92\x08\x00\x09\xC7\x31\x8C\x18\x1F\x10\x11\x22\x22", "sas7bdat" },
    { 33, "\xD0\xCF\x11\xE0\xA1\xB1\x1A\xE1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3E\x00\x03\x00\xFE\xFF\x09\x00\x06", "e3" },
    { 33, "\x5B\x42\x41\x53\x20\x46\x69\x6C\x65\x73\x5D\x0D\x0A\x50\x72\x69\x6D\x61\x72\x79\x20\x53\x6F\x75\x72\x63\x65\x20\x46\x69\x6C\x65\x3D", "spf" },
    { 33, "\x54\x65\x61\x6D\x56\x69\x65\x77\x65\x72\x20\x53\x65\x73\x73\x69\x6F\x6E\x20\x46\x69\x6C\x65\x0D\x0A\x56\x65\x72\x73\x69\x6F\x6E\x20", "tvs" },
    { 33, "\x52\x44\x4B\x20\x54\x52\x41\x4D\x50\x20\x31\x2E\x30\x20\x28\x43\x29\x20\x31\x39\x38\x37\x2C\x4D\x75\x65\x6E\x63\x68\x65\x6E\x00\x1A", "trp" },
    { 33, "\x4D\x69\x63\x72\x6F\x53\x74\x61\x74\x69\x6F\x6E\x20\x53\x79\x6D\x62\x6F\x6C\x6F\x67\x79\x20\x52\x65\x73\x6F\x75\x72\x63\x65\x73\x1A", "rsc" },
    { 33, "\x4C\x6F\x67\x66\x69\x6C\x65\x20\x6F\x66\x20\x54\x72\x65\x6E\x64\x20\x4D\x69\x63\x72\x6F\x20\x48\x69\x6A\x61\x63\x6B\x54\x68\x69\x73", "log" },
    { 33, "\x43\x6F\x6D\x70\x72\x65\x73\x73\x65\x64\x45\x6C\x65\x63\x74\x72\x6F\x6E\x69\x63\x73\x57\x6F\x72\x6B\x62\x65\x6E\x63\x68\x58\x4D\x4C", "ewprj" },
    { 33, "\x3C\x7E\x41\x5A\x5A\x20\x43\x41\x52\x44\x46\x49\x4C\x45\x20\x41\x5A\x5A\x20\x46\x49\x4C\x45\x20\x56\x45\x52\x53\x49\x4F\x4E\x7E\x3E", "~i" },
    { 33, "\x2D\x2D\x42\x45\x47\x49\x4E\x20\x52\x4F\x55\x54\x45\x52\x4F\x53\x20\x53\x55\x50\x4F\x55\x54\x20\x53\x45\x43\x54\x49\x4F\x4E\x0D\x0A", "rif" },
    { 33, "\x25\x20\x44\x72\x61\x77\x69\x6E\x67\x20\x67\x65\x6E\x65\x72\x61\x74\x65\x64\x20\x62\x79\x20\x4C\x61\x54\x65\x58\x2D\x43\x41\x44\x20", "lp" },
    { 33, "\x23\x23\x53\x54\x41\x52\x54\x20\x42\x41\x44\x4F\x4E\x47\x4F\x20\x46\x49\x4C\x45\x0A\x54\x4F\x54\x41\x4C\x5F\x50\x41\x52\x54\x53\x3D", "badongo" },
    { 32, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", "pcd" },
    { 32, "\xFF\xFE\xFF\x0E\x53\x00\x6B\x00\x65\x00\x74\x00\x63\x00\x68\x00\x55\x00\x70\x00\x20\x00\x4D\x00\x6F\x00\x64\x00\x65\x00\x6C\x00", "skp" },
    { 32, "\xFF\xFE\x3C\x00\x3F\x00\x78\x00\x6D\x00\x6C\x00\x20\x00\x76\x00\x65\x00\x72\x00\x73\x00\x69\x00\x6F\x00\x6E\x00\x3D\x00\x22\x00", "fsp" },
    { 32, "\x70\x00\x00\x00\x00\x00\x00\x00\x1B\xA3\xD6\x46\x11\xCC\xAE\x15\x13\x23\xFB\x72\x92\x5E\x1D\x7E\x68\xA1\xF8\xBA\x75\x97\x7B\x1A", "ezlog" },
    { 32, "\x5B\x4D\x6F\x6E\x6B\x65\x79\x27\x73\x20\x41\x75\x64\x69\x6F\x20\x49\x6D\x61\x67\x65\x20\x4C\x69\x6E\x6B\x20\x46\x69\x6C\x65\x5D", "apl" },
    { 32, "\x5A\x69\x6C\x6C\x69\x6F\x6E\x73\x20\x53\x61\x76\x65\x20\x47\x61\x6D\x65\x20\x46\x69\x6C\x65\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "zsg" },
    { 32, "\x52\x4D\x50\x42\x4D\x48\x4C\x4D\x4B\x59\x49\x44\x48\x53\x46\x48\x44\x4D\x42\x4A\x50\x41\x4C\x4A\x45\x52\x42\x4A\x54\x59\x4D\x41", "bdf" },
    { 32, "\x52\x49\x46\x46\x00\x00\x00\x00\x46\x4F\x52\x43\x5C\x77\x7E\x19\xBA\x34\xD3\x11\xAB\xD5\x00\xC0\x4F\x8E\xC6\x27\x4C\x49\x53\x54", "ffe" },
    { 32, "\x50\x72\x6F\x70\x65\x6C\x6C\x65\x72\x68\x65\x61\x64\x73\x20\x52\x65\x61\x73\x6F\x6E\x20\x53\x6F\x6E\x67\x20\x46\x69\x6C\x65\x1A", "rns" },
    { 32, "\x4F\x5A\xDD\x12\x66\x0C\x00\x00\x00\x00\x64\x00\x01\x00\x00\x00\x00\x00\x4F\x5A\xE0\x0C\x2B\x95\x00\x00\x00\x00\x00\x00\x4F\x5A", "zet" },
    { 32, "\x4E\x6F\x63\x61\x73\x68\x47\x62\x61\x42\x61\x63\x6B\x75\x70\x4D\x65\x64\x69\x61\x53\x61\x76\x44\x61\x74\x61\x46\x69\x6C\x65\x1A", "sav" },
    { 32, "\x4E\x65\x74\x49\x6D\x6D\x65\x72\x73\x65\x20\x46\x69\x6C\x65\x20\x46\x6F\x72\x6D\x61\x74\x2C\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "nif" },
    { 32, "\x43\x4F\x56\x45\x52\x20\x45\x44\x49\x54\x4F\x52\x11\x09\x19\x77\xD5\xBF\x41\x37\x01\x00\x01\x00\x00\x00\x6C\x5B\x01\x01\x01\x00", "nct" },
    { 32, "\x42\x72\x6F\x74\x68\x65\x72\x20\x45\x6D\x62\x72\x6F\x69\x64\x65\x72\x79\x20\x53\x79\x73\x74\x65\x6D\x20\x46\x6F\x6E\x74\x0D\x0A", "bfn" },
    { 32, "\x41\x64\x76\x65\x6E\x74\x75\x72\x65\x20\x47\x61\x6D\x65\x20\x53\x74\x75\x64\x69\x6F\x20\x73\x61\x76\x65\x64\x20\x67\x61\x6D\x65", "" },
    { 32, "\x41\x64\x64\x69\x63\x74\x20\x55\x73\x65\x72\x20\x44\x69\x63\x74\x69\x6F\x6E\x61\x72\x79\x2C\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "adu" },
    { 32, "\x3C\x4C\x45\x41\x50\x54\x4F\x46\x52\x4F\x47\x41\x4E\x53\x20\x41\x44\x44\x52\x45\x53\x53\x3D\x22\x66\x72\x6F\x67\x61\x6E\x73\x2A", "ltf" },
    { 32, "\x2A\x2A\x20\x54\x68\x69\x73\x20\x66\x69\x6C\x65\x20\x63\x6F\x6E\x74\x61\x69\x6E\x73\x20\x61\x6E\x20\x53\x51\x4C\x69\x74\x65\x20", "kexi" },
    { 32, "\x2A\x20\x50\x53\x70\x69\x63\x65\x20\x4D\x6F\x64\x65\x6C\x20\x45\x64\x69\x74\x6F\x72\x20\x2D\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "lib" },
    { 32, "\x00\x00\x00\x00\x02\x00\x00\x00\x0B\x00\x00\x00\x0C\x00\x00\x00\x04\x00\x00\x00\xFF\xFF\xFF\xFF\x00\x00\x00\x00\x0C\x00\x00\x00", "fpf" },
    { 31, "\x5B\x54\x6F\x6D\x54\x6F\x6D\x20\x4E\x41\x56\x49\x47\x41\x54\x4F\x52\x5D\x0D\x0A\x44\x65\x76\x69\x63\x65\x4E\x61\x6D\x65\x3D", "bif" },
    { 31, "\x5B\x42\x72\x75\x74\x75\x73\x20\x41\x70\x70\x6C\x69\x63\x61\x74\x69\x6F\x6E\x20\x44\x65\x66\x69\x6E\x69\x74\x69\x6F\x6E\x5D", "bad" },
    { 31, "\x56\x65\x72\x73\x69\x6F\x6E\x20\x20\x3D\x20\x56\x6F\x6C\x6C\x65\x79\x62\x61\x6C\x6C\x20\x50\x6C\x61\x79\x62\x6F\x6F\x6B\x20", "ebp" },
    { 31, "\x50\x6F\x77\x65\x72\x42\x61\x73\x69\x63\x20\x43\x6F\x6E\x66\x69\x67\x75\x72\x61\x74\x69\x6F\x6E\x20\x46\x69\x6C\x65\x20\x1A", "pb" },
    { 31, "\x50\x69\x63\x74\x75\x72\x65\x20\x50\x75\x6D\x70\x20\x50\x72\x6F\x6A\x65\x63\x74\x20\x46\x69\x6C\x65\x20\x31\x2E\x30\x0D\x0A", "ppp" },
    { 31, "\x4D\x41\x54\x4C\x41\x42\x20\x35\x2E\x30\x20\x4D\x41\x54\x2D\x66\x69\x6C\x65\x2C\x20\x50\x6C\x61\x74\x66\x6F\x72\x6D\x3A\x20", "mat" },
    { 31, "\x43\x61\x6C\x69\x67\x61\x72\x69\x20\x56\x30\x30\x2E\x30\x31\x42\x4C\x48\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20", "cob" },
    { 31, "\x3C\x21\x2D\x2D\x20\x46\x61\x73\x6F\x6F\x53\x65\x63\x75\x72\x65\x43\x6F\x6E\x74\x61\x69\x6E\x65\x72\x20\x2D\x20\x56\x65\x72", "" },
    { 31, "\x33\x44\x20\x47\x65\x6F\x6D\x65\x74\x72\x79\x20\x46\x69\x6C\x65\x20\x46\x6F\x72\x6D\x61\x74\x20\x20\x20\x20\x20\x20\x20\x20", "3dm" },
    { 31, "\x25\x54\x68\x69\x73\x20\x69\x73\x20\x61\x20\x47\x52\x41\x46\x49\x54\x20\x6C\x61\x79\x6F\x75\x74\x20\x66\x69\x6C\x65\x2E\x0A", "des" },
    { 31, "\x1C\x00\x00\x00\xDD\x66\x31\xDC\x3A\x08\xD4\x11\xAD\xA1\x00\xA0\xCC\xE4\x56\x56\x00\x00\x00\x00\x00\x00\x00\x00\xC4\x3B\x72", "opd" },
    { 31, "\x00\x0A\x0E\x15\x0E\x16\x1B\xA2\xA6\xAB\x1A\x2A\x2F\xA5\xA9\xB5\xA7\xB5\xD9\x0F\x17\x23\x13\x1F\x2B\x0F\x17\x23\x4F\x57\x63", "map" },
    { 30, "\x62\x65\x67\x69\x6E\x3D\x48\x65\x61\x64\x0D\x0A\x74\x79\x70\x65\x3D\x70\x74\x66\x0D\x0A\x76\x65\x72\x73\x69\x6F\x6E\x3D", "ptf" },
    { 30, "\x5B\x54\x6F\x6D\x54\x6F\x6D\x47\x6F\x5D\x0D\x0A\x44\x65\x76\x69\x63\x65\x4E\x61\x6D\x65\x3D\x54\x6F\x6D\x54\x6F\x6D\x20", "bif" },
    { 30, "\x56\x69\x72\x75\x73\x20\x44\x61\x74\x61\x62\x61\x73\x65\x20\x46\x69\x6C\x65\x0D\x0A\x56\x65\x72\x73\x69\x6F\x6E\x3A\x20", "vdf" },
    { 30, "\x53\x70\x61\x63\x45\x79\x65\x73\x33\x44\x20\x56\x69\x65\x77\x65\x72\x20\x50\x72\x6F\x6A\x65\x63\x74\x20\x46\x69\x6C\x65", "spv" },
    { 30, "\x4F\x62\x4A\x65\x43\x74\x53\x74\x4F\x72\x45\x64\x41\x74\x41\x62\x41\x73\x45\x62\x41\x63\x4B\x75\x50\x69\x4D\x61\x47\x65", "" },
    { 30, "\x4D\x4F\x54\x49\x4F\x4E\x50\x4C\x4F\x54\x20\x45\x58\x54\x45\x52\x4E\x41\x4C\x20\x58\x59\x20\x52\x45\x41\x44\x45\x52\x20", "abf" },
    { 30, "\x47\x61\x6D\x65\x62\x72\x79\x6F\x20\x46\x69\x6C\x65\x20\x46\x6F\x72\x6D\x61\x74\x2C\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "nif" },
    { 30, "\x41\x75\x74\x6F\x53\x6B\x65\x74\x63\x68\x20\x64\x72\x61\x77\x69\x6E\x67\x20\x64\x61\x74\x61\x62\x61\x73\x65\x0D\x0A\x1A", "skd" },
    { 30, "\x40\x43\x6F\x72\x65\x6C\x42\x4D\x46\x0A\x0D\x43\x6F\x72\x65\x6C\x20\x43\x6F\x72\x70\x6F\x72\x61\x74\x69\x6F\x6E\x0A\x0D", "bmf" },
    { 30, "\x3C\x58\x4D\x4C\x3E\x0D\x0A\x3C\x48\x54\x4D\x4C\x48\x65\x6C\x70\x43\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x3E\x0D\x0A\x3C", "col" },
    { 30, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22", "3dxml" },
    { 29, "\x7D\x20\x39\x47\x42\x47\x2D\x56\x7B\x36\x2E\x7B\x30\x7B\x30\x3B\x47\x42\x4C\x49\x42\x2D\x56\x7B\x36\x2E\x7B\x30\x7B", "d" },
    { 29, "\x53\x4E\x4E\x53\x20\x70\x61\x74\x74\x65\x72\x6E\x20\x64\x65\x66\x69\x6E\x69\x74\x69\x6F\x6E\x20\x66\x69\x6C\x65\x20", "pat" },
    { 29, "\x53\x4E\x4E\x53\x20\x6E\x65\x74\x77\x6F\x72\x6B\x20\x64\x65\x66\x69\x6E\x69\x74\x69\x6F\x6E\x20\x66\x69\x6C\x65\x20", "net" },
    { 29, "\x53\x4E\x45\x53\x2D\x53\x50\x43\x37\x30\x30\x20\x53\x6F\x75\x6E\x64\x20\x46\x69\x6C\x65\x20\x44\x61\x74\x61\x20\x76", "spc" },
    { 29, "\x4F\x52\x47\x41\x4E\x49\x5A\x41\x54\x49\x4F\x4E\x5F\x42\x4C\x4F\x43\x4B\x20\x50\x52\x49\x4E\x43\x49\x50\x41\x4C\x3A", "awl" },
    { 29, "\x4D\x61\x73\x74\x65\x72\x43\x6F\x6F\x6B\x20\x4D\x61\x63\x20\x43\x6F\x6F\x6B\x62\x6F\x6F\x6B\x20\x66\x69\x6C\x65\x2E", "" },
    { 29, "\x4D\x61\x6E\x73\x63\x72\x70\x74\x00\x4E\x65\x75\x72\x61\x74\x72\x6F\x6E\x20\x50\x68\x6F\x74\x6F\x53\x63\x6F\x72\x65", "opt" },
    { 29, "\x48\x4E\x53\x4B\x59\x20\x44\x45\x45\x50\x53\x4B\x59\x20\x44\x41\x54\x41\x42\x41\x53\x45\x20\x4C\x45\x56\x45\x4C\x20", "hnd" },
    { 29, "\x46\x43\x57\x20\x28\x46\x61\x73\x74\x43\x41\x44\x20\x66\x6F\x72\x20\x57\x69\x6E\x64\x6F\x77\x73\x29\x20\x37\x2E\x30", "fc7" },
    { 29, "\x44\x45\x52\x49\x56\x45\x20\x66\x6F\x72\x20\x57\x69\x6E\x64\x6F\x77\x73\x20\x76\x65\x72\x73\x69\x6F\x6E\x20\x35\x2E", "dfw" },
    { 29, "\x42\x72\x61\x69\x6E\x42\x6F\x78\x20\x76\x65\x72\x73\x69\x6F\x6E\x3A\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20", "bbx" },
    { 29, "\x3C\x43\x61\x75\x6C\x64\x72\x6F\x6E\x20\x43\x68\x75\x6E\x6B\x20\x46\x69\x6C\x65\x3E\x01\x00\x00\x00\x00\x00\x01\x00", "sav" },
    { 29, "\x00\x00\x00\x64\x43\x72\x65\x61\x74\x65\x64\x20\x62\x79\x20\x53\x6F\x6C\x6F\x20\x45\x78\x70\x6C\x6F\x72\x65\x72\x20", "w2m" },
    { 28, "\xFF\xFE\x3C\x00\x53\x00\x65\x00\x63\x00\x53\x00\x63\x00\x61\x00\x6E\x00\x20\x00\x49\x00\x44\x00\x3D\x00\x22\x00", "mbsa" },
    { 28, "\x65\x4D\x65\x6D\x6F\x50\x61\x64\x20\x44\x61\x74\x61\x20\x46\x69\x6C\x65\x0D\x0A\x56\x65\x72\x73\x69\x6F\x6E\x20", "edf" },
    { 28, "\x57\x61\x72\x63\x72\x61\x66\x74\x20\x49\x49\x49\x20\x72\x65\x63\x6F\x72\x64\x65\x64\x20\x67\x61\x6D\x65\x1A\x00", "w3z" },
    { 28, "\x54\x72\x69\x70\x6F\x64\x20\x44\x61\x74\x61\x20\x53\x79\x73\x74\x65\x6D\x73\x20\x4A\x6F\x62\x20\x46\x69\x6C\x65", "job" },
    { 28, "\x53\x4F\x55\x4E\x44\x1A\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xC0\x5D\x00\x00\x0A\x00\x04\x00", "sndt" },
    { 28, "\x51\x42\x01\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "ini" },
    { 28, "\x50\x9C\xFC\xBE\x1F\x01\xBF\x00\x7E\x57\xB9\x34\x00\xF3\xA4\x8B\x0E\x1C\x01\xBE\x52\x01\xBF\xE8\x80\xF3\xA4\xC3", "com" },
    { 28, "\x50\x65\x72\x46\x4F\x52\x4D\x20\x63\x6F\x6D\x70\x72\x65\x73\x73\x65\x64\x20\x64\x61\x74\x61\x62\x61\x73\x65\x20", "frf" },
    { 28, "\x50\x53\x52\x2D\x39\x30\x30\x30\x20\x76\x65\x72\x31\x2E\x30\x20\x43\x55\x53\x54\x4F\x4D\x20\x56\x4F\x49\x43\x45", "vic" },
    { 28, "\x4C\x59\x31\x44\x4C\x20\x41\x6E\x6F\x74\x68\x65\x72\x20\x63\x61\x72\x64\x66\x69\x6C\x65\x20\x2D\x20\x54\x58\x54", "tmp" },
    { 28, "\x4C\x59\x31\x44\x4C\x20\x41\x6E\x6F\x74\x68\x65\x72\x20\x63\x61\x72\x64\x66\x69\x6C\x65\x20\x2D\x20\x52\x54\x46", "tmp" },
    { 28, "\x49\x6E\x6E\x6F\x20\x53\x65\x74\x75\x70\x20\x55\x6E\x69\x6E\x73\x74\x61\x6C\x6C\x20\x4C\x6F\x67\x20\x28\x62\x29", "dat" },
    { 28, "\x48\x65\x6C\x70\x53\x63\x72\x69\x62\x62\x6C\x65\x20\x70\x72\x6F\x6A\x65\x63\x74\x20\x66\x69\x6C\x65\x2E\x0D\x0A", "hsc" },
    { 28, "\x45\x6C\x6C\x69\x73\x79\x73\x20\x56\x69\x73\x75\x61\x6C\x20\x55\x53\x42\x20\x44\x61\x74\x61\x20\x46\x69\x6C\x65", "ufo" },
    { 28, "\x43\x61\x6C\x63\x75\x6C\x75\x78\x20\x49\x6E\x64\x6F\x6F\x72\x20\x50\x72\x6F\x6A\x65\x63\x74\x20\x66\x69\x6C\x65", "cin" },
    { 28, "\x38\x00\x00\x00\x54\x47\x42\x4E\x00\x01\x00\x00\x7C\x07\x9E\xDC\xF4\xBD\xCF\x46\x9A\x55\xC4\x8C\xE5\xAC\x87\xBA", "bxu" },
    { 28, "\x35\x4B\x50\x35\x31\x5D\x2A\x67\x72\x72\x80\x83\x85\x63\x7A\x7D\x6B\x43\x6A\x55\x49\x53\x64\x4F\x51\x61\x30\x0D", "hru" },
    { 28, "\x2A\x42\x45\x47\x49\x4E\x20\x53\x50\x52\x45\x41\x44\x53\x48\x45\x45\x54\x53\x20\x56\x45\x52\x53\x49\x4F\x4E\x3D", "as" },
    { 28, "\x24\x46\x49\x4C\x45\x5F\x54\x59\x50\x45\x3A\x44\x49\x43\x54\x0D\x0A\x24\x44\x49\x43\x54\x5F\x54\x59\x50\x45\x3A", "trd" },
    { 28, "\x23\x20\x66\x69\x6C\x65\x20\x67\x65\x6E\x65\x72\x61\x74\x65\x64\x20\x62\x79\x20\x55\x56\x4D\x61\x70\x70\x65\x72", "obj" },
    { 28, "\x1A\x45\xDF\xA3\x93\x42\x82\x88\x6D\x61\x74\x72\x6F\x73\x6B\x61\x42\x87\x81\x01\x42\x85\x81\x01\x18\x53\x80\x67", "mkv" },
    { 28, "\x01\x00\x00\x00\x48\x45\x52\x20\x49\x6E\x74\x65\x72\x61\x63\x74\x69\x76\x65\x20\x50\x72\x65\x73\x65\x6E\x74\x73", "sav" },
    { 28, "\x00\x20\x00\x00\x00\x4F\x50\x53\x20\x48\x65\x61\x64\x65\x72\x20\x56\x65\x72\x73\x69\x6F\x6E\x20\x31\x2E\x31\x20", "ops" },
    { 27, "\xFF\xFE\x5B\x00\x53\x00\x63\x00\x72\x00\x69\x00\x70\x00\x74\x00\x20\x00\x49\x00\x6E\x00\x66\x00\x6F\x00\x5D", "ass" },
    { 27, "\xFF\x4D\x79\x50\x68\x6F\x6E\x65\x45\x78\x70\x6C\x6F\x72\x65\x72\x5F\x43\x6F\x6E\x74\x65\x6E\x74\x49\x44\x3A", "mpb" },
    { 27, "\x5B\x45\x53\x50\x5D\xB5\x78\x8B\xF9\x8B\xE9\xBE\x12\x01\x57\xF3\xA4\xC3\xBF\x00\x01\x57\x33\xC0\x99\x81\xFF", "com" },
    { 27, "\x57\x61\x72\x63\x72\x61\x66\x74\x20\x49\x49\x49\x20\x72\x65\x63\x6F\x72\x64\x65\x64\x20\x67\x61\x6D\x65\x1A", "w3g" },
    { 27, "\x54\x61\x67\x77\x72\x69\x74\x65\x20\x54\x65\x6D\x70\x6C\x61\x74\x65\x20\x46\x69\x6C\x65\x20\x31\x0D\x0A\x1A", "tww" },
    { 27, "\x50\x72\x6F\x70\x65\x6C\x6C\x65\x72\x68\x65\x61\x64\x73\x20\x52\x65\x46\x69\x6C\x6C\x20\x46\x69\x6C\x65\x1A", "rfl" },
    { 27, "\x50\x61\x69\x6E\x74\x20\x53\x68\x6F\x70\x20\x50\x72\x6F\x20\x49\x6D\x61\x67\x65\x20\x46\x69\x6C\x65\x0A\x1A", "pspimage" },
    { 27, "\x50\x47\x46\x20\x2D\x20\x28\x63\x29\x20\x42\x56\x52\x50\x20\x53\x6F\x66\x74\x77\x61\x72\x65\x20\x38\x39\x2D", "dgr" },
    { 27, "\x4D\x6F\x64\x69\x66\x69\x63\x61\x74\x69\x6F\x6E\x20\x52\x65\x73\x6F\x75\x72\x63\x65\x20\x46\x69\x6C\x65\x1A", "m01" },
    { 27, "\x4D\x69\x6E\x69\x74\x61\x62\x20\x50\x6F\x72\x74\x61\x62\x6C\x65\x20\x57\x6F\x72\x6B\x73\x68\x65\x65\x74\x20", "mtp" },
    { 27, "\x4D\x61\x70\x20\x43\x61\x6C\x69\x62\x72\x61\x74\x69\x6F\x6E\x20\x64\x61\x74\x61\x20\x66\x69\x6C\x65\x20\x76", "gmi" },
    { 27, "\x4D\x41\x49\x45\x54\x20\x45\x6E\x63\x72\x79\x70\x74\x65\x64\x20\x46\x69\x6C\x65\x20\x53\x79\x73\x74\x65\x6D", "mef" },
    { 27, "\x49\x6E\x6E\x61\x50\x68\x61\x73\x65\x20\x43\x6F\x6D\x70\x72\x65\x73\x73\x65\x64\x20\x46\x69\x6C\x65\x20\x76", "kdb" },
    { 27, "\x49\x4E\x46\x4F\x52\x4D\x41\x54\x49\x4F\x4E\x20\x57\x4F\x52\x4B\x53\x48\x4F\x50\x20\x32\x30\x30\x30\x0D\x0A", "iw2" },
    { 27, "\x46\x6F\x72\x6D\x61\x74\x74\x65\x64\x20\x44\x69\x73\x6B\x20\x49\x6D\x61\x67\x65\x20\x66\x69\x6C\x65\x00\xA0", "fdi" },
    { 27, "\x45\x4E\x49\x47\x4D\x41\x20\x54\x52\x41\x4E\x53\x50\x4F\x52\x54\x41\x42\x4C\x45\x20\x46\x49\x4C\x45\x0D\x0A", "mus" },
    { 27, "\x45\x44\x47\x45\x20\x44\x69\x61\x67\x72\x61\x6D\x20\x46\x69\x6C\x65\x0D\x0A\x56\x65\x72\x73\x69\x6F\x6E\x20", "edg" },
    { 27, "\x43\x6F\x6E\x74\x65\x6E\x74\x73\x3A\x20\x43\x49\x52\x43\x41\x44\x20\x56\x65\x72\x73\x69\x6F\x6E\x20\x35\x2E", "dwg" },
    { 27, "\x42\x6F\x72\x6C\x61\x6E\x64\x20\x43\x2B\x2B\x20\x50\x72\x6F\x6A\x65\x63\x74\x20\x46\x69\x6C\x65\x0A\x00\x1A", "ide" },
    { 27, "\x41\x75\x74\x6F\x43\x41\x44\x2D\x38\x36\x20\x62\x69\x67\x66\x6F\x6E\x74\x20\x31\x2E\x30\x0D\x0A\x1A\x08\x00", "shx" },
    { 27, "\x41\x6D\x62\x69\x65\x6E\x74\x20\x44\x65\x73\x69\x67\x6E\x20\x50\x72\x6F\x6A\x65\x63\x74\x20\x66\x69\x6C\x65", "ptg" },
    { 27, "\x2F\x42\x45\x47\x49\x4E\x5F\x54\x41\x42\x4C\x45\x20\x41\x4D\x43\x48\x45\x41\x44\x0D\x0A\x4E\x41\x4D\x45\x20", "" },
    { 27, "\x2E\x00\x00\x00\x49\x6E\x63\x72\x65\x64\x69\x6D\x61\x69\x6C\x20\x41\x42\x20\x76\x65\x72\x73\x69\x6F\x6E\x20", "imb" },
    { 27, "\x2D\x2D\x2D\x2D\x2D\x42\x45\x47\x49\x4E\x20\x43\x45\x52\x54\x49\x46\x49\x43\x41\x54\x45\x2D\x2D\x2D\x2D\x2D", "cer" },
    { 27, "\x23\x46\x69\x72\x65\x46\x6C\x79\x5F\x50\x72\x6F\x6A\x65\x63\x74\x23\x20\x20\x56\x65\x72\x73\x69\x6F\x6E\x3D", "prj" },
    { 27, "\x23\x20\x43\x72\x65\x61\x74\x6F\x72\x3A\x20\x50\x61\x74\x68\x65\x74\x69\x63\x20\x57\x72\x69\x74\x65\x72\x20", "pw" },
    { 27, "\x1A\x52\x54\x53\x20\x43\x4F\x4D\x50\x52\x45\x53\x53\x45\x44\x20\x49\x4D\x41\x47\x45\x20\x56\x31\x2E\x30\x1A", "dat" },
    { 27, "\x06\x00\x44\x6F\x6D\x61\x69\x6E\x44\x4A\x42\x4F\x07\x00\x41\x4F\x62\x6A\x44\x6F\x63\x04\x13\x00\x32\x30\x30", "avb" },
    { 26, "\xFF\x50\x69\x6E\x67\x20\x50\x6C\x6F\x74\x74\x65\x72\x20\x53\x61\x6D\x70\x6C\x65\x20\x46\x69\x6C\x65\x00", "pp2" },
    { 26, "\xD5\xC8\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "sst" },
    { 26, "\xAA\x00\x00\x00\x5A\x45\x4E\x77\x6F\x72\x6B\x73\x20\x69\x6D\x61\x67\x65\x20\x61\x72\x63\x68\x69\x76\x65", "zmg" },
    { 26, "\x5B\x53\x63\x72\x65\x65\x6E\x53\x77\x69\x66\x74\x5D\x0D\x0A\x52\x65\x67\x69\x73\x74\x65\x72\x65\x64\x3D", "ssp" },
    { 26, "\x5B\x50\x61\x63\x6B\x61\x67\x65\x20\x44\x6F\x77\x6E\x6C\x6F\x61\x64\x20\x50\x72\x6F\x66\x69\x6C\x65\x5D", "mlf" },
    { 26, "\x5B\x4B\x43\x68\x65\x73\x73\x20\x47\x61\x6D\x65\x5D\x0D\x0A\x57\x68\x69\x74\x65\x54\x69\x6D\x65\x3A\x20", "kch" },
    { 26, "\x4D\x6F\x64\x00\x16\x00\x00\x00\x4D\x6F\x64\x75\x6C\x65\x20\x69\x6E\x66\x6F\x20\x66\x69\x6C\x65\x20\x76", "udd" },
    { 26, "\x4D\x69\x63\x72\x6F\x73\x6F\x66\x74\x20\x4C\x69\x6E\x6B\x65\x72\x20\x44\x61\x74\x61\x62\x61\x73\x65\x0A", "ilk" },
    { 26, "\x4D\x53\x46\x54\x02\x00\x01\x00\x00\x00\x00\x00\x09\x04\x00\x00\x09\x04\x00\x00\x51\x00\x00\x00\x07\x00", "tlb" },
    { 26, "\x49\x6E\x74\x65\x72\x70\x6C\x61\x79\x20\x4D\x56\x45\x20\x46\x69\x6C\x65\x1A\x00\x00\x1A\x01\x00\x11\x33", "mve" },
    { 26, "\x49\x49\x1A\x00\x00\x00\x48\x45\x41\x50\x43\x43\x44\x52\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00", "crw" },
    { 26, "\x48\x20\x20\x53\x4F\x46\x54\x57\x41\x52\x45\x20\x4E\x41\x4D\x45\x20\x26\x20\x56\x45\x52\x53\x49\x4F\x4E", "trk" },
    { 26, "\x46\x43\x57\x20\x28\x46\x61\x73\x74\x43\x41\x44\x20\x66\x6F\x72\x20\x57\x69\x6E\x64\x6F\x77\x73\x29\x20", "fcw" },
    { 26, "\x45\x4B\x41\x48\x41\x55\x20\x44\x41\x54\x41\x42\x41\x53\x45\x20\x4C\x4F\x43\x41\x4C\x20\x43\x4F\x50\x59", "ess" },
    { 26, "\x44\x49\x56\x2D\x42\x49\x5A\x32\x03\x00\x10\x02\x20\x02\x02\x01\x03\x20\x03\x14\x07\x5E\x04\x20\x02\x15", "b2z" },
    { 26, "\x43\x72\x65\x61\x74\x69\x76\x65\x20\x56\x6F\x69\x63\x65\x20\x46\x69\x6C\x65\x1A\x1A\x00\x0A\x01\x29\x11", "voc" },
    { 26, "\x43\x44\x20\x41\x55\x54\x4F\x52\x55\x4E\x20\x43\x52\x45\x41\x54\x4F\x52\x20\x50\x41\x43\x4B\x41\x47\x45", "arn" },
    { 26, "\x41\x75\x64\x69\x74\x69\x6F\x6E\x20\x50\x6C\x61\x79\x20\x44\x61\x74\x61\x20\x2F\x2A\x20\x76\x65\x72\x20", "arp" },
    { 26, "\x3C\x74\x69\x6D\x65\x6C\x69\x6E\x65\x3E\x0D\x0A\x09\x3C\x67\x72\x6F\x75\x70\x20\x74\x79\x70\x65\x3D\x22", "mpj" },
    { 26, "\x2A\x2A\x2A\x20\x20\x49\x6E\x73\x74\x61\x6C\x6C\x61\x74\x69\x6F\x6E\x20\x53\x74\x61\x72\x74\x65\x64\x20", "log" },
    { 26, "\x23\x41\x63\x63\x57\x61\x72\x65\x20\x44\x61\x74\x61\x20\x44\x69\x63\x74\x69\x6F\x6E\x61\x72\x79\x0D\x0A", "dd" },
    { 26, "\x1A\x46\x69\x6C\x65\x53\x79\x6E\x63\x20\x50\x72\x6F\x66\x69\x6C\x65\x20\x76\x65\x72\x73\x69\x6F\x6E\x20", "fsy" },
    { 26, "\x12\xDD\x72\xDD\x03\x00\x00\x00\x0A\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x2B\x23\x00\x00\x01\x00", "sav" },
    { 26, "\x07\x18\x44\x45\x4C\x50\x48\x49\x2E\x44\x49\x41\x47\x52\x41\x4D\x2E\x50\x4F\x52\x54\x46\x4F\x4C\x49\x4F", "ddp" },
    { 25, "\x6E\x75\x74\x2F\x6D\x75\x6C\x74\x69\x6D\x65\x64\x69\x61\x20\x63\x6F\x6E\x74\x61\x69\x6E\x65\x72\x00", "nut" },
    { 25, "\x61\x4C\x75\x5A\x00\x00\x43\x6F\x70\x79\x72\x69\x67\x68\x74\x20\x28\x63\x29\x20\x31\x39\x39\x30\x2D", "inx" },
    { 25, "\x5B\x50\x73\x79\x63\x6C\x65\x20\x44\x69\x73\x70\x6C\x61\x79\x20\x50\x72\x65\x73\x65\x74\x73\x20\x76", "psv" },
    { 25, "\x57\x68\x69\x73\x70\x65\x72\x20\x33\x32\x20\x46\x69\x6C\x65\x2C\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "wsp" },
    { 25, "\x43\x68\x65\x73\x73\x6D\x61\x73\x74\x65\x72\x20\x31\x30\x74\x68\x20\x45\x64\x69\x74\x69\x6F\x6E\x20", "cmg" },
    { 25, "\x41\x75\x74\x6F\x43\x41\x44\x2D\x38\x36\x20\x75\x6E\x69\x66\x6F\x6E\x74\x20\x31\x2E\x30\x0D\x0A\x1A", "shx" },
    { 25, "\x41\x56\x47\x37\x5F\x41\x4E\x54\x49\x56\x49\x52\x55\x53\x5F\x56\x41\x55\x4C\x54\x5F\x46\x49\x4C\x45", "fil" },
    { 25, "\x3C\x56\x52\x54\x44\x61\x74\x61\x73\x65\x74\x20\x72\x61\x73\x74\x65\x72\x58\x53\x69\x7A\x65\x3D\x22", "vrt" },
    { 25, "\x3C\x21\x44\x4F\x43\x54\x59\x50\x45\x20\x73\x71\x75\x65\x65\x7A\x65\x5F\x70\x72\x6F\x6A\x65\x63\x74", "sqz" },
    { 25, "\x23\x20\x43\x72\x65\x61\x74\x6F\x72\x3A\x20\x45\x67\x6F\x6E\x20\x41\x6E\x69\x6D\x61\x74\x6F\x72\x20", "egon" },
    { 25, "\x18\x53\x6D\x61\x6C\x6C\x20\x42\x75\x73\x69\x6E\x65\x73\x73\x20\x50\x75\x62\x6C\x69\x73\x68\x65\x72", "sbpf" },
    { 25, "\x03\xEA\x04\x00\x00\x14\x47\x45\x4E\x45\x52\x49\x43\x20\x43\x41\x44\x44\x20\x56\x65\x72\x20\x36\x2E", "gcd" },
    { 25, "\x00\x00\x27\x0A\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "shx" },
    { 24, "\xD0\xCF\x11\xE0\xA1\xB1\x1A\xE1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4cm" },
    { 24, "\x7F\x45\x4C\x46\x01\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x03\x00\x01\x00\x00\x00", "" },
    { 24, "\x5B\x47\x65\x6E\x65\x72\x61\x6C\x5D\x0D\x0A\x44\x69\x73\x70\x6C\x61\x79\x20\x4E\x61\x6D\x65\x3D", "ecf" },
    { 24, "\x5B\x43\x56\x41\x20\x46\x69\x6C\x65\x20\x49\x6E\x66\x6F\x72\x6D\x61\x74\x69\x6F\x6E\x5D\x0D\x0A", "cva" },
    { 24, "\x57\x69\x6E\x61\x6D\x70\x20\x45\x51\x20\x6C\x69\x62\x72\x61\x72\x79\x20\x66\x69\x6C\x65\x20\x76", "eqf" },
    { 24, "\x53\x6F\x6E\x61\x72\x63\x2D\x73\x71\x75\x65\x65\x7A\x65\x64\x20\x50\x43\x4D\x20\x66\x69\x6C\x65", "snc" },
    { 24, "\x52\x49\x46\x46\x10\x04\x00\x00\x50\x41\x4C\x20\x64\x61\x74\x61\x04\x04\x00\x00\x00\x03\x00\x01", "pal" },
    { 24, "\x50\x68\x6F\x74\x6F\x64\x65\x78\x28\x52\x29\x20\x50\x72\x6F\x53\x68\x6F\x77\x28\x54\x4D\x29\x20", "psh" },
    { 24, "\x4D\x44\x6D\x64\x0A\x01\x7A\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "md" },
    { 24, "\x48\x69\x67\x68\x20\x4A\x50\x45\x47\x20\x44\x61\x74\x61\x20\x69\x6E\x20\x4D\x65\x6D\x6F\x72\x79", "vem" },
    { 24, "\x47\x6F\x6C\x64\x65\x6E\x20\x53\x6F\x66\x74\x77\x61\x72\x65\x20\x42\x6F\x75\x6E\x64\x61\x72\x79", "gsb" },
    { 24, "\x46\x52\x57\x20\x43\x4F\x52\x45\x4C\x20\x44\x52\x41\x57\x00\x00\x00\x00\x00\x00\x09\x00\x00\x00", "fin" },
    { 24, "\x43\x6C\x69\x65\x6E\x74\x20\x55\x72\x6C\x43\x61\x63\x68\x65\x20\x4D\x4D\x46\x20\x56\x65\x72\x20", "dat" },
    { 24, "\x42\x41\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x4D\x1A\x00\x00\x00\x4B\x00\x4B\x00", "bga" },
    { 24, "\x3C\x47\x46\x53\x53\x74\x75\x62\x20\x5F\x53\x74\x75\x62\x46\x69\x6C\x65\x50\x61\x74\x68\x3D\x22", "gfs" },
    { 24, "\x3A\x3A\x3A\x54\x41\x47\x4D\x41\x50\x3A\x3A\x3A\x30\x46\x46\x45\x30\x30\x30\x33\x3A\x2A\x2A\x2A", "nab" },
    { 24, "\x2B\x44\x62\x49\x6E\x66\x6F\x0A\x20\x2B\x56\x65\x72\x73\x69\x6F\x6E\x4E\x75\x6D\x62\x65\x72\x0A", "dbi" },
    { 24, "\x2A\x42\x45\x47\x49\x4E\x20\x47\x52\x41\x50\x48\x49\x43\x53\x20\x56\x45\x52\x53\x49\x4F\x4E\x3D", "ag" },
    { 24, "\x24\x46\x4C\x32\x40\x28\x23\x29\x20\x53\x50\x53\x53\x20\x44\x41\x54\x41\x20\x46\x49\x4C\x45\x20", "sav" },
    { 24, "\x23\x20\x20\x41\x43\x55\x43\x4F\x42\x4F\x4C\x20\x6C\x69\x63\x65\x6E\x73\x65\x20\x66\x69\x6C\x65", "vlc" },
    { 24, "\x22\x53\x71\x75\x65\x61\x6B\x20\x61\x72\x63\x68\x69\x76\x65\x20\x77\x72\x69\x74\x74\x65\x6E\x20", "sar" },
    { 24, "\x21\x3C\x61\x72\x63\x68\x3E\x0A\x64\x65\x62\x69\x61\x6E\x2D\x62\x69\x6E\x61\x72\x79\x20\x20\x20", "deb" },
    { 24, "\x21\x3C\x61\x72\x63\x68\x3E\x0A\x2F\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20", "obj" },
    { 24, "\x19\x46\x49\x43\x48\x49\x45\x52\x20\x47\x55\x49\x54\x41\x52\x45\x20\x50\x52\x4F\x20\x76\x31\x2E", "gtp" },
    { 24, "\x06\x06\xED\xF5\xD8\x1D\x46\xE5\xBD\x31\xEF\xE7\xFE\x74\xB7\x1D\x44\x4F\x43\x55\x4D\x45\x4E\x54", "indd" },
    { 24, "\x00\x00\x27\x0A\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "shp" },
    { 23, "\xF1\xF1\x00\x00\xA8\x03\x00\x00\x0B\x00\x00\x00\x00\x00\x00\x00\x57\x6F\x72\x6C\x64\x73\x5C", "sav" },
    { 23, "\xEF\xBB\xBF\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20", "pln" },
    { 23, "\x70\x6B\x08\x08\x42\x47\x49\x20\x44\x65\x76\x69\x63\x65\x20\x44\x72\x69\x76\x65\x72\x20\x28", "bgi" },
    { 23, "\x66\x69\x6C\x65\x73\x65\x74\x20\x28\x63\x29\x31\x39\x39\x38\x20\x42\x76\x44\x2F\x46\x56\x4E", "bvd" },
    { 23, "\x5B\x41\x52\x43\x45\x58\x50\x4C\x4F\x52\x45\x52\x5D\x0D\x0A\x56\x45\x52\x53\x49\x4F\x4E\x3D", "aep" },
    { 23, "\x5A\x53\x4E\x45\x53\x20\x53\x61\x76\x65\x20\x53\x74\x61\x74\x65\x20\x46\x69\x6C\x65\x20\x56", "zst" },
    { 23, "\x57\x00\x6F\x00\x72\x00\x64\x00\x46\x00\x69\x00\x6C\x00\x65\x00\x4E\x00\x61\x00\x6D\x00\x65", "xwf" },
    { 23, "\x54\x47\x46\x20\x62\x79\x20\x54\x72\x65\x65\x20\x47\x65\x6E\x65\x72\x61\x74\x6F\x72\x0D\x0A", "tgf" },
    { 23, "\x50\x75\x54\x54\x59\x2D\x55\x73\x65\x72\x2D\x4B\x65\x79\x2D\x46\x69\x6C\x65\x2D\x32\x3A\x20", "ppk" },
    { 23, "\x4B\x61\x79\x64\x61\x72\x61\x20\x46\x42\x58\x20\x42\x69\x6E\x61\x72\x79\x20\x20\x00\x1A\x00", "fbx" },
    { 23, "\x47\x65\x6F\x53\x79\x73\x74\x65\x6D\x20\x44\x4D\x46\x2C\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "dmf" },
    { 23, "\x47\x65\x6E\x4D\x69\x63\x72\x6F\x44\x41\x54\x20\x28\x43\x29\x20\x4D\x63\x41\x66\x65\x65\x1A", "gem" },
    { 23, "\x45\x61\x73\x79\x57\x6F\x72\x73\x68\x69\x70\x20\x42\x69\x62\x6C\x65\x20\x54\x65\x78\x74\x1A", "ewb" },
    { 23, "\x43\x6F\x6D\x70\x72\x65\x73\x73\x65\x64\x20\x53\x71\x75\x61\x72\x65\x20\x57\x61\x76\x65\x1A", "csw" },
    { 23, "\x41\x56\x47\x36\x5F\x49\x6E\x74\x65\x67\x72\x69\x74\x79\x5F\x44\x61\x74\x61\x62\x61\x73\x65", "dat" },
    { 23, "\x3C\x6D\x73\x6F\x3A\x63\x75\x73\x74\x6F\x6D\x55\x49\x20\x78\x6D\x6C\x6E\x73\x3A\x6D\x73\x6F", "qat" },
    { 23, "\x3C\x4D\x41\x52\x4B\x41\x4E\x59\x5F\x44\x4F\x43\x55\x4D\x45\x4E\x54\x53\x41\x46\x45\x52\x3E", "" },
    { 23, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0D\x0A", "uxdc" },
    { 23, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E\x0A\x3C", "xml" },
    { 23, "\x23\x48\x61\x70\x74\x65\x6B\x20\x43\x6F\x6D\x70\x72\x65\x73\x73\x65\x64\x46\x69\x6C\x65\x20", "htr" },
    { 23, "\x23\x20\x76\x74\x6B\x20\x44\x61\x74\x61\x46\x69\x6C\x65\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "vtk" },
    { 23, "\x23\x20\x53\x6C\x69\x64\x65\x20\x53\x68\x6F\x77\x20\x53\x65\x71\x75\x65\x6E\x63\x65\x0D\x0A", "sld" },
    { 23, "\x18\x46\x49\x43\x48\x49\x45\x52\x20\x47\x55\x49\x54\x41\x52\x20\x50\x52\x4F\x20\x76\x35\x2E", "gp5" },
    { 23, "\x18\x46\x49\x43\x48\x49\x45\x52\x20\x47\x55\x49\x54\x41\x52\x20\x50\x52\x4F\x20\x76\x34\x2E", "gp4" },
    { 23, "\x18\x46\x49\x43\x48\x49\x45\x52\x20\x47\x55\x49\x54\x41\x52\x20\x50\x52\x4F\x20\x76\x33\x2E", "gp3" },
    { 23, "\x18\x46\x49\x43\x48\x49\x45\x52\x20\x47\x55\x49\x54\x41\x52\x20\x50\x52\x4F\x20\x76\x32\x2E", "gtp" },
    { 23, "\x08\x00\x00\x00\x45\x78\x74\x72\x61\x43\x41\x44\x07\x00\x00\x00\x44\x52\x41\x57\x49\x4E\x47", "cad" },
    { 23, "\x06\x00\x00\x00\x44\x4F\x4F\x4D\x20\x33\x10\x00\x00\x00\x13\x00\x00\x00\x67\x61\x6D\x65\x2F", "save" },
    { 23, "\x00\x00\x01\xBA\x44\x00\x04\x00\x04\x01\x01\x89\xC3\xF8\x00\x00\x01\xBB\x00\x12\x80\xC4\xE1", "vro" },
    { 22, "\xFC\x08\x01\x00\x0E\x00\xA8\x01\xD2\x01\x09\x00\x01\x02\x03\x04\x06\x05\x08\x0A\x00\x00", "bas" },
    { 22, "\xAF\xAF\x53\x74\x61\x62\x6C\x65\x20\x46\x69\x6C\x65\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "1sc" },
    { 22, "\x7B\x0A\x0A\x76\x65\x72\x73\x69\x6F\x6E\x0A\x09\x7B\x0A\x09\x6E\x75\x6D\x62\x65\x72\x20", "pz3" },
    { 22, "\x6F\x62\x6A\x65\x63\x74\x20\x54\x4D\x50\x45\x47\x43\x6F\x6E\x66\x69\x67\x46\x69\x6C\x65", "mcf" },
    { 22, "\x5B\x50\x48\x4F\x54\x4F\x56\x49\x45\x57\x45\x52\x53\x45\x54\x54\x49\x4E\x47\x53\x5D\x0D", "bws" },
    { 22, "\x5B\x4B\x4F\x53\x5A\x54\x4F\x52\x59\x53\x20\x41\x54\x48\x45\x4E\x41\x53\x4F\x46\x54\x5D", "ath" },
    { 22, "\x57\x04\x00\x00\x53\x50\x53\x53\x20\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x66\x69\x6C\x65", "cht" },
    { 22, "\x54\x79\x70\x65\x3A\x56\x65\x72\x73\x69\x6F\x6E\x0D\x0A\x56\x65\x72\x73\x69\x6F\x6E\x3A", "nv" },
    { 22, "\x54\x61\x78\x41\x43\x54\x20\x45\x6E\x63\x72\x79\x70\x74\x65\x64\x20\x44\x61\x74\x61\x20", "" },
    { 22, "\x52\x49\x46\x46\x24\x00\x00\x00\x43\x44\x44\x41\x66\x6D\x74\x20\x18\x00\x00\x00\x01\x00", "cda" },
    { 22, "\x52\x42\x34\x00\x28\x63\x29\x20\x53\x61\x72\x6D\x20\x53\x6F\x66\x74\x77\x61\x72\x65\x00", "rb4" },
    { 22, "\x4E\x65\x77\x20\x4D\x69\x63\x72\x6F\x54\x53\x50\x20\x57\x6F\x72\x6B\x66\x69\x6C\x65\x00", "wf1" },
    { 22, "\x4C\x6F\x67\x6F\x20\x52\x65\x70\x6F\x72\x74\x20\x56\x69\x65\x77\x20\x46\x69\x6C\x65\x1A", "lvf" },
    { 22, "\x4C\x6F\x64\x65\x20\x44\x61\x74\x61\x20\x4E\x65\x74\x77\x6F\x72\x6B\x20\x46\x69\x6C\x65", "ntw" },
    { 22, "\x4C\x61\x62\x56\x49\x45\x57\x20\x4D\x65\x61\x73\x75\x72\x65\x6D\x65\x6E\x74\x09\x0D\x0A", "lvm" },
    { 22, "\x4C\x00\x69\x00\x6E\x00\x65\x00\x61\x00\x67\x00\x65\x00\x32\x00\x56\x00\x65\x00\x72\x00", "l2r" },
    { 22, "\x49\x4E\x46\x4F\x52\x4D\x41\x54\x49\x4F\x4E\x20\x57\x4F\x52\x4B\x53\x48\x4F\x50\x0D\x0A", "iws" },
    { 22, "\x47\x46\x41\x2D\x42\x41\x53\x49\x43\x20\x4D\x53\x2D\x44\x4F\x53\x1A\x01\x01\x01\x4E\x41", "gfa" },
    { 22, "\x44\x69\x61\x6D\x6F\x6E\x64\x57\x61\x72\x65\x20\x44\x69\x67\x69\x74\x69\x7A\x65\x64\x0A", "dwd" },
    { 22, "\x44\x54\x50\x52\x4F\x2D\x53\x61\x76\x65\x64\x20\x44\x69\x73\x6B\x20\x49\x6D\x61\x67\x65", "sav" },
    { 22, "\x41\x75\x74\x6F\x43\x41\x44\x20\x53\x6C\x69\x64\x65\x20\x4C\x69\x62\x72\x61\x72\x79\x20", "slb" },
    { 22, "\x3C\x6D\x6F\x64\x65\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x58\x4D\x4C\x4D\x4F\x44", "xmod" },
    { 22, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x20\x3D\x20\x22\x31\x2E\x30\x22\x20", "argo" },
    { 22, "\x2D\x2D\x20\x70\x68\x70\x4D\x79\x41\x64\x6D\x69\x6E\x20\x53\x51\x4C\x20\x44\x75\x6D\x70", "sql" },
    { 22, "\x23\x23\x23\x23\x20\x4F\x50\x43\x20\x46\x49\x4C\x45\x20\x56\x45\x52\x53\x49\x4F\x4E\x20", "opc" },
    { 22, "\x23\x20\x56\x6F\x62\x53\x75\x62\x20\x69\x6E\x64\x65\x78\x20\x66\x69\x6C\x65\x2C\x20\x76", "idx" },
    { 22, "\x18\x4F\x70\x74\x69\x6F\x6E\x20\x57\x6F\x72\x6B\x73\x68\x65\x65\x74\x20\x56\x65\x72\x20", "osc" },
    { 22, "\x00\x05\xFF\xFE\xFF\x13\x53\x00\x57\x00\x69\x00\x53\x00\x48\x00\x6D\x00\x61\x00\x78\x00", "swi" },
    { 22, "\x00\x03\x54\x41\x49\x4A\x49\x4E\x20\x4D\x45\x44\x49\x41\x20\x43\x4F\x2E\x2C\x4C\x54\x44", "tjn" },
    { 21, "\xC0\xB9\x07\x2E\x4F\x93\xF1\x46\xA0\x15\x79\x2C\xA1\xD9\xE8\x21\x15\x00\x00\x00\x02", "axx" },
    { 21, "\x67\x66\x64\x74\x3C\x01\x5C\x00\x00\x00\x00\x3C\x08\x6D\x65\x74\x61\x64\x61\x74\x61", "gfi" },
    { 21, "\x50\x72\x6F\x20\x50\x69\x6C\x6B\x6B\x69\x20\x64\x61\x74\x61\x66\x69\x6C\x65\x20\x76", "dat" },
    { 21, "\x50\x68\x6F\x74\x6F\x20\x4C\x69\x6E\x65\x20\x42\x72\x6F\x77\x73\x65\x66\x69\x6C\x65", "plb" },
    { 21, "\x4E\x65\x72\x6F\x41\x75\x64\x69\x6F\x20\x2D\x20\x50\x65\x61\x6B\x20\x66\x69\x6C\x65", "tmp" },
    { 21, "\x4D\x2D\x57\x20\x50\x6F\x63\x6B\x65\x74\x20\x44\x69\x63\x74\x69\x6F\x6E\x61\x72\x79", "pdb" },
    { 21, "\x45\x78\x74\x65\x6E\x64\x65\x64\x20\x49\x6E\x73\x74\x72\x75\x6D\x65\x6E\x74\x3A\x20", "xi" },
    { 21, "\x45\x4C\x49\x54\x45\x20\x43\x6F\x6D\x6D\x61\x6E\x64\x65\x72\x20\x46\x69\x6C\x65\x1A", "cdr" },
    { 21, "\x43\x41\x53\x49\x4F\x20\x41\x44\x44\x49\x4E\x20\x44\x41\x54\x41\x46\x49\x4C\x45\x1A", "adt" },
    { 21, "\x42\x45\x47\x49\x4E\x3A\x56\x4E\x4F\x54\x45\x0D\x0A\x56\x45\x52\x53\x49\x4F\x4E\x3A", "vnt" },
    { 21, "\x41\x62\x72\x61\x63\x61\x64\x61\x74\x61\x20\x20\x64\x72\x61\x77\x69\x6E\x67\x1A\x1A", "aig" },
    { 21, "\x41\x30\x35\x33\x32\x20\x53\x4F\x4E\x47\x20\x20\x20\x20\x20\x20\x56\x65\x72\x20\x30", "r2s" },
    { 21, "\x41\x30\x35\x33\x32\x20\x53\x41\x4D\x50\x4C\x45\x20\x20\x20\x20\x56\x65\x72\x20\x30", "r3a" },
    { 21, "\x41\x30\x35\x33\x32\x20\x50\x41\x54\x54\x45\x52\x4E\x20\x20\x20\x56\x65\x72\x20\x30", "r2p" },
    { 21, "\x41\x30\x35\x33\x32\x20\x41\x4C\x4C\x20\x20\x20\x20\x20\x20\x20\x56\x65\x72\x20\x30", "r2a" },
    { 21, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x3F\x3E", "camproj" },
    { 21, "\x33\x44\x43\x20\x7B\x0D\x0A\x20\x61\x73\x63\x69\x20\x31\x0D\x0A\x20\x76\x73\x20\x22", "d3d" },
    { 21, "\x23\x4B\x4F\x52\x47\x20\x53\x63\x72\x69\x70\x74\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "ksc" },
    { 21, "\x23\x45\x63\x6C\x69\x70\x73\x65\x20\x50\x72\x6F\x64\x75\x63\x74\x20\x46\x69\x6C\x65", "eclipseproduct" },
    { 21, "\x23\x21\x2F\x62\x69\x6E\x2F\x73\x68\x0A\x23\x20\x4D\x65\x74\x61\x43\x61\x72\x64\x20", "rev" },
    { 21, "\x23\x20\x50\x61\x43\x6B\x41\x67\x45\x20\x44\x61\x54\x61\x53\x74\x52\x65\x41\x6D\x0A", "pkg" },
    { 21, "\x23\x20\x44\x69\x73\x6B\x20\x44\x65\x73\x63\x72\x69\x70\x74\x6F\x72\x46\x69\x6C\x65", "vmdk" },
    { 21, "\x20\x20\x20\x20\x20\x20\x20\x20\x43\x4F\x4E\x54\x52\x4F\x4C\x20\x49\x4E\x46\x4F\x20", "neu" },
    { 21, "\x17\xA1\x50\x43\x42\x20\x46\x49\x4C\x45\x20\x39\x20\x56\x45\x52\x53\x49\x4F\x4E\x20", "pcb" },
    { 21, "\x01\x00\x4D\x57\x52\x4B\x41\x72\x65\x61\x2E\x77\x72\x6B\x00\x4F\x52\x43\x4D\x50\x00", "eld" },
    { 21, "\x00\x00\x00\x00\x00\x01\x00\x00\x53\x53\x43\x45\x20\x44\x61\x74\x61\x62\x61\x73\x65", "sdf" },
    { 20, "\xFF\xFE\xFF\x0D\x4E\x00\x65\x00\x72\x00\x6F\x00\x43\x00\x44\x00\x41\x00\x56\x00", "nra" },
    { 20, "\xE8\x04\x00\x00\x2E\x64\x6F\x63\x6B\x7A\x69\x70\x20\x66\x6F\x72\x6D\x61\x74\x20", "doczip" },
    { 20, "\xBE\xBA\xFE\xCA\x0F\x50\x61\x6C\x6D\x53\x47\x20\x44\x61\x74\x61\x62\x61\x73\x65", "dat" },
    { 20, "\xB8\x0B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "app" },
    { 20, "\x82\x68\xD0\xE3\x4B\x87\xE3\x43\x98\x25\x4E\x42\x02\x0A\xF5\x43\x00\x00\x00\x00", "fpl" },
    { 20, "\x80\x2A\x5F\xD7\x00\x00\x08\x00\x00\x00\x04\x00\x00\x00\x04\x00\x00\x00\x00\x00", "cin" },
    { 20, "\x5B\x4E\x6F\x74\x65\x57\x6F\x72\x74\x68\x79\x20\x41\x72\x74\x57\x61\x72\x65\x5D", "nwc" },
    { 20, "\x56\x6F\x78\x65\x6C\x20\x41\x6E\x69\x6D\x61\x74\x69\x6F\x6E\x00\x01\x00\x00\x00", "vxl" },
    { 20, "\x55\x4E\x49\x43\x4F\x44\x45\x20\x46\x4F\x4E\x54\x00\x00\x00\x00\x56\x65\x72\x20", "fnt" },
    { 20, "\x54\x53\x02\x00\x01\x45\x6E\x63\x72\x79\x70\x74\x65\x64\x20\x46\x69\x6C\x65\x2E", "encrypted" },
    { 20, "\x54\x45\x52\x52\x41\x47\x45\x4E\x57\x4F\x52\x4C\x44\x32\x20\x20\x57\x4C\x44\x47", "tgw" },
    { 20, "\x54\x42\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x01\x00\x00\x00", "tbasiccx" },
    { 20, "\x54\x42\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x01\x00\x00\x00", "tbasicx" },
    { 20, "\x53\x70\x65\x63\x74\x72\x61\x6C\x20\x44\x61\x74\x61\x20\x46\x69\x6C\x65\x0D\x0A", "spa" },
    { 20, "\x53\x61\x6E\x67\x64\x75\x63\x6B\x20\x53\x70\x72\x69\x74\x65\x20\x46\x69\x6C\x65", "spr" },
    { 20, "\x52\x65\x6D\x6F\x74\x65\x4B\x65\x79\x73\x20\x50\x72\x6F\x66\x64\x61\x74\x20\x56", "rkp" },
    { 20, "\x52\x4D\x53\x78\x20\x4F\x53\x20\x46\x69\x6C\x65\x00\x00\x00\x00\x30\x30\x30\x30", "pgm" },
    { 20, "\x51\x55\x41\x4E\x54\x49\x43\x44\x52\x45\x41\x4D\x54\x41\x42\x49\x44\x4D\x45\x4D", "idm" },
    { 20, "\x50\x69\x6E\x67\x50\x6C\x6F\x74\x74\x65\x72\x20\x53\x63\x72\x69\x70\x74\x20\x56", "ppx" },
    { 20, "\x50\x68\x6F\x74\x6F\x20\x4C\x69\x6E\x65\x20\x44\x6F\x63\x75\x6D\x65\x6E\x74\x00", "pld" },
    { 20, "\x50\x43\x53\x00\x14\x00\x00\x00\x02\x00\x07\x00\x00\x00\x08\x00\x00\x00\x10\x04", "ndx" },
    { 20, "\x4E\x75\x6C\x6C\x73\x6F\x66\x74\x20\x41\x56\x53\x20\x50\x72\x65\x73\x65\x74\x20", "avs" },
    { 20, "\x4D\x69\x67\x68\x74\x79\x20\x44\x72\x61\x77\x20\x64\x72\x61\x77\x69\x6E\x67\x1A", "mig" },
    { 20, "\x4D\x61\x74\x72\x69\x78\x20\x73\x70\x72\x65\x61\x64\x73\x68\x65\x65\x74\x20\x76", "mtx" },
    { 20, "\x4C\x49\x42\x46\x69\x6C\x65\x54\x79\x70\x65\x2A\x2A\x2A\x2A\x00\x0F\x20\x40\x00", "dyl" },
    { 20, "\x4C\x00\x00\x00\x01\x14\x02\x00\x00\x00\x00\x00\xC0\x00\x00\x00\x00\x00\x00\x46", "lnk" },
    { 20, "\x4A\x61\x63\x6B\x73\x75\x6D\x3A\x20\x4D\x65\x74\x61\x2D\x49\x6E\x66\x6F\x3A\x20", "jacksum" },
    { 20, "\x49\x53\x49\x53\x20\x53\x43\x48\x45\x4D\x41\x54\x49\x43\x20\x46\x49\x4C\x45\x1A", "dsn" },
    { 20, "\x49\x49\x4F\x31\x24\x00\x00\x00\x54\x00\x00\x00\x08\x00\x00\x00\x88\x00\x00\x00", "smp" },
    { 20, "\x49\x43\x45\x20\x42\x6F\x6F\x6B\x20\x52\x65\x61\x64\x65\x72\x00\x28\x00\x00\x00", "book" },
    { 20, "\x48\x7A\x20\x20\x20\x20\x20\x20\x20\x4F\x68\x6D\x73\x20\x20\x20\x20\x44\x65\x67", "zma" },
    { 20, "\x44\x49\x47\x49\x20\x42\x6F\x6F\x73\x74\x65\x72\x20\x6D\x6F\x64\x75\x6C\x65\x00", "db" },
    { 20, "\x44\x41\x49\x53\x59\x20\x43\x4F\x4E\x54\x41\x49\x4E\x45\x52\x20\x46\x49\x4C\x45", "dsy" },
    { 20, "\x41\x75\x74\x6F\x43\x41\x44\x2D\x38\x36\x20\x73\x68\x61\x70\x65\x73\x20\x31\x2E", "shx" },
    { 20, "\x41\x74\x68\x65\x72\x6F\x73\x20\x50\x72\x6F\x66\x69\x6C\x65\x20\x46\x69\x6C\x65", "prf" },
    { 20, "\x41\x53\x46\x20\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x55\x41\x45\x00", "uss" },
    { 20, "\x3C\x77\x64\x64\x78\x50\x61\x63\x6B\x65\x74\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D", "" },
    { 20, "\x3C\x68\x6A\x2D\x54\x72\x65\x65\x70\x61\x64\x20\x76\x65\x72\x73\x69\x6F\x6E\x20", "hjt" },
    { 20, "\x3C\x51\x75\x63\x73\x20\x53\x63\x68\x65\x6D\x61\x74\x69\x63\x20\x30\x2E\x30\x2E", "sch" },
    { 20, "\x3C\x50\x41\x43\x4B\x41\x47\x45\x3E\x0D\x0A\x20\x20\x3C\x54\x49\x54\x4C\x45\x3E", "rgp" },
    { 20, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22\x20", "gpx" },
    { 20, "\x3B\x20\x56\x69\x73\x75\x61\x6C\x20\x54\x68\x6F\x75\x67\x68\x74\x20\x31\x2E\x30", "vthought" },
    { 20, "\x33\x44\x4D\x61\x72\x6B\x20\x44\x61\x74\x61\x62\x61\x73\x65\x20\x46\x69\x6C\x65", "3db" },
    { 20, "\x30\x00\x00\x00\x20\x00\x00\x00\x50\x00\x00\x00\xE4\x25\x00\x00\x34\x26\x00\x00", "me3" },
    { 20, "\x2F\x2F\x20\x3C\x21\x2D\x2D\x20\x3C\x6D\x64\x62\x3A\x6D\x6F\x72\x6B\x3A\x7A\x20", "mab" },
    { 20, "\x23\x20\x70\x74\x47\x75\x69\x20\x70\x72\x6F\x6A\x65\x63\x74\x20\x66\x69\x6C\x65", "pts" },
    { 20, "\x23\x20\x47\x72\x61\x63\x65\x20\x70\x72\x6F\x6A\x65\x63\x74\x20\x66\x69\x6C\x65", "agr" },
    { 20, "\x23\x20\x43\x41\x52\x20\x61\x72\x63\x68\x69\x76\x65\x20\x68\x65\x61\x64\x65\x72", "car" },
    { 20, "\x1C\x01\x00\x00\x02\x00\x04\x1C\x01\x14\x00\x02\x00\x14\x1C\x01\x16\x00\x02\x00", "fh*" },
    { 20, "\x18\xE0\x97\x2C\xC6\x26\x4A\x4F\xB8\x84\x56\xD1\x9C\x68\xD2\xE3\x69\x6C\x6D\x63", "ilm" },
    { 20, "\x13\x50\x43\x42\x20\x34\x2E\x30\x20\x42\x69\x6E\x61\x72\x79\x20\x46\x69\x6C\x65", "pcb" },
    { 20, "\x0C\x00\x00\x00\x53\x44\x5C\x44\x72\x65\x61\x6D\x5C\x30\x36\x00\x69\x03\x00\x00", "dream" },
    { 20, "\x00\x01\x00\x00\x53\x74\x61\x6E\x64\x61\x72\x64\x20\x4A\x65\x74\x20\x44\x42\x00", "mdb" },
    { 20, "\x00\x01\x00\x00\x4A\x65\x74\x20\x53\x79\x73\x74\x65\x6D\x20\x44\x42\x20\x20\x00", "mdw" },
    { 20, "\x00\x00\x00\x01\x00\x00\x00\x65\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00\x65", "mpd" },
    { 19, "\xFC\x00\x01\x00\x0C\x00\x81\x01\x82\x01\x06\x00\x01\x02\x03\x04\x05\x08\x10", "bas" },
    { 19, "\x69\x4D\x6F\x76\x69\x65\x20\x50\x72\x6F\x6A\x65\x63\x74\x20\x46\x69\x6C\x65", "imovieproj" },
    { 19, "\x63\x6F\x6E\x66\x69\x67\x5F\x64\x65\x73\x63\x72\x69\x70\x74\x69\x6F\x6E\x3D", "uae" },
    { 19, "\x5B\x54\x61\x67\x49\x6E\x66\x6F\x5D\x0D\x0A\x43\x6F\x6D\x70\x61\x6E\x79\x3D", "tag" },
    { 19, "\x5B\x43\x6C\x6F\x6E\x65\x43\x44\x5D\x0D\x0A\x56\x65\x72\x73\x69\x6F\x6E\x3D", "ccd" },
    { 19, "\x54\x6F\x63\x68\x61\x6C\x20\x50\x61\x63\x6B\x61\x67\x65\x20\x46\x69\x6C\x65", "tpk" },
    { 19, "\x53\x6F\x6E\x61\x72\x63\x2D\x73\x71\x75\x65\x65\x7A\x65\x64\x20\x56\x4F\x43", "vc" },
    { 19, "\x53\x63\x72\x65\x65\x6E\x77\x72\x69\x74\x65\x72\x57\x69\x6E\x56\x65\x72\x2E", "scw" },
    { 19, "\x53\x49\x45\x54\x52\x4F\x4E\x49\x43\x53\x20\x58\x52\x44\x20\x53\x43\x41\x4E", "cpi" },
    { 19, "\x50\x53\x4C\x46\x20\x44\x52\x41\x57\x49\x4E\x47\x20\x46\x49\x4C\x45\x20\x56", "drw" },
    { 19, "\x50\x43\x42\x20\x46\x49\x4C\x45\x20\x36\x20\x56\x45\x52\x53\x49\x4F\x4E\x20", "pcb" },
    { 19, "\x4D\x69\x67\x68\x74\x79\x20\x44\x72\x61\x77\x20\x57\x69\x6E\x64\x6F\x77\x1A", "mwl" },
    { 19, "\x4C\x69\x4F\x6E\x48\x65\x41\x64\x57\x61\x6C\x6C\x56\x65\x72\x73\x69\x6F\x6E", "wal" },
    { 19, "\x4C\x69\x4F\x6E\x48\x65\x41\x64\x50\x61\x74\x68\x56\x65\x72\x73\x69\x6F\x6E", "pat" },
    { 19, "\x49\x4E\x46\x4F\x52\x4D\x41\x54\x49\x4F\x4E\x20\x4D\x41\x47\x49\x43\x0D\x0A", "imr" },
    { 19, "\x48\x57\x50\x20\x44\x6F\x63\x75\x6D\x65\x6E\x74\x20\x46\x69\x6C\x65\x20\x56", "hwp" },
    { 19, "\x47\x72\x61\x70\x68\x69\x6E\x67\x43\x61\x6C\x63\x75\x6C\x61\x74\x6F\x72\x20", "gcf" },
    { 19, "\x47\x6F\x6C\x64\x65\x6E\x6C\x61\x6E\x64\x20\x49\x49\x20\x73\x61\x76\x65\x20", "sav" },
    { 19, "\x45\x4E\x49\x47\x4D\x41\x20\x42\x49\x4E\x41\x52\x59\x20\x46\x49\x4C\x45\x00", "mus" },
    { 19, "\x44\x61\x74\x61\x73\x65\x74\x48\x65\x61\x64\x65\x72\x20\x42\x65\x67\x69\x6E", "ers" },
    { 19, "\x44\x43\x4D\x4F\x36\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x3C\x5A\x00", "k7" },
    { 19, "\x43\x69\x72\x63\x75\x69\x74\x4D\x61\x6B\x65\x72\x20\x54\x65\x78\x74\x0D\x0A", "ckt" },
    { 19, "\x43\x4D\x44\x35\x28\x43\x72\x79\x73\x74\x61\x6C\x4D\x61\x6B\x65\x72\x29\x20", "cmd5" },
    { 19, "\x42\x72\x61\x69\x6E\x4C\x45\x44\x20\x41\x6C\x66\x61\x57\x61\x76\x65\x0D\x0A", "baw" },
    { 19, "\x42\x00\x45\x00\x47\x00\x49\x00\x4E\x00\x3A\x00\x56\x00\x4D\x00\x53\x00\x47", "vmg" },
    { 19, "\x3C\x63\x64\x72\x4C\x61\x62\x65\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22", "clbx" },
    { 19, "\x3C\x4D\x54\x53\x53\x63\x65\x6E\x65\x20\x56\x65\x72\x73\x69\x6F\x6E\x3D\x22", "mtx" },
    { 19, "\x3C\x43\x73\x6F\x75\x6E\x64\x53\x79\x6E\x74\x68\x65\x73\x69\x7A\x65\x72\x3E", "csd" },
    { 19, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22\x31\x2E\x30\x22", "abw" },
    { 19, "\x2A\x33\x44\x53\x4D\x41\x58\x5F\x41\x53\x43\x49\x49\x45\x58\x50\x4F\x52\x54", "ase" },
    { 19, "\x27\x74\x68\x69\x6E\x45\x64\x67\x65\x20\x64\x61\x74\x61\x66\x69\x6C\x65\x20", "m15" },
    { 19, "\x25\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x43\x4F\x4E\x43\x45\x50\x54", "cdd" },
    { 19, "\x23\x46\x49\x52\x45\x46\x4C\x59\x5F\x54\x4F\x50\x4D\x45\x4E\x55\x23\x0D\x0A", "txt" },
    { 19, "\x23\x20\x58\x54\x72\x6B\x43\x61\x64\x20\x56\x65\x72\x73\x69\x6F\x6E\x3A\x20", "xtr" },
    { 19, "\x09\x00\x46\x00\x61\x00\x76\x00\x50\x00\x6C\x00\x61\x00\x63\x00\x65\x00\x73", "fav" },
    { 19, "\x04\x00\x03\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x80\x00", "vdb" },
    { 19, "\x00\x01\x00\x00\x53\x74\x61\x6E\x64\x61\x72\x64\x20\x41\x43\x45\x20\x44\x42", "accdb" },
    { 19, "\x00\x01\x00\x00\x4D\x53\x49\x53\x41\x4D\x20\x44\x61\x74\x61\x62\x61\x73\x65", "mny" },
    { 18, "\xFF\xFF\x00\x00\x0B\x00\x50\x54\x54\x61\x62\x6C\x65\x4C\x6F\x6F\x6B\x00", "tlo" },
    { 18, "\xEF\xBB\xBF\x3C\x66\x6C\x61\x73\x68\x5F\x70\x72\x6F\x6A\x65\x63\x74\x20", "flp" },
    { 18, "\x78\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40", "mc9" },
    { 18, "\x64\x31\x33\x3A\x63\x72\x65\x61\x74\x69\x6F\x6E\x20\x64\x61\x74\x65\x69", "pando" },
    { 18, "\x63\x6F\x6E\x66\x69\x67\x2E\x76\x65\x72\x73\x69\x6F\x6E\x20\x3D\x20\x22", "vmx" },
    { 18, "\x5B\x53\x45\x43\x54\x49\x4F\x4E\x20\x48\x45\x41\x44\x45\x52\x5D\x0D\x0A", "plt" },
    { 18, "\x5B\x44\x65\x73\x69\x67\x6E\x5D\x0D\x0A\x56\x65\x72\x73\x69\x6F\x6E\x3D", "prjpcb" },
    { 18, "\x55\x6C\x65\x61\x64\x20\x50\x72\x69\x76\x61\x74\x65\x20\x44\x61\x74\x61", "upd" },
    { 18, "\x54\x49\x49\x6E\x74\x65\x72\x41\x63\x74\x69\x76\x65\x20\x46\x69\x6C\x65", "tii" },
    { 18, "\x53\x56\x47\x20\x47\x72\x61\x70\x68\x69\x63\x73\x20\x46\x69\x6C\x65\x00", "svg" },
    { 18, "\x53\x4F\x55\x4E\x44\x20\x53\x41\x4D\x50\x4C\x45\x20\x44\x41\x54\x41\x20", "smp" },
    { 18, "\x53\x4D\x41\x52\x54\x44\x52\x57\x01\x80\x0E\x00\x00\x00\x0A\x00\x68\x02", "sdt" },
    { 18, "\x50\x6C\x61\x6E\x74\x57\x41\x4C\x4B\x20\x56\x65\x72\x73\x69\x6F\x6E\x20", "model" },
    { 18, "\x4D\x61\x6E\x69\x66\x65\x73\x74\x2D\x56\x65\x72\x73\x69\x6F\x6E\x3A\x20", "mf" },
    { 18, "\x49\x49\x2A\x00\x08\x00\x00\x00\x0E\x00\x00\x01\x04\x00\x01\x00\x00\x00", "ldf" },
    { 18, "\x47\x4C\x57\x5A\x42\x30\x30\x34\xFF\xFF\x6E\x61\x6D\x65\x50\x00\x00\x00", "mcp" },
    { 18, "\x46\x69\x6C\x65\x20\x49\x6E\x76\x65\x73\x74\x69\x67\x61\x74\x6F\x72\x20", "fib" },
    { 18, "\x46\x61\x6D\x69\x6C\x79\x20\x54\x72\x65\x65\x20\x4D\x61\x6B\x65\x72\x20", "fbc" },
    { 18, "\x44\x6F\x63\x75\x6D\x65\x6E\x74\x20\x54\x79\x70\x65\x3A\x20\x57\x53\x45", "wse" },
    { 18, "\x44\x61\x77\x6E\x50\x61\x63\x6B\x2E\x54\x71\x44\x69\x67\x69\x74\x61\x6C", "dnp" },
    { 18, "\x44\x47\x49\x6E\x64\x65\x78\x50\x72\x6F\x6A\x65\x63\x74\x46\x69\x6C\x65", "d2v" },
    { 18, "\x43\x4D\x44\x46\x43\x72\x79\x73\x74\x61\x6C\x4D\x61\x6B\x65\x72\x4D\x08", "cmdf" },
    { 18, "\x43\x26\x43\x33\x20\x52\x45\x50\x4C\x41\x59\x20\x48\x45\x41\x44\x45\x52", "cnc3replay" },
    { 18, "\x3B\x20\x66\x6C\x61\x63\x20\x66\x69\x6E\x67\x65\x72\x70\x72\x69\x6E\x74", "ffp" },
    { 18, "\x23\x58\x54\x72\x6B\x43\x61\x64\x20\x56\x65\x72\x73\x69\x6F\x6E\x3A\x20", "xtc" },
    { 18, "\x22\x41\x72\x74\x4D\x6F\x6E\x65\x79\x20\x54\x61\x62\x6C\x65\x22\x2C\x22", "amt" },
    { 17, "\xEF\xBB\xBF\x3C\x4E\x55\x6E\x69\x74\x50\x72\x6F\x6A\x65\x63\x74\x3E", "nunit" },
    { 17, "\x5B\x57\x72\x69\x73\x74\x41\x70\x70\x5D\x0D\x0A\x4E\x61\x6D\x65\x3D", "app" },
    { 17, "\x56\x45\x52\x53\x49\x4F\x4E\x20\x31\x2E\x30\x20\x43\x4C\x41\x53\x53", "cls" },
    { 17, "\x54\x52\x53\x4E\x49\x46\x46\x20\x64\x61\x74\x61\x20\x20\x20\x20\x1A", "snf" },
    { 17, "\x53\x74\x61\x72\x74\x46\x6F\x6E\x74\x4D\x65\x74\x72\x69\x63\x73\x20", "afm" },
    { 17, "\x53\x63\x68\x65\x6D\x61\x74\x69\x63\x20\x46\x49\x4C\x45\x0D\x0A\x1A", "sch" },
    { 17, "\x53\x4E\x4E\x53\x20\x72\x65\x73\x75\x6C\x74\x20\x66\x69\x6C\x65\x20", "res" },
    { 17, "\x52\x53\x52\x43\x0D\x0A\x00\x03\x4C\x56\x49\x4E\x4C\x42\x56\x57\x00", "rbt" },
    { 17, "\x52\x41\x44\x20\x62\x79\x20\x52\x45\x41\x4C\x69\x54\x59\x21\x21\x10", "rad" },
    { 17, "\x50\x43\x42\x20\x4C\x41\x59\x4F\x55\x54\x20\x46\x49\x4C\x45\x1A\x00", "lyt" },
    { 17, "\x48\x4D\x20\x50\x72\x6F\x6A\x65\x63\x74\x20\x46\x69\x6C\x65\x20\x76", "hmp" },
    { 17, "\x46\x72\x65\x65\x20\x48\x69\x64\x65\x20\x46\x6F\x6C\x64\x65\x72\x20", "fhf" },
    { 17, "\x46\x46\x52\x20\x61\x72\x63\x68\x69\x76\x20\x66\x6F\x72\x6D\x61\x74", "ffr" },
    { 17, "\x44\x65\x72\x69\x76\x65\x20\x76\x65\x72\x73\x69\x6F\x6E\x20\x36\x2E", "dfw" },
    { 17, "\x43\x61\x64\x65\x6E\x74\x20\x33\x44\x20\x4D\x6F\x64\x65\x6C\x20\x56", "3dm" },
    { 17, "\x43\x49\x52\x43\x41\x44\x20\x56\x65\x72\x73\x69\x6F\x6E\x20\x34\x2E", "dwg" },
    { 17, "\x43\x49\x52\x43\x41\x44\x20\x56\x65\x72\x73\x69\x6F\x6E\x20\x33\x2E", "dwg" },
    { 17, "\x43\x49\x52\x43\x41\x44\x20\x56\x45\x52\x53\x49\x4F\x4E\x20\x35\x2E", "lib" },
    { 17, "\x43\x49\x52\x43\x41\x44\x20\x56\x45\x52\x53\x49\x4F\x4E\x20\x34\x2E", "lib" },
    { 17, "\x41\x75\x74\x6F\x43\x41\x44\x20\x53\x6C\x69\x64\x65\x0D\x0A\x1A\x00", "sld" },
    { 17, "\x41\x75\x74\x6F\x43\x41\x44\x20\x44\x58\x42\x20\x31\x2E\x30\x0D\x0A", "dxb" },
    { 17, "\x41\x75\x64\x61\x63\x69\x74\x79\x42\x6C\x6F\x63\x6B\x46\x69\x6C\x65", "auf" },
    { 17, "\x41\x42\x53\x30\x4C\x55\x54\x45\x44\x41\x54\x41\x42\x41\x53\x45\x4C", "abs" },
    { 17, "\x3C\x78\x73\x68\x65\x65\x74\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22", "xps" },
    { 17, "\x3C\x70\x72\x6F\x6A\x65\x63\x74\x3E\x0D\x0A\x3C\x6E\x61\x6D\x65\x3E", "fdp" },
    { 17, "\x3C\x6C\x6F\x61\x64\x65\x72\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22", "alx" },
    { 17, "\x3C\x55\x43\x53\x57\x44\x20\x4C\x41\x4E\x47\x55\x41\x47\x45\x3D\x22", "ucs" },
    { 17, "\x3C\x21\x44\x4F\x43\x54\x59\x50\x45\x20\x54\x53\x3E\x3C\x54\x53\x3E", "ts" },
    { 17, "\x37\x00\x00\x10\x6D\x00\x00\x10\xD2\x16\x00\x10\xDC\xF4\xDD\xFC\xD1", "tr" },
    { 17, "\x28\x45\x78\x70\x72\x65\x73\x73\x50\x72\x6F\x6A\x65\x63\x74\x20\x22", "opj" },
    { 17, "\x21\x74\x61\x62\x6C\x65\x0D\x0A\x21\x76\x65\x72\x73\x69\x6F\x6E\x20", "tab" },
    { 17, "\x20\x52\x47\x48\x2D\x58\x50\x52\x4F\x46\x41\x4E\x20\x55\x4E\x49\x54", "pcu" },
    { 17, "\x1B\x45\x1B\x25\x30\x42\x42\x50\x31\x2C\x22\x62\x69\x74\x6D\x61\x70", "rtl" },
    { 17, "\x11\x46\x72\x61\x63\x74\x61\x6C\x20\x46\x6F\x72\x67\x65\x20\x32\x2E", "mnd" },
    { 17, "\x10\x43\x61\x78\x61\x45\x62\x46\x6F\x72\x57\x69\x6E\x64\x6F\x77\x73", "exb" },
    { 17, "\x0D\x00\x00\x00\x53\x68\x61\x72\x6B\x50\x6F\x72\x74\x53\x61\x76\x65", "sps" },
    { 16, "\xFF\xFF\x00\x00\x0A\x00\x43\x43\x6F\x6C\x6F\x72\x4C\x69\x73\x74", "clr" },
    { 16, "\xE4\x52\x5C\x7B\x8C\xD8\xA7\x4D\xAE\xB1\x53\x78\xD0\x29\x96\xD3", "one" },
    { 16, "\xBE\xBA\x0C\x43\x44\x2D\x4C\x41\x42\x45\x4C\x20\x50\x52\x4F\x00", "cdl" },
    { 16, "\xB4\xB2\x6F\x93\xE2\xA6\x90\x07\x6F\xC9\xCC\x2C\x1A\xEB\xB9\x24", "rzx" },
    { 16, "\xA7\x7E\x7E\x2B\x01\x00\x00\x00\x04\x00\x00\x00\x72\x65\x52\x53", "rep" },
    { 16, "\xA5\xE2\xD6\x05\xD5\x9D\xCA\x23\xBE\x5A\x74\x72\x3C\x6F\x0C\x75", "fcs" },
    { 16, "\x9C\xCB\xCB\x8D\x13\x75\xD2\x11\x91\x58\x00\xC0\x4F\x79\x56\xA4", "wab" },
    { 16, "\x90\x0D\x03\x00\x02\x11\xC8\xFC\xA0\x02\x06\x7B\x03\xC9\x01\xAD", "lic" },
    { 16, "\x8B\x4A\x4E\x47\x0D\x0A\x1A\x0A\x00\x00\x00\x10\x4A\x48\x44\x52", "jng" },
    { 16, "\x8A\x4D\x4E\x47\x0D\x0A\x1A\x0A\x00\x00\x00\x1C\x4D\x48\x44\x52", "mng" },
    { 16, "\x89\x50\x4E\x47\x0D\x0A\x1A\x0A\x00\x00\x00\x0D\x49\x48\x44\x52", "png" },
    { 16, "\x89\x48\x50\x49\x0D\x0A\x1A\x0A\x64\x00\x00\x00\x20\x00\x00\x00", "hpi" },
    { 16, "\x72\x69\x66\x66\x2E\x91\xCF\x11\xA5\xD6\x28\xDB\x04\xC1\x00\x00", "w64" },
    { 16, "\x63\x6F\x6E\x74\x65\x6E\x74\x2D\x73\x74\x61\x72\x74\x20\x20\x3A", "mis" },
    { 16, "\x5B\x50\x61\x73\x73\x77\x6F\x72\x64\x20\x54\x6F\x6B\x65\x6E\x5D", "epf" },
    { 16, "\x5B\x49\x6E\x66\x6F\x5D\x0D\x0A\x56\x65\x72\x73\x69\x6F\x6E\x3D", "hps" },
    { 16, "\x5B\x44\x65\x73\x6B\x74\x6F\x70\x20\x45\x6E\x74\x72\x79\x5D\x0A", "desktop" },
    { 16, "\x5B\x44\x49\x52\x45\x43\x54\x4F\x52\x49\x45\x53\x5D\x0D\x0A\x20", "mol" },
    { 16, "\x5A\x58\x2D\x45\x64\x69\x74\x20\x64\x6F\x63\x75\x6D\x65\x6E\x74", "zed" },
    { 16, "\x58\x50\x43\x4F\x4D\x0A\x4D\x6F\x7A\x46\x41\x53\x4C\x0D\x0A\x1A", "mfl" },
    { 16, "\x54\x72\x61\x63\x65\x72\x43\x41\x44\x20\x46\x69\x6C\x65\x20\x76", "ak" },
    { 16, "\x54\x45\x52\x52\x41\x47\x45\x4E\x53\x55\x52\x46\x4D\x41\x50\x32", "srf" },
    { 16, "\x54\x41\x44\x53\x32\x20\x62\x69\x6E\x0A\x0D\x1A\x00\x76\x32\x2E", "gam" },
    { 16, "\x53\x74\x75\x66\x66\x49\x74\x20\x28\x63\x29\x31\x39\x39\x37\x2D", "sit" },
    { 16, "\x53\x43\x43\x20\x3D\x20\x54\x68\x69\x73\x20\x69\x73\x20\x61\x20", "scc" },
    { 16, "\x53\x00\x50\x00\x4C\x00\x49\x00\x54\x00\x43\x00\x49\x00\x4C\x00", "cil" },
    { 16, "\x50\xEF\x81\x19\xB3\xBD\xD0\x11\xA3\xE5\x00\xA0\xC9\x24\x44\x37", "ivf" },
    { 16, "\x50\x61\x63\x6B\x65\x64\x49\x6D\x61\x67\x65\x73\x30\x31\x00\x00", "ipk" },
    { 16, "\x4F\x52\x54\x49\x4D\x20\x50\x52\x4F\x20\x5A\x53\x74\x75\x64\x20", "ob3" },
    { 16, "\x4D\x69\x63\x72\x6F\x73\x6F\x66\x74\x20\x43\x2F\x43\x2B\x2B\x20", "pdb" },
    { 16, "\x4D\x45\x44\x49\x41\x20\x44\x45\x53\x43\x52\x49\x50\x54\x4F\x52", "mds" },
    { 16, "\x4D\x41\x53\x53\x49\x56\x45\x46\x49\x4C\x45\x00\x03\x00\x03\x00", "pak" },
    { 16, "\x4A\x65\x74\x69\x63\x6F\x45\x6E\x63\x72\x79\x70\x74\x41\x72\x63", "bca" },
    { 16, "\x4A\x41\x53\x43\x20\x42\x52\x4F\x57\x53\x20\x46\x49\x4C\x45\x00", "jbf" },
    { 16, "\x49\x54\x53\x46\x03\x00\x00\x00\x60\x00\x00\x00\x01\x00\x00\x00", "chi" },
    { 16, "\x48\x45\x41\x44\x37\x34\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00", "lan" },
    { 16, "\x47\x52\x41\x50\x48\x54\x45\x43\x20\x50\x52\x54\x26\x43\x55\x54", "gsd" },
    { 16, "\x46\x55\x4A\x49\x46\x49\x4C\x4D\x43\x43\x44\x2D\x52\x41\x57\x20", "raf" },
    { 16, "\x46\x41\x43\x45\x54\x20\x46\x49\x4C\x45\x20\x46\x52\x4F\x4D\x20", "facet" },
    { 16, "\x45\x52\x46\x53\x53\x41\x56\x45\x44\x41\x54\x41\x46\x49\x4C\x45", "dat" },
    { 16, "\x43\x4F\x52\x45\x4C\x20\x50\x68\x6F\x74\x6F\x50\x61\x69\x6E\x74", "crv" },
    { 16, "\x42\x4F\x4F\x54\x32\x20\x3D\x20\x63\x64\x72\x6F\x6D\x30\x3A\x5C", "cnf" },
    { 16, "\x41\x67\x65\x6E\x64\x61\x46\x69\x6C\x65\x54\x79\x70\x65\x2A\x00", "agn" },
    { 16, "\x41\x53\x57\x73\x65\x74\x75\x70\x44\x50\x6B\x67\x46\x69\x6C\x65", "vpu" },
    { 16, "\x41\x4D\x43\x20\x56\x31\x2E\x32\x20\x52\x45\x50\x4C\x41\x59\x21", "amc" },
    { 16, "\x3C\x53\x48\x41\x52\x50\x20\x57\x5A\x44\x20\x44\x41\x54\x41\x3E", "wzd" },
    { 16, "\x3B\x6E\x79\x71\x75\x69\x73\x74\x20\x70\x6C\x75\x67\x2D\x69\x6E", "ny" },
    { 16, "\x36\x34\x4C\x41\x4E\x20\x49\x44\x42\x4C\x4F\x43\x4B\x20\x0D\x0A", "l64" },
    { 16, "\x30\x26\xB2\x75\x8E\x66\xCF\x11\xA6\xD9\x00\xAA\x00\x62\xCE\x6C", "wma" },
    { 16, "\x2F\x2A\x20\x53\x55\x49\x54\x20\x76\x65\x72\x73\x69\x6F\x6E\x20", "sui" },
    { 16, "\x2F\x2A\x0D\x0A\x53\x61\x6D\x70\x6C\x65\x49\x64\x65\x6E\x74\x20", "xdd" },
    { 16, "\x2E\x00\x00\xEA\x00\x00\x00\x00\x00\x00\x00\x00\x23\x23\x23\x23", "nds" },
    { 16, "\x23\x0D\x0A\x23\x20\x4D\x6F\x64\x65\x6C\x49\x44\x73\x20\x0D\x0A", "ide" },
    { 16, "\x21\x42\x49\x4F\x53\x59\x4D\x20\x61\x72\x63\x68\x69\x76\x65\x20", "car" },
    { 16, "\x20\x53\x74\x61\x74\x69\x73\x74\x69\x63\x73\x20\x66\x6F\x72\x20", "stat" },
    { 16, "\x13\xE5\xCA\x16\xEC\x99\x24\x7E\x8E\xB7\x1D\xF6\x92\x33\x11\xE7", "ism" },
    { 16, "\x11\xFE\xD5\x0B\x05\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00", "map" },
    { 16, "\x10\xAB\xAA\xA8\x6F\x7B\x7E\x78\x7E\x76\x7E\x74\x77\x74\x79\x77", "bhf" },
    { 16, "\x06\x00\x00\x00\x07\x4D\x4F\x50\x46\x69\x6C\x65\x02\x00\x35\x00", "mop" },
    { 16, "\x03\x00\x00\x00\x26\x00\x00\x00\x46\x55\x47\x52\x54\x45\xFF\xFF", "rte" },
    { 16, "\x00\x08\xFF\x00\x00\x00\x10\x00\x52\x53\x46\x54\x53\x54\x59\x4C", "ens" },
    { 16, "\x00\x01\x4D\x45\x20\x44\x4F\x43\x54\x4F\x52\x20\x53\x46\x20\x33", "smc" },
    { 16, "\x00\x01\x04\x03\x46\x0C\x1E\x18\x7D\x01\x1B\x21\xCC\x95\x81\xA4", "" },
    { 16, "\x00\x00\x04\x03\x46\x0C\x1E\x18\x7D\x01\x1B\x21\xCC\x95\x81\xA4", "" },
    { 16, "\x00\x00\x00\x00\x16\x00\x00\x00\x47\x52\x4D\x52\x45\x43\x30\x30", "gpi" },
    { 15, "\xDE\x00\x6E\x61\x6E\x6F\x7A\x69\x70\x20\x61\x6C\x70\x68\x61", "nz" },
    { 15, "\x90\x0D\x03\x00\x02\x11\xC8\xFC\xA0\x02\x06\x7B\x03\xC9\x01", "nup" },
    { 15, "\x67\x6D\x76\x69\x6E\x70\x75\x74\x20\x61\x73\x63\x69\x69\x0A", "gmv" },
    { 15, "\x5B\x73\x63\x72\x69\x70\x74\x5D\x0D\x0A\x6B\x65\x79\x31\x3D", "vpm" },
    { 15, "\x5B\x57\x69\x6E\x64\x6F\x77\x73\x20\x4C\x61\x74\x69\x6E\x20", "cpx" },
    { 15, "\x5B\x53\x43\x46\x5D\x0D\x0A\x43\x4F\x4D\x50\x41\x4E\x59\x3D", "scf" },
    { 15, "\x5B\x50\x69\x63\x61\x73\x61\x5D\x0D\x0A\x6E\x61\x6D\x65\x3D", "ini" },
    { 15, "\x5B\x4F\x44\x42\x43\x5D\x0D\x0A\x44\x52\x49\x56\x45\x52\x3D", "dsn" },
    { 15, "\x5B\x43\x61\x70\x74\x6F\x72\x47\x72\x6F\x75\x70\x5D\x0D\x0A", "cgp" },
    { 15, "\x57\x69\x6E\x74\x65\x63\x4C\x6F\x67\x46\x6F\x72\x6D\x61\x74", "tk1" },
    { 15, "\x53\x69\x6D\x73\x32\x20\x50\x61\x63\x6B\x61\x67\x65\x72\x20", "sims2pack" },
    { 15, "\x52\x65\x6C\x69\x63\x20\x43\x68\x75\x6E\x6B\x79\x0D\x0A\x1A", "" },
    { 15, "\x52\x41\x59\x53\x20\x4D\x45\x44\x49\x41\x20\x46\x49\x4C\x45", "mda" },
    { 15, "\x50\x49\x41\x46\x49\x4C\x45\x56\x45\x52\x53\x49\x4F\x4E\x5F", "pc3" },
    { 15, "\x4F\x51\x4E\x51\x57\x15\x09\x4A\x3F\x5D\x50\x4C\x3D\x4C\x46", "emi" },
    { 15, "\x4F\x50\x4C\x44\x61\x74\x61\x62\x61\x73\x65\x46\x69\x6C\x65", "dbf" },
    { 15, "\x4E\x4F\x44\x33\x32\x2D\x4D\x4F\x44\x55\x4C\x45\x20\x2D\x20", "" },
    { 15, "\x4C\x4D\x1A\x08\x00\x12\x10\x00\x80\xD1\x05\x00\x00\x23\xF1", "lim" },
    { 15, "\x49\x6D\x61\x67\x65\x46\x69\x6C\x65\x54\x79\x70\x65\x2A\x2A", "app" },
    { 15, "\x49\x4D\x41\x5F\x41\x44\x50\x43\x4D\x5F\x53\x6F\x75\x6E\x64", "iss" },
    { 15, "\x47\x57\x20\x50\x72\x65\x66\x76\x65\x72\x73\x69\x6F\x6E\x3B", "gwp" },
    { 15, "\x45\x48\x46\x41\x5F\x48\x45\x41\x44\x45\x52\x5F\x54\x41\x47", "hfa" },
    { 15, "\x44\x56\x44\x5F\x54\x45\x58\x54\x5F\x44\x41\x54\x41\x0D\x0A", "txtdt" },
    { 15, "\x43\x44\x58\x00\x43\x58\x44\x61\x74\x61\x62\x61\x73\x65\x56", "sdx" },
    { 15, "\x42\x72\x79\x63\x65\x5F\x36\x2E\x30\x5F\x46\x69\x6C\x65\x00", "br6" },
    { 15, "\x42\x61\x67\x20\x41\x74\x74\x72\x69\x62\x75\x74\x65\x73\x0A", "crt" },
    { 15, "\x42\x45\x47\x49\x4E\x3A\x45\x4D\x45\x4C\x4F\x44\x59\x0D\x0A", "emy" },
    { 15, "\x41\x72\x43\x6F\x6E\x20\x2D\x20\x50\x72\x6F\x6A\x65\x6B\x74", "acp" },
    { 15, "\x41\x64\x76\x61\x6E\x74\x61\x67\x65\x20\x54\x61\x62\x6C\x65", "adt" },
    { 15, "\x41\x4C\x61\x77\x53\x6F\x75\x6E\x64\x46\x69\x6C\x65\x2A\x2A", "wve" },
    { 15, "\x3C\x74\x65\x6D\x70\x6C\x61\x74\x65\x5F\x69\x6E\x66\x6F\x3E", "cti" },
    { 15, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22", "hud" },
    { 15, "\x33\x44\x2D\x57\x6F\x68\x6E\x75\x6E\x67\x73\x50\x6C\x61\x6E", "wds" },
    { 15, "\x33\x44\x2D\x48\x61\x75\x73\x44\x65\x73\x69\x67\x6E\x65\x72", "wds" },
    { 15, "\x32\x37\x4D\x41\x49\x4E\x20\x46\x49\x52\x4D\x57\x41\x52\x45", "fw" },
    { 15, "\x23\x23\x52\x65\x6E\x64\x65\x72\x4D\x61\x6E\x20\x52\x49\x42", "rib" },
    { 15, "\x0E\x44\x43\x57\x49\x4E\x20\x44\x72\x61\x77\x69\x6E\x67\x1A", "dcw" },
    { 15, "\x0E\x2D\x2D\x2D\x56\x49\x53\x49\x46\x4F\x52\x4D\x2D\x2D\x2D", "vft" },
    { 15, "\x00\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\x00\x00\x02\x00", "iso" },
    { 15, "\x00\x01\x00\x00\x00\x02\x00\x01\x00\x05\x00\x02\x00\x02\xC0", "fp5" },
    { 14, "\xFF\xFF\x02\x00\x08\x00\x43\x43\x69\x72\x63\x75\x69\x74", "cyp" },
    { 14, "\xFF\xFE\x43\x00\x4C\x00\x41\x00\x53\x00\x53\x00\x20\x00", "adm" },
    { 14, "\xFF\xFE\x3C\x00\x3F\x00\x78\x00\x6D\x00\x6C\x00\x20\x00", "cbcx" },
    { 14, "\xFE\x01\x07\x09\x03\x00\x00\x10\x01\x00\x00\x30\x00\x00", "frm" },
    { 14, "\xB0\x0C\xB0\x0C\x02\x00\x4E\x55\x56\x4F\x00\x00\x00\x00", "rb" },
    { 14, "\x89\x4F\x50\x53\x00\x04\x00\x4B\x00\x4B\x01\x02\x03\x04", "" },
    { 14, "\x78\x63\x72\x20\x46\x69\x6C\x65\x20\x31\x2E\x30\x30\x00", "xcr" },
    { 14, "\x6A\x77\x5F\x63\x61\x64\x28\x63\x29\x64\x61\x74\x61\x2E", "jwc" },
    { 14, "\x69\x64\x3D\x49\x6D\x61\x67\x65\x4D\x61\x67\x69\x63\x6B", "miff" },
    { 14, "\x5C\x69\x6E\x70\x75\x74\x20\x74\x65\x78\x69\x6E\x66\x6F", "texi" },
    { 14, "\x5B\x53\x50\x53\x20\x50\x52\x45\x53\x45\x54\x5D\x0D\x0A", "sps" },
    { 14, "\x5A\x69\x6E\x63\x20\x44\x61\x74\x61\x20\x46\x69\x6C\x65", "dat" },
    { 14, "\x56\x69\x73\x74\x61\x20\x44\x45\x4D\x20\x46\x69\x6C\x65", "dem" },
    { 14, "\x56\x45\x52\x53\x49\x4F\x4E\x20\x35\x2E\x30\x30\x0D\x0A", "frm" },
    { 14, "\x53\x69\x6D\x75\x6C\x61\x74\x69\x6F\x6E\x43\x61\x73\x65", "hsc" },
    { 14, "\x52\x43\x4C\x46\x01\x00\x00\x00\x02\x00\x00\x00\x42\x4D", "rcl" },
    { 14, "\x50\x4C\x55\x53\x5F\x50\x52\x45\x46\x5F\x50\x41\x43\x4B", "pld" },
    { 14, "\x50\x4C\x43\x20\x44\x61\x74\x61\x20\x46\x69\x6C\x65\x2E", "vd" },
    { 14, "\x50\x43\x53\x00\x14\x00\x00\x00\x01\x00\x0D\x00\x00\x00", "wdk" },
    { 14, "\x4F\x67\x67\x53\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00", "ogg" },
    { 14, "\x4F\x64\x49\x6F\x42\x6A\x45\x63\x54\x73\x54\x6F\x52\x65", "" },
    { 14, "\x4D\x69\x6E\x64\x73\x74\x6F\x72\x6D\x73\x4E\x58\x54\x00", "rxe" },
    { 14, "\x4D\x61\x67\x69\x63\x44\x72\x61\x77\x55\x4D\x4C\x20\x22", "mdr" },
    { 14, "\x4D\x53\x48\x58\x31\x0D\x0A\x47\x52\x4F\x55\x50\x53\x20", "msh" },
    { 14, "\x4C\x69\x71\x75\x69\x64\x20\x4D\x6F\x64\x75\x6C\x65\x3A", "liq" },
    { 14, "\x4C\x69\x4F\x6E\x48\x65\x41\x64\x48\x65\x61\x64\x65\x72", "ter" },
    { 14, "\x4C\x47\x20\x52\x65\x73\x20\x46\x69\x6C\x65\x20\x76\x32", "res" },
    { 14, "\x47\x4C\x45\x56\x4E\x57\x30\x31\x0A\x42\x4F\x41\x52\x44", "nw" },
    { 14, "\x44\x45\x53\x49\x2D\x49\x49\x49\x2D\x42\x49\x4E\x2D\x56", "din" },
    { 14, "\x44\x41\x54\x41\x5F\x42\x4C\x4F\x43\x4B\x20\x44\x42\x20", "awl" },
    { 14, "\x43\x72\x65\x61\x74\x65\x20\x41\x20\x51\x75\x69\x7A\x20", "qz" },
    { 14, "\x43\x6F\x6E\x74\x65\x6E\x74\x2D\x54\x79\x70\x65\x3A\x20", "gcd" },
    { 14, "\x3C\x6D\x61\x70\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D\x22", "mm" },
    { 14, "\x3C\x3F\x78\x6D\x6C\x20\x76\x65\x72\x73\x69\x6F\x6E\x3D", "manifest" },
    { 14, "\x3B\x20\x43\x61\x6C\x69\x62\x72\x61\x74\x69\x6F\x6E\x20", "cal" },
    { 14, "\x2F\x54\x49\x54\x4C\x45\x20\x4D\x6F\x64\x65\x6C\x3A\x20", "ans" },
    { 14, "\x2E\x44\x57\x50\x03\x10\x00\x00\x00\x00\x00\x00\x00\x00", "dwp" },
    { 14, "\x23\x62\x65\x67\x69\x6E\x5B\x47\x41\x45\x42\x5D\x0D\x0A", "" },
    { 14, "\x23\x48\x53\x51\x4C\x20\x64\x61\x74\x61\x62\x61\x73\x65", "properties" },
    { 14, "\x23\x20\x54\x69\x6E\x79\x44\x69\x73\x6B\x46\x69\x6C\x65", "tdf" },
    { 14, "\x22\x47\x72\x61\x70\x68\x69\x63\x57\x6F\x72\x6B\x73\x20", "dvg" },
    { 14, "\x21\x21\x43\x6F\x6D\x70\x72\x65\x73\x73\x65\x64\x21\x21", "zvr" },
    { 14, "\x0E\x4E\x54\x49\x5F\x43\x44\x4C\x41\x59\x4F\x55\x54\x56", "cdm" },
    { 14, "\x0D\x63\x6F\x6D\x62\x5F\x65\x6D\x5F\x6C\x69\x62\x5F\x31", "elc" },
    { 14, "\x0D\x41\x70\x74\x69\x51\x75\x69\x7A\x20\x46\x69\x6C\x65", "aq1" },
    { 14, "\x01\x4D\x61\x64\x6F\x6E\x6E\x61\x4D\x6F\x64\x65\x6C\xF8", "mmd" },
    { 14, "\x00\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x00\x00", "lbr" },
    { 14, "\x00\x00\x02\x00\x06\x04\x06\x00\x08\x00\x00\x00\x00\x00", "wk1" },
    { 14, "\x00\x00\x00\x18\x66\x74\x79\x70\x6D\x71\x74\x20\x01\x00", "mqv" },
    { 14, "\x00\x00\x00\x00\x20\x00\x00\x00\xFF\xFF\x00\x00\xFF\xFF", "res" },
    { 13, "\xED\xA5\x8D\xBF\x20\x43\x68\x69\x73\x68\x6D\x00\x01", "dldi" },
    { 13, "\xAA\x04\x00\x00\x00\x00\xAD\xBB\xDA\x04\x00\x00\x00", "rk" },
    { 13, "\x76\x74\x69\x5F\x65\x6E\x63\x6F\x64\x69\x6E\x67\x3A", "" },
    { 13, "\x76\x32\x30\x30\x33\x2E\x31\x30\x0D\x0A\x30\x0D\x0A", "flt" },
    { 13, "\x65\x64\x32\x6B\x3A\x2F\x2F\x7C\x66\x69\x6C\x65\x7C", "ed2k" },
    { 13, "\x63\x61\x74\x61\x6C\x6F\x67\x2F\x49\x4E\x44\x45\x58", "depot" },
    { 13, "\x5B\x62\x6F\x6F\x74\x20\x6C\x6F\x61\x64\x65\x72\x5D", "ini" },
    { 13, "\x5B\x56\x51\x48\x4C\x50\x45\x44\x46\x49\x4C\x45\x5F", "hlx" },
    { 13, "\x5B\x53\x63\x72\x69\x70\x74\x20\x49\x6E\x66\x6F\x5D", "ass" },
    { 13, "\x58\x50\x43\x4F\x4D\x0A\x54\x79\x70\x65\x4C\x69\x62", "xpt" },
    { 13, "\x56\x45\x52\x49\x43\x55\x54\x2D\x6D\x6F\x64\x65\x6C", "" },
    { 13, "\x54\x79\x70\x65\x3D\x4F\x6C\x65\x44\x6C\x6C\x0D\x0A", "vbp" },
    { 13, "\x54\x57\x32\x20\x53\x61\x76\x65\x67\x61\x6D\x65\x00", "sav" },
    { 13, "\x54\x49\x2D\x4E\x73\x70\x69\x72\x65\x2E\x74\x6E\x6F", "tno" },
    { 13, "\x54\x49\x2D\x4E\x73\x70\x69\x72\x65\x2E\x74\x6E\x63", "tnc" },
    { 13, "\x54\x45\x53\x34\x53\x41\x56\x45\x47\x41\x4D\x45\x00", "ess" },
    { 13, "\x54\x41\x42\x4C\x45\x0D\x0A\x30\x2C\x31\x0D\x0A\x22", "dif" },
    { 13, "\x53\x54\x41\x52\x20\x44\x41\x54\x41\x20\x56\x33\x2E", "st3" },
    { 13, "\x53\x50\x45\x45\x44\x59\x2D\x53\x59\x53\x54\x45\x4D", "ss" },
    { 13, "\x52\x65\x74\x75\x72\x6E\x2D\x50\x61\x74\x68\x3A\x20", "eml" },
    { 13, "\x52\x43\x41\x44\x20\x73\x63\x72\x69\x70\x74\x0D\x0A", "txt" },
    { 13, "\x50\x72\x6F\x54\x72\x61\x63\x6B\x65\x72\x20\x33\x2E", "pt3" },
    { 13, "\x50\x4F\x43\x4B\x45\x54\x50\x43\x49\x4D\x41\x47\x45", "pbf" },
    { 13, "\x50\x4C\x55\x53\x5F\x53\x4E\x44\x5F\x50\x41\x43\x4B", "plp" },
    { 13, "\x4D\x65\x74\x65\x6F\x72\x6F\x6C\x6F\x67\x79\x3A\x20", "met" },
    { 13, "\x4D\x50\x43\x50\x4C\x41\x59\x4C\x49\x53\x54\x0D\x0A", "mpcpl" },
    { 13, "\x49\x6E\x53\x74\x61\x72\x74\x20\x65\x42\x4F\x4F\x4B", "ebx" },
    { 13, "\x49\x53\x4F\x2D\x31\x30\x33\x30\x33\x2D\x32\x31\x3B", "stp" },
    { 13, "\x47\x42\x58\x06\x00\x42\x55\x43\x52\x00\x30\x00\x24", "gbx" },
    { 13, "\x46\x46\x46\x48\xFF\xFF\xFF\xFF\x00\x00\x00\x00\x00", "bpd" },
    { 13, "\x46\x44\x4D\x20\x44\x6F\x77\x6E\x6C\x6F\x61\x64\x73", "sav" },
    { 13, "\x44\x46\x04\x00\x00\x00\x00\x00\x00\x00\x10\x00\x24", "fnd" },
    { 13, "\x43\x6F\x72\x65\x6C\x43\x45\x4E\x54\x52\x41\x4C\x20", "adb" },
    { 13, "\x43\x61\x74\x61\x6C\x6F\x67\x20\x33\x2E\x30\x30\x00", "ctf" },
    { 13, "\x42\x45\x47\x49\x4E\x3A\x49\x4D\x45\x4C\x4F\x44\x59", "imelody" },
    { 13, "\x41\x75\x64\x69\x74\x69\x6F\x6E\x4D\x75\x73\x69\x63", "abm" },
    { 13, "\x41\x43\x43\x45\x4C\x5F\x41\x53\x43\x49\x49\x20\x22", "pcb" },
    { 13, "\x3C\x54\x66\x49\x44\x20\x76\x65\x72\x3D\x22\x30\x2E", "xml" },
    { 13, "\x3C\x3C\x3C\x44\x45\x53\x43\x3E\x3E\x3E\x0D\x0A\x09", "ezc" },
    { 13, "\x38\x42\x50\x53\x00\x01\x00\x00\x00\x00\x00\x00\x00", "psd" },
    { 13, "\x33\x44\x4D\x65\x74\x61\x66\x69\x6C\x65\x20\x28\x20", "3dmf" },
    { 13, "\x2F\x4A\x4F\x42\x0D\x0A\x2F\x2F\x4E\x41\x4D\x45\x20", "jbi" },
    { 13, "\x2E\x65\x6E\x63\x6F\x64\x69\x6E\x67\x20\x3D\x20\x22", "vmx" },
    { 13, "\x28\x43\x48\x49\x57\x52\x49\x54\x45\x52\x20\x34\x2E", "chi" },
    { 13, "\x23\x55\x47\x43\x3A\x32\x20\x50\x41\x52\x54\x20\x31", "prt" },
    { 13, "\x23\x2C\x54\x52\x41\x56\x45\x52\x53\x45\x20\x50\x43", "trv" },
    { 13, "\x1F\x8B\x08\x00\x00\x00\x00\x00\x00\x0B\xEC\xDD\x07", "sav" },
    { 13, "\x0C\x49\x4C\x4C\x55\x53\x49\x4F\x4E\x33\x6C\x69\x62", "il3" },
    { 13, "\x0C\x41\x63\x74\x69\x76\x65\x20\x54\x75\x74\x6F\x72", "arf" },
    { 13, "\x01\x80\xED\x7F\x00\x80\xED\x0A\x00\x03\xED\x03\x00", "ace" },
    { 13, "\x00\x01\x0F\x00\x46\x52\x45\x45\x4C\x41\x4E\x43\x45", "prz" },
    { 12, "\xFF\xFE\x3C\x00\x3F\x00\x78\x00\x6D\x00\x6C\x00", "ipj" },
    { 12, "\xF7\x02\x01\x83\x92\xC0\x1C\x3B\x00\x00\x00\x00", "dvi" },
    { 12, "\xEF\xBB\xBF\x23\x45\x58\x54\x4D\x33\x55\x0D\x0A", "m3u8" },
    { 12, "\xC8\xC4\xD9\x40\xC1\xD9\xC5\xC1\x00\x00\x04\xD0", "goe" },
    { 12, "\xC1\x83\x2A\x9E\x45\x00\x00\x00\x01\x00\x00\x00", "run" },
    { 12, "\x8A\x01\x09\x00\x00\x00\xE1\x08\x00\x00\x99\x19", "aw" },
    { 12, "\x77\x77\x77\x77\x03\x00\x00\x00\x20\x00\x00\x00", "sparc" },
    { 12, "\x70\x61\x63\x6B\x61\x67\x65\x31\x78\x78\x78\x78", "pkg" },
    { 12, "\x6B\x70\x01\x00\x50\x03\x20\x50\x03\x20\x00\x00", "pbu" },
    { 12, "\x61\x4C\x75\x5A\x6B\x55\x74\x5A\x2C\x00\x00\x00", "dbd" },
    { 12, "\x5F\x41\x52\x43\x48\x49\x56\x45\x02\x00\x00\x00", "big" },
    { 12, "\x5B\x52\x65\x66\x65\x72\x65\x6E\x63\x65\x5D\x0D", "wvx" },
    { 12, "\x5B\x42\x4F\x54\x5D\x0D\x0A\x4E\x61\x6D\x65\x3D", "bot" },
    { 12, "\x58\x65\x6E\x6F\x44\x72\x65\x61\x6D\x50\x61\x72", "xep" },
    { 12, "\x57\x69\x6E\x48\x65\x78\x20\x50\x6F\x73\x20\x76", "pos" },
    { 12, "\x56\x69\x72\x74\x75\x61\x4E\x45\x53\x20\x4D\x56", "vmv" },
    { 12, "\x56\x45\x52\x53\x49\x4F\x4E\x20\x35\x2E\x30\x30", "dsr" },
    { 12, "\x54\x79\x70\x65\x3D\x43\x6F\x6E\x74\x72\x6F\x6C", "vbp" },
    { 12, "\x54\x69\x6D\x65\x6C\x69\x6E\x65\x72\x20\x35\x2E", "tl5" },
    { 12, "\x54\x65\x78\x74\x43\x6F\x6C\x6F\x72\x45\x57\x7C", "rcs" },
    { 12, "\x54\x50\x55\x51\x00\x00\x00\x00\xE2\x00\x60\x00", "tpu" },
    { 12, "\x54\x50\x55\x39\x00\x00\x00\x00\xD2\x00\x50\x00", "tpu" },
    { 12, "\x54\x50\x55\x36\x00\x00\x00\x00\xC2\x00\x40\x00", "tpu" },
    { 12, "\x53\x61\x6D\x70\x6C\x65\x49\x64\x65\x6E\x74\x2C", "udf" },
    { 12, "\x53\x51\x4C\x4F\x43\x4F\x4E\x56\x48\x44\x00\x00", "cnv" },
    { 12, "\x53\x46\x50\x4B\x01\x00\x00\x00\x40\x00\x00\x00", "sfk" },
    { 12, "\x53\x45\x41\x47\x55\x4C\x4C\x20\x4A\x57\x52\x20", "jwr" },
    { 12, "\x53\x41\x50\x0D\x0A\x41\x55\x54\x48\x4F\x52\x20", "sap" },
    { 12, "\x52\x65\x6C\x69\x63\x20\x43\x68\x75\x6E\x6B\x79", "rsh" },
    { 12, "\x52\x4D\x41\x50\x72\x65\x73\x6F\x75\x72\x63\x65", "lfd" },
    { 12, "\x50\x73\x32\x50\x6F\x77\x65\x72\x53\x61\x76\x65", "max" },
    { 12, "\x50\x65\x72\x46\x4F\x52\x4D\x20\x50\x52\x4F\x20", "frl" },
    { 12, "\x50\x4F\x4C\x20\x46\x6F\x72\x6D\x61\x74\x20\x76", "pol" },
    { 12, "\x50\x43\x53\x00\x14\x00\x00\x00\x07\x00\x00\x00", "wdg" },
    { 12, "\x50\x43\x53\x00\x14\x00\x00\x00\x03\x00\x07\x00", "mmo" },
    { 12, "\x50\x43\x53\x00\x14\x00\x00\x00\x03\x00\x00\x00", "wde" },
    { 12, "\x50\x43\x53\x00\x14\x00\x00\x00\x02\x00\x0B\x00", "wdy" },
    { 12, "\x50\x43\x53\x00\x14\x00\x00\x00\x02\x00\x00\x00", "wdw" },
    { 12, "\x50\x43\x53\x00\x14\x00\x00\x00\x01\x00\x0E\x00", "wdi" },
    { 12, "\x50\x43\x53\x00\x14\x00\x00\x00\x01\x00\x07\x00", "fic" },
    { 12, "\x50\x43\x53\x00\x14\x00\x00\x00\x01\x00\x00\x00", "wdp" },
    { 12, "\x4F\x4B\x54\x41\x53\x4F\x4E\x47\x43\x4D\x4F\x44", "okt" },
    { 12, "\x4F\x42\x49\x53\x59\x4E\x54\x48\x50\x41\x43\x4B", "osp" },
    { 12, "\x4D\x79\x74\x68\x54\x56\x56\x69\x64\x65\x6F\x00", "nuv" },
    { 12, "\x4D\x56\x20\x2D\x20\x43\x50\x43\x45\x4D\x55\x20", "dsk" },
    { 12, "\x4D\x50\x4C\x53\x30\x32\x30\x30\x00\x00\x00\x3A", "mpls" },
    { 12, "\x4D\x50\x4C\x53\x30\x31\x30\x30\x00\x00\x00\x3A", "mpl" },
    { 12, "\x4D\x31\x00\x00\x53\x44\x2D\x56\x4F\x49\x43\x45", "plm" },
    { 12, "\x4C\x4D\x45\x00\x28\x63\x29\x31\x39\x39\x30\x20", "lme" },
    { 12, "\x4A\x6F\x79\x21\x70\x65\x66\x66\x70\x77\x70\x63", "" },
    { 12, "\x49\x43\x43\x30\x01\x00\x00\x00\x49\x43\x4F\x4E", "icc" },
    { 12, "\x46\x6F\x75\x6E\x64\x65\x72\x20\x43\x45\x42\x20", "ceb" },
    { 12, "\x46\x69\x6C\x65\x56\x65\x72\x73\x69\x6F\x6E\x20", "kla" },
    { 12, "\x46\x4F\x52\x4D\x00\x00\x00\x14\x48\x45\x41\x44", "rot" },
    { 12, "\x46\x41\x58\x43\x4F\x56\x45\x52\x2D\x56\x45\x52", "cpe" },
    { 12, "\x45\x6C\x65\x63\x62\x79\x74\x65\x53\x70\x72\x00", "sff" },
    { 12, "\x45\x6C\x65\x63\x62\x79\x74\x65\x53\x6E\x64\x00", "snd" },
    { 12, "\x45\x6C\x65\x63\x62\x79\x74\x65\x46\x6E\x74\x00", "fnt" },
    { 12, "\x44\x72\x61\x77\xC9\x00\x00\x00\x00\x00\x00\x00", "" },
    { 12, "\x44\x53\x4E\x47\x53\x45\x51\x55\x00\x00\x01\x00", "dh" },
    { 12, "\x44\x41\x54\x45\x4C\x47\x43\x5F\x53\x41\x56\x45", "sav" },
    { 12, "\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\x3A", "crt" },
    { 12, "\x43\x4F\x56\x45\x52\x20\x45\x44\x49\x54\x4F\x52", "ncd" },
    { 12, "\x42\x63\x50\x72\x6F\x6A\x65\x63\x74\x0D\x0A\x6F", "pmr" },
    { 12, "\x42\x45\x47\x49\x4E\x5F\x44\x45\x53\x43\x0D\x0A", "scn" },
    { 12, "\x41\x53\x48\x50\x50\x45\x4E\x43\x45\x4E\x43\x48", "ppenc" },
    { 12, "\x41\x4F\x4C\x20\x46\x65\x65\x64\x62\x61\x67\x20", "bag" },
    { 12, "\x40\x4D\x55\x4C\x54\x49\x2D\x45\x44\x49\x54\x20", "mew" },
    { 12, "\x3C\x61\x70\x70\x6C\x69\x63\x61\x74\x69\x6F\x6E", "mcl" },
    { 12, "\x3C\x53\x44\x4F\x20\x63\x6C\x73\x69\x64\x3D\x22", "sv2i" },
    { 12, "\x3C\x4C\x43\x46\x56\x3A\x33\x3E\x0A\xFF\x24\x01", "xpr" },
    { 12, "\x36\x0C\xFF\x02\x00\x00\x00\x00\x00\x00\x00\x00", "b8" },
    { 12, "\x31\x32\x33\x2D\x34\x35\x36\x2D\x53\x54\x44\x00", "gme" },
    { 12, "\x30\x20\x42\x45\x47\x49\x4E\x20\x50\x47\x4D\x20", "" },
    { 12, "\x2F\x2F\x4D\x61\x79\x61\x20\x41\x53\x43\x49\x49", "ma" },
    { 12, "\x26\x0C\xFF\x02\x00\x00\x00\x00\x00\x00\x00\x00", "g8" },
    { 12, "\x23\x4D\x49\x4E\x44\x52\x45\x4E\x44\x45\x52\x20", "odt" },
    { 12, "\x23\x20\x24\x43\x72\x65\x61\x74\x6F\x72\x3A\x20", "std" },
    { 12, "\x21\x48\x65\x61\x64\x65\x72\x20\x67\x70\x72\x20", "gpr" },
    { 12, "\x20\x70\x61\x66\x00\x00\x00\x00\x01\x00\x00\x00", "paf" },
    { 12, "\x16\x0C\xFF\x02\x00\x00\x00\x00\x00\x00\x00\x00", "r8" },
    { 12, "\x10\x04\x00\x00\xF1\xC3\xB6\x8A\x21\x03\x03\x20", "sbz" },
    { 12, "\x0D\x0A\x24\x56\x65\x72\x73\x69\x6F\x6E\x3A\x20", "tgf" },
    { 12, "\x0B\x50\x59\x53\x4F\x46\x54\x2E\x43\x4F\x4D\x20", "awlive" },
    { 12, "\x0B\x00\x50\x45\x57\x20\x46\x69\x6C\x65\x20\x76", "pex" },
    { 12, "\x07\x00\x00\x00\x54\x53\x33\x50\x61\x63\x6B\x01", "sims3pack" },
    { 12, "\x04\x00\x00\x00\x50\x72\x65\x79\x72\x00\x00\x00", "save" },
    { 12, "\x02\x00\x00\x00\x00\x00\x00\x00\x53\x61\x74\x48", "sat" },
    { 12, "\x01\x01\x47\x19\xA4\x00\x00\x00\x00\x00\x00\x00", "tbi" },
    { 12, "\x00\xAB\xCD\xE0\x00\x00\x00\x03\x00\x00\x00\x40", "vlm" },
    { 12, "\x00\x58\x44\x52\x41\x5A\x4C\x41\x43\x45\x21\x20", "drl" },
    { 12, "\x00\x4E\x4F\x52\x54\x4F\x4E\x20\x56\x65\x72\x20", "001" },
    { 12, "\x00\x00\x53\x51\x55\x41\x52\x45\x53\x4F\x46\x54", "lgp" },
    { 12, "\x00\x00\x1A\x00\x02\x10\x04\x00\x00\x00\x00\x00", "wk4" },
    { 12, "\x00\x00\x1A\x00\x00\x10\x04\x00\x00\x00\x00\x00", "wk3" },
    { 11, "\xFF\xFF\x7F\x80\xA0\x80\x80\x01\x01\x81\x01", "ddif" },
    { 11, "\xAB\x4A\x53\x52\x31\x38\x34\xBB\x0D\x0A\x1A", "m3g" },
    { 11, "\x73\x74\x61\x72\x74\x73\x68\x61\x70\x65\x20", "cfdg" },
    { 11, "\x73\x68\x69\x70\x73\x65\x63\x74\x69\x6F\x6E", "shipsection" },
    { 11, "\x64\x38\x3A\x61\x6E\x6E\x6F\x75\x6E\x63\x65", "torrent" },
    { 11, "\x63\x75\x73\x68\x00\x00\x00\x02\x00\x00\x00", "csh" },
    { 11, "\x61\x6A\x6D\x5F\x57\x45\x41\x5F\x76\x65\x72", "wea" },
    { 11, "\x5F\x43\x4C\x49\x43\x4B\x46\x4F\x52\x4D\x53", "clk" },
    { 11, "\x5C\x62\x65\x67\x69\x6E\x64\x61\x74\x61\x7B", "cmu" },
    { 11, "\x5B\x61\x75\x74\x6F\x72\x75\x6E\x5D\x0D\x0A", "inf" },
    { 11, "\x5B\x0D\x0A\x56\x65\x72\x73\x69\x6F\x6E\x3D", "smw" },
    { 11, "\x57\x45\x41\x50\x4F\x4E\x46\x49\x4C\x45\x5C", "" },
    { 11, "\x56\x45\x52\x53\x49\x4F\x4E\x20\x31\x2E\x30", "par" },
    { 11, "\x54\x33\x2D\x69\x6D\x61\x67\x65\x0D\x0A\x1A", "t3" },
    { 11, "\x53\x74\x6F\x63\x6B\x43\x68\x61\x72\x74\x58", "stx" },
    { 11, "\x53\x63\x66\x56\x65\x72\x73\x69\x6F\x6E\x20", "scf" },
    { 11, "\x4E\x45\x4F\x20\x43\x6F\x6E\x74\x65\x6E\x74", "nwp" },
    { 11, "\x4D\x61\x73\x74\x65\x72\x43\x6F\x6F\x6B\x20", "mcf" },
    { 11, "\x4D\x54\x68\x64\x00\x00\x00\x06\x00\x01\x00", "mid" },
    { 11, "\x4D\x49\x47\x2E\x30\x30\x2E\x31\x50\x53\x50", "gim" },
    { 11, "\x4D\x41\x58\x46\x49\x4C\x45\x20\x43\x33\x20", "c3" },
    { 11, "\x48\x5A\x46\x2E\x46\x4F\x52\x4D\x41\x54\x2E", "hzf" },
    { 11, "\x47\x65\x6F\x6D\x20\x54\x69\x74\x6C\x65\x3D", "g99" },
    { 11, "\x47\x65\x6E\x73\x20\x4D\x6F\x76\x69\x65\x20", "gmv" },
    { 11, "\x46\x6C\x6F\x77\x20\x54\x69\x74\x6C\x65\x3D", "f99" },
    { 11, "\x46\x4F\x33\x53\x41\x56\x45\x47\x41\x4D\x45", "fos" },
    { 11, "\x46\x4C\x41\x52\x45\x54\x45\x58\x54\x0D\x0A", "wix" },
    { 11, "\x45\x4E\x44\x4E\x45\x4E\x5A\x33\x00\x00\x00", "enz" },
    { 11, "\x44\x56\x44\x46\x61\x62\x33\x20\x43\x47\x50", "cgp" },
    { 11, "\x43\x6C\x61\x6D\x41\x56\x2D\x56\x44\x42\x3A", "cvd" },
    { 11, "\x43\x68\x65\x73\x73\x6D\x61\x73\x74\x65\x72", "cmg" },
    { 11, "\x43\x55\x42\x45\x4D\x41\x53\x34\x2E\x31\x30", "mas" },
    { 11, "\x43\x48\x45\x41\x54\x45\x4E\x47\x49\x4E\x45", "ct" },
    { 11, "\x43\x41\x44\x43\x2F\x4B\x52\x20\x52\x53\x54", "hrf" },
    { 11, "\x43\x23\x2B\x44\xA4\x43\x4D\xA5\x48\x64\x72", "rtd" },
    { 11, "\x42\x48\x05\x07\x30\x00\x25\x00\x00\x01\x01", "tkc" },
    { 11, "\x41\x55\x53\x52\x45\x50\x2F\x53\x50\x2F\x2F", "" },
    { 11, "\x41\x55\x53\x52\x45\x50\x2F\x50\x52\x2F\x2F", "" },
    { 11, "\x41\x55\x53\x52\x45\x50\x2F\x46\x52\x2F\x2F", "" },
    { 11, "\x41\x55\x53\x52\x45\x50\x2F\x44\x52\x2F\x2F", "" },
    { 11, "\x41\x55\x4B\x32\x30\x30\x30\x2E\x43\x4D\x50", "cmp" },
    { 11, "\x3C\x74\x65\x72\x72\x61\x67\x65\x6E\x0D\x0A", "tgd" },
    { 11, "\x3C\x54\x72\x49\x44\x20\x76\x65\x72\x3D\x22", "xml" },
    { 11, "\x3C\x4D\x61\x6B\x65\x72\x46\x69\x6C\x65\x20", "fm" },
    { 11, "\x35\x30\x30\x00\x35\x30\x30\x00\x50\x41\x46", "paf" },
    { 11, "\x2A\x50\x50\x44\x2D\x41\x64\x6F\x62\x65\x3A", "ppd" },
    { 11, "\x25\x21\x50\x53\x2D\x41\x64\x6F\x62\x65\x2D", "eps" },
    { 11, "\x23\x49\x6E\x76\x65\x6E\x74\x6F\x72\x20\x56", "iv" },
    { 11, "\x23\x3F\x52\x41\x44\x49\x41\x4E\x43\x45\x0A", "hdr" },
    { 11, "\x1F\x8B\x08\x00\x00\x00\x00\x00\x00\x0B\xEC", "sav" },
    { 11, "\x1E\x8C\x08\x00\x00\x00\x00\x00\x00\x0B\xEC", "c4*" },
    { 11, "\x0D\x0A\x45\x70\x73\x20\x46\x69\x6C\x65\x3A", "efe" },
    { 11, "\x0A\x4C\x63\x66\x4D\x61\x70\x55\x6E\x69\x74", "lmu" },
    { 11, "\x06\x09\x3C\x45\x50\x41\x4E\x45\x54\x32\x3E", "net" },
    { 11, "\x00\x00\x03\xF3\x00\x00\x00\x00\x00\x00\x00", "" },
    { 10, "\xFF\x02\x47\x66\x61\x42\x41\x53\x49\x43", "gfa" },
    { 10, "\xFF\x00\x02\x00\x04\x04\x05\x54\x02\x00", "wks" },
    { 10, "\xAD\xBE\x00\x00\x05\x00\x00\x00\x31\x2E", "dat" },
    { 10, "\xA1\xA0\xAE\xAB\xBC\xA8\xAA\xA8\xA0\xA8", "urf" },
    { 10, "\x90\x30\x3B\x30\x3B\x38\x71\x22\x31\x3B", "six" },
    { 10, "\x79\xA6\x00\x00\x49\x49\x49\x49\x38\x00", "pds" },
    { 10, "\x76\x65\x72\x73\x69\x6F\x6E\x20\x3D\x20", "phn" },
    { 10, "\x74\x65\x6D\x70\x6C\x61\x74\x65\x20\x22", "txt" },
    { 10, "\x65\x79\x65\x6D\x61\x69\x6C\x76\x69\x64", "eye" },
    { 10, "\x64\x6D\x72\x31\x64\x61\x74\x61\xF4\x01", "sc4" },
    { 10, "\x61\x5C\x04\x05\x14\x41\x00\x00\xFD\x00", "hki" },
    { 10, "\x5E\x40\x5C\x6E\x53\x4D\x4A\x50\x45\x47", "mjpg" },
    { 10, "\x5C\x00\x00\x00\xDD\x5A\x01\xD4\x78\x56", "zmf" },
    { 10, "\x5B\x70\x6C\x61\x79\x6C\x69\x73\x74\x5D", "pls" },
    { 10, "\x5B\x66\x6C\x74\x73\x69\x6D\x2E\x30\x5D", "cfg" },
    { 10, "\x5B\x50\x69\x63\x61\x73\x61\x5D\x0D\x0A", "ini" },
    { 10, "\x5B\x4D\x41\x43\x52\x4F\x43\x41\x44\x20", "fcm" },
    { 10, "\x5B\x47\x72\x6F\x75\x70\x73\x5D\x0D\x0A", "grid" },
    { 10, "\x57\x56\x02\x00\x47\x45\x00\x0E\x00\x00", "lwf" },
    { 10, "\x57\x4F\x52\x4C\x44\x5F\x56\x31\x2E\x30", "swd" },
    { 10, "\x56\x49\x53\x50\x49\x45\x43\x45\x53\x20", "pmg" },
    { 10, "\x55\x52\x4C\x33\x3A\x76\x65\x72\x33\x3A", "rfn" },
    { 10, "\x55\x45\x46\x20\x46\x69\x6C\x65\x21\x00", "uef" },
    { 10, "\x54\x79\x70\x65\x3D\x45\x78\x65\x0D\x0A", "vbp" },
    { 10, "\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x20", "tfm" },
    { 10, "\x54\x46\x4D\x58\x2D\x53\x4F\x4E\x47\x20", "" },
    { 10, "\x53\x79\x6D\x42\x61\x6B\x55\x70\x20\x20", "fbf" },
    { 10, "\x53\x54\x41\x52\x54\x46\x4F\x4E\x54\x20", "bdf" },
    { 10, "\x53\x4D\x41\x52\x54\x44\x52\x57\x01\x80", "sdr" },
    { 10, "\x53\x49\x4D\x50\x4C\x45\x20\x20\x3D\x20", "arf" },
    { 10, "\x53\x41\x47\x45\x42\x41\x43\x4B\x55\x50", "999" },
    { 10, "\x52\x4A\x50\x31\x53\x4D\x4F\x44\x00\x00", "rjp" },
    { 10, "\x50\x4B\x03\x04\x14\x00\x09\x00\x08\x00", "pms" },
    { 10, "\x50\x4B\x03\x04\x0A\x00\x01\x00\x08\x00", "imz" },
    { 10, "\x50\x4B\x03\x04\x0A\x00\x00\x00\x08\x00", "imz" },
    { 10, "\x50\x4B\x03\x04\x0A\x00\x00\x00\x00\x00", "cryptomite" },
    { 10, "\x4F\x76\x61\x74\x69\x6F\x6E\x50\x72\x6F", "dpd" },
    { 10, "\x4E\x4F\x4C\x00\x01\x00\x06\x01\x03\x00", "nol" },
    { 10, "\x4E\x41\x56\x54\x52\x41\x46\x46\x49\x43", "dat" },
    { 10, "\x4D\x4F\x4F\x56\x45\x5F\x50\x41\x43\x4B", "mpz" },
    { 10, "\x4B\x57\x41\x4A\x88\xF0\x27\xD1\x03\x00", "??_" },
    { 10, "\x4B\x52\x45\x54\x5A\x46\x49\x4C\x45\x20", "v00" },
    { 10, "\x4B\x47\x42\x5F\x61\x72\x63\x68\x20\x2D", "kgb" },
    { 10, "\x49\x4E\x50\x55\x54\x3D\x32\x35\x36\x7E", "smol" },
    { 10, "\x49\x49\x2A\x00\x10\x00\x00\x00\x43\x52", "cr2" },
    { 10, "\x46\x7A\x7A\x58\x00\x04\x57\x6D\x33\x44", "wm3" },
    { 10, "\x46\x61\x62\x6C\x65\x53\x61\x76\x65\x21", "" },
    { 10, "\x46\x33\x57\x50\x54\x2D\x2D\x2E\x2D\x2D", "wpt" },
    { 10, "\x45\x75\x72\x65\x6B\x61\x4C\x6F\x67\x20", "elf" },
    { 10, "\x45\x6D\x69\x6C\x63\x6F\x6E\x74\x20\x2D", "" },
    { 10, "\x44\x52\x03\x04\x14\x00\x0B\x00\x08\x00", "dro" },
    { 10, "\x44\x43\x33\x4C\x56\x4C\x47\x52\x02\x00", "dc3" },
    { 10, "\x43\x4F\x53\x4F\x00\x00\x00\x40\x00\x00", "hipc" },
    { 10, "\x43\x41\x4C\x41\x4D\x55\x53\x43\x56\x47", "cvg" },
    { 10, "\x43\x41\x4C\x41\x4D\x55\x53\x43\x46\x4E", "cfn" },
    { 10, "\x42\x45\x47\x49\x4E\x3A\x56\x4D\x53\x47", "vmg" },
    { 10, "\x41\x63\x74\x69\x76\x65\x4D\x69\x6D\x65", "mso" },
    { 10, "\x41\x56\x47\x5F\x56\x41\x55\x4C\x54\xCD", "fil" },
    { 10, "\x40\x64\x61\x74\x61\x62\x61\x73\x65\x20", "guide" },
    { 10, "\x3C\x70\x6C\x61\x6E\x64\x61\x74\x61\x20", "bpd" },
    { 10, "\x3C\x44\x6F\x63\x75\x6D\x65\x6E\x74\x3E", "cmbl" },
    { 10, "\x3C\x42\x6F\x6F\x6B\x46\x69\x6C\x65\x20", "book" },
    { 10, "\x3C\x21\x44\x4F\x43\x54\x59\x50\x45\x20", "sgml" },
    { 10, "\x33\x2E\x30\x2E\x32\x2E\x39\x32\x36\x0A", "elm" },
    { 10, "\x2F\x2A\x20\x58\x50\x4D\x20\x2A\x2F\x0A", "xpm" },
    { 10, "\x2E\x4C\x61\x6E\x67\x75\x61\x67\x65\x3D", "hlf" },
    { 10, "\x28\x44\x45\x4C\x41\x59\x46\x49\x4C\x45", "sdf" },
    { 10, "\x24\x56\x65\x72\x73\x69\x6F\x6E\x3A\x20", "tgf" },
    { 10, "\x23\x56\x61\x72\x69\x61\x62\x6C\x65\x73", "trf" },
    { 10, "\x23\x43\x41\x44\x32\x44\x4D\x43\x0D\x0A", "qli" },
    { 10, "\x1F\x8B\x08\x00\x00\x00\x00\x00\x00\x0B", "" },
    { 10, "\x0D\x43\x41\x44\x53\x20\x44\x52\x57\x20", "drw" },
    { 10, "\x0C\x49\x6E\x74\x65\x72\x6C\x65\x78\x20", "ilx" },
    { 10, "\x06\x00\x00\x00\x47\x4D\x6F\x76\x69\x65", "sqf" },
    { 10, "\x01\x41\x54\x41\x52\x49\x37\x38\x30\x30", "a78" },
    { 10, "\x00\x02\x47\x66\x61\x42\x41\x53\x49\x43", "gfa" },
    { 10, "\x00\x02\x42\x4F\x4F\x4B\x44\x4F\x55\x47", "imp" },
    { 10, "\x00\x00\x01\x40\x00\x00\x00\x03\x00\x00", "swa" },
    { 10, "\x00\x00\x00\x0C\x6A\x50\x20\x20\x0D\x0A", "jp2" },
    { 10, "\x00\x00\x00\x01\x42\x75\x64\x31\x00\x00", "ds_store" },
    //{  9, "\xD0\xCF\x11\xE0\xA1\xB1\x1A\xE1\x00", "adp" },
    {  9, "\xCB\x54\x53\x43\x53\x4E\x41\x47\x4E", "snag" },
    {  9, "\x89\x9B\x9A\xDE\x23\x01\x00\x00\x08", "umd" },
    {  9, "\x82\x01\x00\x20\x00\x00\x00\x20\x00", "fca" },
    {  9, "\x7B\x56\x65\x72\x73\x69\x6F\x6E\x3A", "fwk" },
    {  9, "\x7B\x56\x45\x52\x53\x49\x4F\x4E\x20", "mws" },
    {  9, "\x77\x65\x61\x70\x6F\x6E\x44\x65\x66", "weap" },
    {  9, "\x75\x54\x31\x01\x01\x80\x00\x00\x00", "nyf" },
    {  9, "\x73\x72\x63\x64\x6F\x63\x69\x64\x3A", "cals" },
    {  9, "\x6F\xE6\x06\x00\x58\x45\x42\x50\x00", "xeb" },
    {  9, "\x68\x64\x66\x6D\x00\x00\x00\x84\x00", "itl" },
    {  9, "\x67\x69\x6D\x70\x20\x78\x63\x66\x20", "xcf" },
    {  9, "\x66\x69\x6C\x65\x6E\x61\x6D\x65\x3D", "crc" },
    {  9, "\x62\x69\x6E\x74\x65\x72\x72\x31\x2E", "bt" },
    {  9, "\x61\x72\x63\x68\x65\x74\x79\x70\x65", "adl" },
    {  9, "\x5B\x76\x65\x72\x73\x69\x6F\x6E\x5D", "wjf" },
    {  9, "\x5B\x53\x68\x65\x6C\x6C\x5D\x0D\x0A", "scf" },
    {  9, "\x5B\x53\x65\x74\x75\x70\x5D\x0D\x0A", "iss" },
    {  9, "\x5B\x50\x72\x6F\x6A\x65\x63\x74\x5D", "dev" },
    {  9, "\x5B\x50\x72\x6F\x66\x69\x6C\x65\x5D", "wgp" },
    {  9, "\x5B\x50\x61\x63\x6B\x61\x67\x65\x5D", "mjp" },
    {  9, "\x5B\x49\x6E\x73\x74\x61\x6C\x6C\x53", "iss" },
    {  9, "\x5B\x46\x49\x44\x4F\x4C\x49\x42\x20", "fcl" },
    {  9, "\x5A\x58\x54\x61\x70\x65\x21\x1A\x01", "tzx" },
    {  9, "\x5A\x58\x41\x75\x64\x69\x6F\x21\x1A", "azx" },
    {  9, "\x56\x69\x6D\x43\x72\x79\x70\x74\x7E", "" },
    {  9, "\x56\x49\x53\x49\x2D\x43\x41\x44\x20", "wkf" },
    {  9, "\x56\x35\x5F\x43\x46\x56\x32\x00\x00", "catpart" },
    {  9, "\x54\x52\x41\x43\x4B\x4A\x4F\x59\x01", "joy" },
    {  9, "\x54\x52\x41\x43\x4B\x4A\x4F\x59\x00", "tjs" },
    {  9, "\x54\x4D\x53\x63\x72\x69\x70\x74\x20", "tms" },
    {  9, "\x54\x44\x49\x50\x4C\x4F\x4F\x4D\x01", "tex" },
    {  9, "\x53\x75\x70\x65\x72\x43\x61\x6C\x63", "cal" },
    {  9, "\x53\x6F\x66\x74\x53\x45\x41\x4C\x20", "" },
    {  9, "\x53\x5A\x44\x44\x88\xF0\x27\x33\x41", "ex_" },
    {  9, "\x53\x56\x46\x20\x76\x31\x2E\x31\x30", "svf" },
    {  9, "\x53\x44\x50\x58\x00\x00\x20\x00\x56", "dpx" },
    {  9, "\x52\x65\x73\x63\x6F\x52\x36\x34\x20", "rxf" },
    {  9, "\x52\x4F\x53\x2E\x36\x30\x30\x35\x30", "fmb" },
    {  9, "\x50\x61\x72\x61\x64\x6F\x78\x20\x22", "sor" },
    {  9, "\x50\x54\x52\x45\x53\x46\x49\x4C\x45", "pt" },
    {  9, "\x50\x43\x53\x74\x69\x74\x63\x68\x20", "pat" },
    {  9, "\x4E\x43\x4D\x4F\x42\x4A\x45\x43\x54", "mio" },
    {  9, "\x4D\x54\x68\x64\x00\x00\x00\x06\x00", "mid" },
    {  9, "\x4D\x4D\x00\x2A\x00\x00\x00\x08\x00", "nef" },
    {  9, "\x4D\x42\x52\x74\x6F\x6F\x6C\x0D\x0A", "" },
    {  9, "\x4C\x69\x63\x6B\x00\x00\x00\x02\x00", "lqt" },
    {  9, "\x4C\x4F\x43\x41\x54\x49\x4F\x4E\x2C", "epw" },
    {  9, "\x4A\x47\x43\x46\x00\x00\x00\x20\x01", "gcf" },
    {  9, "\x4A\x41\x53\x43\x2D\x50\x41\x4C\x0D", "pal" },
    {  9, "\x4A\x41\x50\x41\x4E\x02\xFF\xFF\xFF", "jcc" },
    {  9, "\x49\x46\x46\x20\x46\x49\x4C\x45\x20", "iff" },
    {  9, "\x48\x49\x45\x52\x41\x52\x43\x48\x59", "bvh" },
    {  9, "\x47\x6C\x6F\x62\x61\x6C\x0D\x0A\x09", "kml" },
    {  9, "\x46\x6F\x72\x6D\x46\x6C\x6F\x77\x20", "frl" },
    {  9, "\x46\x6F\x72\x6D\x45\x64\x69\x6B\x20", "fed" },
    {  9, "\x45\x78\x74\x65\x6E\x64\x65\x64\x20", "xm" },
    {  9, "\x45\x47\x33\x32\x50\x52\x4F\x5F\x32", "cgf" },
    {  9, "\x44\x31\x2E\x30\x0D\x0A\x00\x00\x00", "spd" },
    {  9, "\x43\x6F\x6E\x74\x72\x6F\x6C\x3A\x20", "control" },
    {  9, "\x43\x4F\x4E\x54\x45\x4E\x54\x53\x20", "xtp" },
    {  9, "\x43\x41\x4B\x45\x57\x41\x4C\x4B\x1A", "wrk" },
    {  9, "\x43\x36\x34\x49\x6D\x61\x67\x65\x00", "c64" },
    {  9, "\x42\x49\x58\x30\xC1\xB8\x03\x9A\xF1", "bix" },
    {  9, "\x42\x49\x54\x20\x20\x46\x41\x58\x30", "bfx" },
    {  9, "\x41\x58\x54\x5F\x46\x49\x4C\x45\x20", "axt" },
    {  9, "\x41\x4D\x43\x11\x08\x19\x77\x06\x7E", "nvc" },
    {  9, "\x41\x46\x46\x00\x41\x47\x45\x4D\x41", "aff" },
    {  9, "\x41\x43\x54\x52\x48\x45\x41\x44\x00", "psk" },
    {  9, "\x41\x43\x52\x53\xBE\xBC\xAD\xAC\x16", "a4p" },
    {  9, "\x41\x20\x4A\x20\x50\x20\x31\x20\x34", "ajp" },
    {  9, "\x3C\x70\x73\x69\x74\x72\x65\x65\x3E", "conf" },
    {  9, "\x3C\x4D\x49\x46\x46\x69\x6C\x65\x20", "mif" },
    {  9, "\x38\x42\x50\x54\x00\x01\x00\x00\x00", "pat" },
    {  9, "\x36\x43\x34\x44\x4C\x41\x59\x36\x01", "l4d" },
    {  9, "\x33\x44\x6F\x6B\x75\x47\x61\x6D\x65", "3doku" },
    {  9, "\x2E\x52\x4D\x46\x00\x00\x00\x12\x00", "rm" },
    {  9, "\x2A\x76\x65\x72\x73\x69\x6F\x6E\x20", "sch" },
    {  9, "\x23\x45\x58\x54\x4D\x33\x55\x0D\x0A", "m3u" },
    {  9, "\x23\x23\x53\x6B\x65\x74\x63\x68\x20", "sk" },
    {  9, "\x23\x20\x42\x6C\x65\x6E\x64\x65\x72", "obj" },
    {  9, "\x21\x21\x38\x2D\x42\x69\x74\x21\x21", "tcr" },
    {  9, "\x20\x4D\x55\x47\x49\x43\x49\x41\x4E", "dmu" },
    {  9, "\x1A\x45\x56\x4F\x4E\x4C\x49\x4E\x45", "eot" },
    {  9, "\x10\x01\x4D\x50\x4C\x45\x31\x3C\x3C", "ple" },
    {  9, "\x0F\x53\x49\x42\x45\x4C\x49\x55\x53", "sib" },
    {  9, "\x0D\x4E\x65\x72\x6F\x43\x44\x41\x56", "nra" },
    {  9, "\x0C\x01\x00\x00\x00\x01\x00\x00\x00", "mps" },
    {  9, "\x05\x00\x00\x00\x01\x00\x01\x00\x00", "nrv" },
    {  9, "\x01\x00\x00\x00\x00\x80\x00\x00\x00", "fcd" },
    {  9, "\x00\x54\x4D\x53\x41\x4D\x56\x4F\x48", "" },
    {  9, "\x00\x04\x00\x00\x00\x00\x00\x00\x00", "cdx" },
    {  9, "\x00\x01\x00\x08\x00\x01\x00\x01\x01", "img" },
    {  9, "\x00\x00\x00\x50\x71\x74\x63\x68\x00", "qtch" },
    {  8, "\xFF\x57\x50\x43\x10\x00\x00\x00", "wpg" },
    {  8, "\xFC\x08\x01\x00\x0E\x00\xA8\x01", "frm" },
    {  8, "\xF9\x6D\x4A\x16\x6F\xC5\x78\xEE", "fbl" },
    {  8, "\xE3\x10\x00\x01\x00\x00\x00\x00", "info" },
    {  8, "\xD3\x23\x00\x00\x03\x00\x00\x00", "wlm" },
    {  8, "\xC8\x00\x00\x00\x00\x00\x00\x00", "caj" },
    {  8, "\xB5\xA2\xB0\xB3\xB3\xB0\xA2\xB5", "cal" },
    {  8, "\xAB\x01\x01\x03\x02\x00\x00\x00", "vif" },
    {  8, "\xA2\x4B\x65\x79\x47\x0A\x0D\x0A", "fcp" },
    {  8, "\x91\xD5\x12\x00\x58\x02\x00\x00", "gm6" },
    {  8, "\x91\x89\x98\x19\x44\x00\x00\x00", "abd" },
    {  8, "\x89\x4C\x5A\x4F\x00\x0D\x0A\x1A", "lzo" },
    {  8, "\x76\x65\x72\x73\x69\x6F\x6E\x3D", "sqm" },
    {  8, "\x76\x65\x72\x73\x69\x6F\x6E\x20", "pdo" },
    {  8, "\x71\x75\x69\x63\x6B\x33\x44\x6F", "q3o" },
    {  8, "\x71\x70\x72\x65\x73\x73\x31\x30", "qp03" },
    {  8, "\x70\x72\x6F\x67\x72\x61\x6D\x20", "dpr" },
    {  8, "\x70\x61\x63\x6B\x61\x67\x65\x20", "rrh" },
    {  8, "\x6D\x68\x77\x61\x6E\x68\x00\x04", "raw" },
    {  8, "\x6B\x4A\x1F\x10\x00\x00\x00\x00", "rsc" },
    {  8, "\x68\x65\x61\x64\x65\x72\x20\x7B", "an8" },
    {  8, "\x67\x72\x61\x70\x68\x3A\x20\x7B", "vcg" },
    {  8, "\x64\x65\x78\x0A\x30\x30\x39\x00", "dex" },
    {  8, "\x64\x00\x00\x00\x00\x02\x00\x00", "rxf" },
    {  8, "\x63\x6F\x6E\x65\x63\x74\x69\x78", "vhd" },
    {  8, "\x63\x61\x70\x33\x2D\x76\x3A\x61", "cap" },
    {  8, "\x63\x61\x70\x33\x2D\x63\x61\x67", "cag" },
    {  8, "\x62\x70\x6C\x69\x73\x74\x30\x30", "" },
    {  8, "\x61\x77\x6D\x33\x30\x30\x0D\x0A", "awm" },
    {  8, "\x61\x77\x6D\x32\x30\x30\x0D\x0A", "awm" },
    {  8, "\x5F\x4F\x74\x73\x4D\x58\x21\x5F", "omx" },
    {  8, "\x5F\x45\x47\x41\x54\x48\x45\x52", "eg2" },
    {  8, "\x5F\x41\x52\x43\x48\x49\x56\x45", "sga" },
    {  8, "\x5B\x56\x4E\x55\x4D\x3D\x31\x2E", "v3o" },
    {  8, "\x5B\x46\x49\x44\x4F\x43\x41\x44", "fcd" },
    {  8, "\x5B\x45\x76\x65\x6E\x74\x20\x22", "pgn" },
    {  8, "\x5A\x58\x41\x59\x45\x4D\x55\x4C", "ay" },
    {  8, "\x58\x49\x50\x5F\x31\x2E\x30\x3B", "xip" },
    {  8, "\x58\x41\x52\x41\xA3\xA3\x0D\x0A", "web" },
    {  8, "\x57\x69\x6E\x47\x65\x6E\x65\x61", "wdf" },
    {  8, "\x57\x57\x42\x42\x31\x31\x31\x31", "wb1" },
    {  8, "\x57\x4E\x47\x5A\x57\x5A\x53\x43", "scz" },
    {  8, "\x57\x4D\x41\x50\x56\x31\x2E\x30", "wmp" },
    {  8, "\x57\x43\x52\x53\xA8\xBC\xAD\xAC", "a3w" },
    {  8, "\x56\x65\x72\x73\x69\x6F\x6E\x20", "bkr" },
    {  8, "\x56\x56\x43\x20\x56\x31\x2E\x30", "vvc" },
    {  8, "\x56\x54\x46\x00\x07\x00\x00\x00", "vtf" },
    {  8, "\x56\x4E\x4D\x45\x42\x4F\x4F\x4B", "meb" },
    {  8, "\x56\x45\x52\x53\x49\x4F\x4E\x28", "bwe" },
    {  8, "\x56\x45\x52\x53\x49\x4F\x4E\x20", "ctl" },
    {  8, "\x56\x45\x4E\x54\x52\x45\x43\x44", "vrf" },
    {  8, "\x56\x42\x53\x50\x13\x00\x00\x00", "bsp" },
    {  8, "\x56\x42\x4C\x00\x01\x00\x00\x00", "vbl" },
    {  8, "\x56\x35\x5F\x43\x46\x56\x32\x00", "catdrawing" },
    {  8, "\x55\x46\x4F\x4F\x72\x62\x69\x74", "dat" },
    {  8, "\x55\x44\x53\x2D\x31\x39\x39\x32", "uds" },
    {  8, "\x54\x68\x69\x73\x20\x69\x73\x20", "info" },
    {  8, "\x54\x49\x44\x58\x30\x31\x30\x30", "tid" },
    {  8, "\x54\x45\x52\x52\x41\x47\x45\x4E", "atm" },
    {  8, "\x54\x42\x56\x6F\x6C\x75\x6D\x65", "tbv" },
    {  8, "\x54\x42\x4D\x20\x30\x30\x32\x20", "tbm" },
    {  8, "\x54\x42\x41\x20\x30\x32\x30\x20", "tba" },
    {  8, "\x53\x80\xF6\x34\x40\x20\x00\x00", "pic" },
    {  8, "\x53\x79\x6D\x56\x69\x64\x31\x30", "vid" },
    {  8, "\x53\x74\x75\x66\x66\x49\x74\x21", "sitx" },
    {  8, "\x53\x63\x72\x61\x74\x63\x68\x56", "sb" },
    {  8, "\x53\x59\x4D\x50\x41\x54\x43\x48", "" },
    {  8, "\x53\x50\x52\x57\x6F\x72\x6C\x64", "tmd" },
    {  8, "\x53\x50\x4C\x20\x56\x31\x20\x20", "spl" },
    {  8, "\x53\x4D\x32\x4D\x50\x58\x31\x30", "" },
    {  8, "\x53\x49\x4E\x43\x4C\x41\x49\x52", "scl" },
    {  8, "\x53\x49\x47\x4E\x50\x4C\x4F\x54", "sp" },
    {  8, "\x53\x46\x44\x58\x03\x00\x00\x00", "dfs" },
    {  8, "\x53\x44\x4F\x20\x30\x30\x34\x20", "sdo" },
    {  8, "\x52\x53\x56\x4B\x44\x41\x54\x41", "" },
    {  8, "\x52\x45\x56\x4F\x32\x37\x30\x30", "rev" },
    {  8, "\x52\x45\x56\x4E\x55\x4D\x3A\x2C", "adf" },
    {  8, "\x52\x45\x47\x45\x44\x49\x54\x34", "reg" },
    {  8, "\x52\x41\x5A\x41\x54\x44\x42\x31", "dat" },
    {  8, "\x51\x57\x20\x56\x65\x72\x2E\x20", "qsd" },
    {  8, "\x51\x4C\x49\x54\x01\x00\x00\x00", "lit" },
    {  8, "\x51\x4C\x49\x49\x46\x41\x58\x00", "qfx" },
    {  8, "\x50\x6C\x6F\x54\x54\x64\x6F\x63", "tp" },
    {  8, "\x50\x53\x54\x52\x45\x41\x4D\x00", "psf" },
    {  8, "\x50\x53\x4D\x46\x30\x30\x31\x34", "pmf" },
    {  8, "\x50\x53\x2D\x58\x20\x45\x58\x45", "dll" },
    {  8, "\x50\x4F\x46\x00\x00\x00\x01\x00", "pof" },
    {  8, "\x50\x4E\x43\x49\x55\x4E\x44\x4F", "dat" },
    {  8, "\x50\x4B\x08\x08\x42\x47\x49\x20", "chr" },
    {  8, "\x50\x4B\x03\x06\x0A\x00\x00\x00", "sof" },
    {  8, "\x50\x47\x50\x64\x4D\x41\x49\x4E", "pgd" },
    {  8, "\x50\x43\x53\x00\x14\x00\x00\x00", "gab" },
    {  8, "\x50\x43\x46\x46\x47\x52\x41\x34", "pzf" },
    {  8, "\x50\x41\x52\x32\x00\x50\x4B\x54", "par2" },
    {  8, "\x50\x41\x47\x45\x44\x55\x4D\x50", "dmp" },
    {  8, "\x50\x41\x47\x45\x44\x55\x36\x34", "dmp" },
    {  8, "\x50\x1B\x53\x54\x44\x50\x53\x50", "ref" },
    {  8, "\x4F\x46\x52\x20\x0F\x00\x00\x00", "ofr" },
    {  8, "\x4F\x43\x43\x20\x30\x30\x35\x20", "occ" },
    {  8, "\x4E\x58\x56\x20\x46\x69\x6C\x65", "nxv" },
    {  8, "\x4E\x49\x53\x54\x5F\x31\x41\x0A", "sph" },
    {  8, "\x4E\x44\x4D\x4F\x03\x00\x00\x00", "ndm" },
    {  8, "\x4D\x56\x00\xFF\x0C\x00\x12\x00", "std" },
    {  8, "\x4D\x56\x00\xFF\x0C\x00\x0E\x00", "tmd" },
    {  8, "\x4D\x53\x5F\x56\x4F\x49\x43\x45", "dvf" },
    {  8, "\x4D\x53\x46\x54\x02\x00\x01\x00", "tlb" },
    {  8, "\x4D\x53\x43\x46\x00\x00\x00\x00", "cab" },
    {  8, "\x4D\x50\x51\x1A\x20\x00\x00\x00", "scm" },
    {  8, "\x4D\x4D\x56\x53\x31\x2E\x30\x00", "mvs" },
    {  8, "\x4D\x45\x00\x00\xBB\x0B\x00\x00", "mex" },
    {  8, "\x4D\x43\x6F\x6D\x70\x72\x48\x44", "chd" },
    {  8, "\x4C\x69\x6E\x67\x56\x6F\x00\x00", "lsd" },
    {  8, "\x4C\x69\x4F\x6E\x48\x65\x41\x64", "" },
    {  8, "\x4C\x61\x79\x6F\x75\x74\x20\x7B", "kdx" },
    {  8, "\x4C\x54\x41\x52\x03\x00\x00\x00", "arch00" },
    {  8, "\x4C\x49\x51\x44\x4C\x48\x32\x4F", "h2o" },
    {  8, "\x4C\x49\x00\x01\x00\x00\x00\x00", "fim" },
    {  8, "\x4C\x45\x58\x41\x52\x45\x4E\x43", "lrs" },
    {  8, "\x4C\x42\x4C\x53\x49\x5A\x45\x3D", "vic" },
    {  8, "\x4B\x61\x54\x6F\x72\x5A\x65\x72", "kat" },
    {  8, "\x4B\x49\x46\x46\x00\x00\x00\x00", "kif" },
    {  8, "\x4A\x44\x4C\x5A\x02\x10\x00\x00", "lzc" },
    {  8, "\x4A\x33\x44\x32\x62\x64\x6C\x34", "bdl" },
    {  8, "\x49\x58\x4C\x20\x30\x30\x32\x20", "ixl" },
    {  8, "\x49\x57\x66\x66\x75\x31\x30\x30", "ff" },
    {  8, "\x49\x54\x4F\x4C\x49\x54\x4C\x53", "ebo" },
    {  8, "\x49\x44\x50\x33\x0F\x00\x00\x00", "md3" },
    {  8, "\x49\x44\x50\x32\x08\x00\x00\x00", "md2" },
    {  8, "\x49\x42\x53\x50\x26\x00\x00\x00", "bsp" },
    {  8, "\x49\x42\x50\x20\x66\x69\x6C\x65", "ibp" },
    {  8, "\x48\x57\x43\x4D\x01\x00\x00\x00", "map" },
    {  8, "\x48\x4D\x49\x4D\x49\x44\x49\x50", "hmp" },
    {  8, "\x48\x46\x58\x5A\x48\x46\x58\x5A", "hfz" },
    {  8, "\x48\x44\x4D\x56\x30\x32\x30\x30", "clpi" },
    {  8, "\x48\x44\x4D\x56\x30\x31\x30\x30", "cpi" },
    {  8, "\x48\x41\x53\x48\x0D\x0A\xFF\x00", "hash" },
    {  8, "\x47\x4E\x54\x4D\x07\x00\x00\x00", "ntm" },
    {  8, "\x47\x4C\x55\x45\xB8\xB3\xAA\xBA", "glue" },
    {  8, "\x47\x46\x31\x50\x41\x54\x43\x48", "pat" },
    {  8, "\x47\x45\x4E\x4F\x4D\x46\x4C\x45", "" },
    {  8, "\x47\x44\x42\x20\x53\x74\x65\x70", "st*" },
    {  8, "\x47\x42\x4F\x58\x52\x4F\x50\x54", "gro" },
    {  8, "\x47\x42\x4F\x58\x44\x49\x43\x54", "gdt" },
    {  8, "\x47\x42\x4F\x58\x43\x4F\x50\x54", "gco" },
    {  8, "\x46\x61\x73\x64\x55\x41\x53\x20", "scpt" },
    {  8, "\x46\x55\x47\x54\x52\x4B\xFF\xFF", "trk" },
    {  8, "\x46\x55\x2D\x4D\x50\x41\x41\x21", "fup" },
    {  8, "\x46\x4F\x52\x4D\x44\x53\x31\x36", "nsp" },
    {  8, "\x46\x47\x03\x04\x17\x00\x00\x00", "maki" },
    {  8, "\x46\x45\x41\x54\x55\x52\x45\x53", "gcg" },
    {  8, "\x46\x41\x52\x21\x62\x79\x41\x5A", "far" },
    {  8, "\x46\x41\x4E\x55\x43\x52\x4F\x4D", "st1h" },
    {  8, "\x45\x6C\x66\x46\x69\x6C\x65\x00", "evtx" },
    {  8, "\x45\x4D\x53\x49\x88\x00\x00\x00", "sig" },
    {  8, "\x45\x47\x33\x32\x46\x5F\x53\x4E", "snl" },
    {  8, "\x45\x32\x50\x21\x4C\x61\x6E\x63", "e2p" },
    {  8, "\x44\x57\x41\x31\x20\x20\x20\x20", "dwa" },
    {  8, "\x44\x53\x67\x32\x54\x61\x6E\x6B", "ds2res" },
    {  8, "\x44\x42\x53\x20\x30\x30\x39\x20", "dbs" },
    {  8, "\x44\x42\x52\x20\x30\x30\x31\x20", "dbr" },
    {  8, "\x44\x42\x4F\x20\x30\x31\x32\x20", "dbo" },
    {  8, "\x44\x41\x46\x00\x4C\x49\x53\x54", "sgf" },
    {  8, "\x44\x41\x41\x00\x00\x00\x00\x00", "daa" },
    {  8, "\x43\xAB\x91\x67\x98\x00\x00\x00", "wbz" },
    {  8, "\x43\x6F\x6E\x66\x69\x67\x20\x7B", "blt" },
    {  8, "\x43\x61\xC9\x43\x62\xCD\xBD\x3F", "btd" },
    {  8, "\x43\x52\x59\x4F\x5F\x41\x50\x43", "apc" },
    {  8, "\x43\x52\x45\x20\x56\x31\x2E\x32", "cre" },
    {  8, "\x43\x52\x45\x20\x56\x31\x2E\x30", "cre" },
    {  8, "\x43\x50\x4C\x58\x5F\x54\x50\x33", "tp3" },
    {  8, "\x43\x4F\x4F\x4C\x4E\x45\x53\x53", "ses" },
    {  8, "\x43\x48\x52\x20\x56\x31\x2E\x30", "chr" },
    {  8, "\x43\x48\x4E\x32\x20\x43\x4F\x53", "3mm" },
    {  8, "\x43\x46\x55\x00\x40\x1F\x00\x00", "cbs" },
    {  8, "\x43\x45\x4C\x50\x01\x00\x00\x00", "spc" },
    {  8, "\x43\x33\x44\x46\x30\x39\x34\x30", "co" },
    {  8, "\x42\x61\x67\x70\x69\x70\x65\x20", "bww" },
    {  8, "\x42\x54\x58\x20\x30\x30\x35\x20", "btx" },
    {  8, "\x42\x4C\x45\x4E\x44\x45\x52\x5F", "blend" },
    {  8, "\x42\x4B\x53\x48\x45\x4C\x46\x3D", "bks" },
    {  8, "\x42\x49\x4E\x44\x20\x56\x30\x32", "bnd" },
    {  8, "\x42\x49\x47\x4A\x49\x47\x36\x2E", "jg6" },
    {  8, "\x41\x72\x63\x68\x69\x76\x65\x00", "" },
    {  8, "\x41\x6C\x65\x79\x20\x4D\x6F\x64", "alm" },
    {  8, "\x41\x54\x26\x54\x46\x4F\x52\x4D", "djv" },
    {  8, "\x41\x52\x4D\x6F\x76\x69\x65\x0A", "rpl" },
    {  8, "\x41\x52\x45\x41\x56\x31\x2E\x30", "are" },
    {  8, "\x41\x4F\x54\x20\x46\x49\x4C\x45", "" },
    {  8, "\x41\x4F\x4C\x56\x4D\x31\x30\x30", "pfc" },
    {  8, "\x41\x4F\x4C\x49\x44\x58\x4B\x32", "ind" },
    {  8, "\x41\x4F\x4C\x44\x42\x2D\x32\x35", "aby" },
    {  8, "\x41\x4D\x41\x4E\x44\x41\x3A\x5C", "" },
    {  8, "\x41\x43\x46\x20\x30\x30\x32\x20", "acf" },
    {  8, "\x40\x01\x00\x00\xF0\x00\x00\x00", "cin" },
    {  8, "\x3D\x79\x62\x65\x67\x69\x6E\x20", "" },
    {  8, "\x3C\x61\x69\x61\x66\x66\x3E\x0D", "ar" },
    {  8, "\x3C\x41\x54\x48\x65\x61\x64\x3E", "mrk" },
    {  8, "\x3C\x3C\x3C\x20\x53\x75\x6E\x20", "vdi" },
    {  8, "\x3B\x3B\x20\x48\x53\x46\x20\x56", "easm" },
    {  8, "\x3A\x57\x46\x4D\x50\x52\x45\x3A", "isf" },
    {  8, "\x3A\x56\x45\x52\x53\x49\x4F\x4E", "sle" },
    {  8, "\x32\x49\x44\x53\x00\x02\x00\x00", "sdi" },
    {  8, "\x32\x43\x44\x53\x00\x02\x00\x00", "sdc" },
    {  8, "\x30\x53\x45\x52\x20\x58\x45\x54", "tex" },
    {  8, "\x30\x00\x00\x00\x4C\x66\x4C\x65", "evt" },
    {  8, "\x2D\x72\x6F\x6D\x31\x66\x73\x2D", "" },
    {  8, "\x2A\x50\x53\x42\x05\x00\x00\x00", "xmfg" },
    {  8, "\x2A\x2A\x54\x49\x46\x4C\x2A\x2A", "8xk" },
    {  8, "\x2A\x2A\x54\x49\x39\x32\x2A\x2A", "92i" },
    {  8, "\x27\x1B\x00\x00\x00\x00\x00\x00", "fmx" },
    {  8, "\x25\x31\x42\x4B\x01\x00\x00\x00", "1bk" },
    {  8, "\x24\x52\x44\x46\x49\x4C\x45\x20", "rd" },
    {  8, "\x24\x0D\x0A\x73\x68\x69\x70\x20", "" },
    {  8, "\x24\x08\x19\x92\x23\x00\x15\x01", "bfa" },
    {  8, "\x23\x59\x41\x4F\x44\x4C\x0D\x0A", "ydl" },
    {  8, "\x23\x48\x43\x5A\x32\x23\x0D\x0A", "hcg" },
    {  8, "\x23\x43\x4F\x55\x52\x53\x45\x3A", "crs" },
    {  8, "\x23\x23\x54\x49\x54\x4C\x45\x3D", "jdx" },
    {  8, "\x23\x21\x41\x4D\x52\x2D\x57\x42", "awb" },
    {  8, "\x20\xD8\x3A\xF7\x01\x20\x00\x00", "uez" },
    {  8, "\x20\x6F\x6D\x70\x01\x00\x01\x00", "pme" },
    {  8, "\x1B\x5E\x57\x3B\x30\x3B\x30\x3B", "icr" },
    {  8, "\x1A\x4C\x00\x00\x01\x00\x00\x00", "zdx" },
    {  8, "\x1A\x32\x30\x43\x57\x50\x55\x5A", "gpm" },
    {  8, "\x13\x5D\x65\x8C\x3A\x01\x02\x00", "z" },
    {  8, "\x0E\x4E\x65\x72\x6F\x49\x53\x4F", "nr3" },
    {  8, "\x0E\x00\x01\x00\x25\x00\x00\x00", "rsm" },
    {  8, "\x0D\x34\x44\x35\x33\x33\x33\x33", "trk" },
    {  8, "\x0D\x0A\x1A\x43\x41\x5A\x49\x50", "caz" },
    {  8, "\x0A\x47\x4C\xC3\xE0\x02\x80\x00", "bxy" },
    {  8, "\x08\x4F\x53\x43\x41\x52\x44\x41", "rdw" },
    {  8, "\x07\x64\x74\x32\x64\x64\x74\x64", "dtd" },
    {  8, "\x05\x00\x00\x00\x41\x57\x31\x2E", "arw" },
    {  8, "\x03\xD9\xA2\x9A\x65\xFB\x4B\xB5", "kdb" },
    {  8, "\x03\x00\x00\x00\x41\x50\x50\x52", "adx" },
    {  8, "\x01\x00\x01\x00\x2C\x00\x20\x00", "icn" },
    {  8, "\x00\xFF\xB4\x00\x01\x00\x00\x00", "hbk" },
    {  8, "\x00\x5B\x07\x20\x00\x00\x00\x2C", "vit" },
    {  8, "\x00\x56\x53\x50\x00\x00\x00\x00", "psv" },
    {  8, "\x00\x00\x01\x1C\x69\x74\x63\x68", "itc" },
    {  8, "\x00\x00\x00\x00\xF1\x4B\xF2\x40", "bki" },
    {  8, "\x00\x00\x00\x00\x50\x46\x44\x42", "pfd" },
    {  8, "\x00\x00\x00\x00\x14\x00\x00\x00", "tbi" },
    {  8, "\x00\x00\x00\x00\x00\x00\x05\x00", "mpd" },
    {  7, "\xD2\x4E\x4F\x41\x0F\x0C\x20", "noa" },
    {  7, "\x89\x48\x44\x46\x0D\x0A\x1A", "h5" },
    {  7, "\x80\x53\x43\x4D\x4F\x56\x76", "scm" },
    {  7, "\x78\x77\x00\x00\x00\x00\x40", "ozf2" },
    {  7, "\x78\x6F\x66\x20\x30\x33\x30", "x" },
    {  7, "\x76\x69\x76\x69\x64\x61\x73", "viv" },
    {  7, "\x72\x74\x73\x70\x3A\x2F\x2F", "ram" },
    {  7, "\x72\x66\x63\x61\x63\x68\x65", "rfo" },
    {  7, "\x70\x61\x71\x38\x6F\x20\x2D", "paq8o" },
    {  7, "\x70\x61\x71\x38\x6C\x20\x2D", "paq8l" },
    {  7, "\x70\x61\x71\x38\x6A\x64\x20", "paq8jd" },
    {  7, "\x70\x61\x71\x38\x6A\x63\x20", "paq8jc" },
    {  7, "\x6F\x62\x6A\x65\x63\x74\x20", "dfm" },
    {  7, "\x6E\x65\x77\x6D\x74\x6C\x20", "mtl" },
    {  7, "\x6E\x65\x74\x63\x64\x66\x20", "cdl" },
    {  7, "\x67\x72\x61\x70\x68\x20\x5B", "gml" },
    {  7, "\x65\x61\x33\x03\x00\x00\x00", "oma" },
    {  7, "\x62\x69\x6E\x74\x65\x72\x72", "bt" },
    {  7, "\x5B\x54\x6F\x6D\x54\x6F\x6D", "bif" },
    {  7, "\x5B\x48\x45\x41\x44\x5D\x0D", "ppj" },
    {  7, "\x5B\x48\x44\x52\x5D\x0D\x0A", "mrk" },
    {  7, "\x59\x4D\x53\x54\x80\x00\x59", "ym" },
    {  7, "\x58\x44\x43\x4E\x45\x58\x54", "xdc" },
    {  7, "\x58\x41\x52\x41\xA3\xA3\x0D", "xar" },
    {  7, "\x57\x6F\x72\x64\x50\x72\x6F", "lwp" },
    {  7, "\x57\x45\x44\x20\x56\x31\x2E", "wed" },
    {  7, "\x56\x65\x72\x73\x3A\x32\x44", "sym" },
    {  7, "\x56\x52\x54\x4C\x49\x42\x2D", "vlx" },
    {  7, "\x56\x45\x52\x53\x49\x4F\x4E", "ufi" },
    {  7, "\x56\x41\x47\x70\x00\x00\x00", "vag" },
    {  7, "\x55\x41\x50\x30\x31\x30\x30", "uap" },
    {  7, "\x54\x69\x74\x6C\x65\x3A\x20", "xlo" },
    {  7, "\x53\x6F\x75\x72\x63\x65\x3A", "" },
    {  7, "\x52\x54\x45\x4E\x43\x21\x1A", "rte" },
    {  7, "\x52\x4B\x00\x00\x56\x31\x2E", "rkp" },
    {  7, "\x52\x45\x47\x45\x44\x49\x54", "reg" },
    {  7, "\x50\x37\x20\x33\x33\x32\x0A", "p7" },
    {  7, "\x4D\x6F\x64\x65\x6C\x20\x7B", "mdl" },
    {  7, "\x4D\x61\x6C\x69\x65\x47\x46", "mgf" },
    {  7, "\x4D\x49\x44\x6C\x65\x74\x2D", "jad" },
    {  7, "\x4D\x45\x4C\x4F\x44\x59\x3A", "imelody" },
    {  7, "\x4C\x4C\x57\x46\x4D\x20\x23", "wfm" },
    {  7, "\x4A\x52\x63\x68\x69\x76\x65", "jrc" },
    {  7, "\x49\x44\x33\x03\x00\x00\x00", "koz" },
    {  7, "\x48\x50\x48\x50\x34\x38\x2D", "gro" },
    {  7, "\x48\x4C\x32\x44\x45\x4D\x4F", "dem" },
    {  7, "\x48\x45\x41\x44\x45\x52\x20", "pdb" },
    {  7, "\x47\x52\x5A\x69\x70\x49\x49", "grz" },
    {  7, "\x46\x72\x6F\x6D\x3A\x20\x3C", "mht" },
    {  7, "\x46\x43\x53\x32\x2E\x30\x20", "fcs" },
    {  7, "\x45\x6E\x63\x68\x00\x0F\x02", "enc" },
    {  7, "\x45\x52\x4D\x48\x44\x52\x09", "xer" },
    {  7, "\x45\x50\x47\x01\x00\x00\x00", "vfz" },
    {  7, "\x44\x72\x2E\x57\x65\x62\x20", "vdb" },
    {  7, "\x44\x4D\x44\x4C\x11\x49\x4E", "mdl" },
    {  7, "\x43\x57\x46\x4F\x52\x4D\x53", "tfm" },
    {  7, "\x43\x52\x55\x53\x48\x20\x76", "cru" },
    {  7, "\x43\x48\x46\x49\x4C\x45\x3A", "ch" },
    {  7, "\x43\x48\x46\x45\x4E\x43\x3A", "ch" },
    {  7, "\x43\x41\x44\x53\x54\x44\x1A", "cad" },
    {  7, "\x42\x69\x6F\x41\x72\x63\x21", "bio" },
    {  7, "\x42\x61\x73\x69\x6E\x3A\x20", "basin" },
    {  7, "\x42\x4F\x53\x53\x20\x37\x20", "asm" },
    {  7, "\x42\x4C\x49\x32\x32\x33\x51", "bli" },
    {  7, "\x42\x41\x4C\x54\x52\x41\x44", "" },
    {  7, "\x41\x6C\x65\x79\x4D\x6F\x64", "alm" },
    {  7, "\x41\x4F\x53\x32\x53\x49\x47", "aas" },
    {  7, "\x41\x4D\x53\x68\x64\x72\x1A", "ams" },
    {  7, "\x41\x44\x42\x61\x73\x65\x20", "cdb" },
    {  7, "\x41\x44\x41\x1A\x00\x01\x00", "ada" },
    {  7, "\x40\x74\x69\x74\x6C\x65\x20", "bas" },
    {  7, "\x3C\x4A\x53\x42\x3E\x0D\x0A", "jsb" },
    {  7, "\x3C\x3C\x73\x69\x74\x65\x3E", "xex" },
    {  7, "\x38\x42\x43\x42\x00\x01\x0B", "acb" },
    {  7, "\x2E\x73\x6E\x64\x00\x00\x00", "au" },
    {  7, "\x28\x43\x46\x47\x29\x0D\x0A", "trv" },
    {  7, "\x25\x62\x69\x74\x6D\x61\x70", "fbm" },
    {  7, "\x24\x48\x45\x41\x44\x45\x52", "cad" },
    {  7, "\x23\x56\x52\x4D\x4C\x20\x56", "wrl" },
    {  7, "\x23\x55\x47\x43\x3A\x32\x20", "" },
    {  7, "\x23\x54\x49\x54\x4C\x45\x3D", "stx" },
    {  7, "\x23\x54\x49\x54\x4C\x45\x3A", "sm" },
    {  7, "\x23\x21\x2F\x62\x69\x6E\x2F", "sh" },
    {  7, "\x21\x55\x41\x2D\x63\x66\x67", "zcfg" },
    {  7, "\x21\x20\x49\x4C\x45\x43\x20", "ndb" },
    {  7, "\x20\x2F\x49\x44\x45\x4E\x54", "ctx" },
    {  7, "\x1A\x46\x53\x43\x42\x4E\x4B", "bnk" },
    {  7, "\x0A\x00\x00\x00\x00\x0B\x03", "cad" },
    {  7, "\x06\x4B\x72\x79\x32\x30\x78", "cryptomite" },
    {  7, "\x00\x00\x00\x00\x00\x02\x00", "tps" },
    {  6, "\xF1\x00\x40\xBB\x00\x00", "cmu" },
    {  6, "\xD7\xCD\xC6\x9A\x00\x00", "apm" },
    {  6, "\xD7\xAD\x64\xAB\xFB\x69", "rge" },
    {  6, "\xD1\x00\x00\x00\xC1\x00", "wbd" },
    {  6, "\xCC\x33\x00\x00\x00\x00", "edb" },
    {  6, "\xC7\x55\xC5\x6D\xE1\x70", "gmp" },
    {  6, "\xAC\x9E\xBD\x8F\x00\x00", "qdf" },
    {  6, "\x84\x10\xFF\xFF\xFF\xFF", "roq" },
    {  6, "\x7B\x5C\x70\x77\x64\x32", "pwd" },
    {  6, "\x78\xDA\xEC\x3B\x7F\x78", "zl" },
    {  6, "\x76\x65\x72\x09\x30\x09", "aam" },
    {  6, "\x71\xA8\x00\x00\x01\x02", "isu" },
    {  6, "\x70\x61\x71\x38\x6F\x38", "paq8o8" },
    {  6, "\x68\x73\x69\x31\x00\x00", "hsi" },
    {  6, "\x67\x20\x47\x43\x45\x20", "gam" },
    {  6, "\x66\x4D\x41\x49\x00\x00", "iaf" },
    {  6, "\x64\x44\x6F\x63\x44\x32", "drw" },
    {  6, "\x63\x6D\x69\x64\x00\x00", "pmd" },
    {  6, "\x63\x26\x01\x00\x04\x00", "scn" },
    {  6, "\x5B\x6D\x61\x69\x6E\x5D", "pcf" },
    {  6, "\x5B\x52\x6F\x6F\x6D\x5D", "mst" },
    {  6, "\x5B\x4E\x57\x5A\x5D\x00", "nwc" },
    {  6, "\x5B\x49\x6E\x66\x6F\x5D", "pfg" },
    {  6, "\x5A\x79\x58\x45\x4C\x02", "zvd" },
    {  6, "\x59\x75\x47\x69\x57\x43", "sav" },
    {  6, "\x58\x49\x46\x42\x49\x4E", "xfb" },
    {  6, "\x57\x41\x4C\x54\x4F\x50", "top" },
    {  6, "\x56\x54\x49\x76\x32\x2E", "skn" },
    {  6, "\x56\x43\x50\x43\x48\x30", "pch" },
    {  6, "\x56\x43\x4C\x4D\x54\x46", "svm" },
    {  6, "\x55\x46\x41\xC6\xD2\xC1", "ufa" },
    {  6, "\x54\x54\x46\x4E\x01\x01", "tax" },
    {  6, "\x54\x49\x53\x20\x56\x31", "tis" },
    {  6, "\x54\x44\x42\x46\x01\x00", "tdb" },
    {  6, "\x54\x41\x50\x45\x00\x00", "bkf" },
    {  6, "\x53\x68\x49\x6E\x42\x6F", "sib" },
    {  6, "\x53\x57\xE6\xE7\xE7\xE7", "twf" },
    {  6, "\x53\x52\x53\x43\x00\x01", "rsg" },
    {  6, "\x53\x4E\x54\x21\x00\x00", "pru2" },
    {  6, "\x53\x42\x52\x53\x54\x4C", "wsstyles" },
    {  6, "\x52\xCC\x00\x00\x00\x00", "rle" },
    {  6, "\x52\x53\x52\x43\x0D\x0A", "uir" },
    {  6, "\x50\x54\x43\x52\x52\x43", "pwt" },
    {  6, "\x50\x52\x41\x4D\x00\x00", "krz" },
    {  6, "\x50\x4B\x03\x04\x14\x00", "grs" },
    {  6, "\x50\x49\x43\xDC\x30\x30", "pic" },
    {  6, "\x50\x49\x43\x54\x00\x08", "img" },
    {  6, "\x50\x47\x46\x01\x10\x00", "pgf" },
    {  6, "\x50\x43\x52\x45\x4B\x4F", "rkp" },
    {  6, "\x50\x41\x51\x34\x0D\x0A", "" },
    {  6, "\x50\x41\x50\x50\x07\x02", "gam" },
    {  6, "\x50\x33\x01\x00\x80\x01", "exp" },
    {  6, "\x4F\x44\x53\x50\x47\x4D", "pgm" },
    {  6, "\x4E\xF5\x46\xE9\x6C\xE5", "shk" },
    {  6, "\x4E\x61\x6D\x65\x3A\x20", "cod" },
    {  6, "\x4E\x45\x53\x4D\x1A\x01", "nsf" },
    {  6, "\x4D\x5A\x20\x41\x56\x47", "bin" },
    {  6, "\x4D\x4F\x58\x43\x45\x4C", "mxl" },
    {  6, "\x4D\x4F\x56\x49\x45\x20", "cbf" },
    {  6, "\x4D\x49\x4F\x41\x4C\x42", "mia" },
    {  6, "\x4D\x46\x57\x4D\x4F\x44", "mod" },
    {  6, "\x4D\x44\x4D\x50\x93\xA7", "mdmp" },
    {  6, "\x4D\x44\x44\x43\x32\x30", "mdd" },
    {  6, "\x4D\x43\x46\x20\x2D\x20", "mcf" },
    {  6, "\x4C\x5A\x41\x4E\x49\x4D", "lza" },
    {  6, "\x4C\x55\x4B\x53\xBA\xBE", "" },
    {  6, "\x4C\x50\x46\x20\x00\x01", "anm" },
    {  6, "\x4C\x4F\x43\x55\x53\x20", "gb" },
    {  6, "\x4C\x46\x53\x53\x50\x52", "spr" },
    {  6, "\x4C\x00\x52\x00\x46\x00", "lrf" },
    {  6, "\x4A\x49\x46\x39\x39\x61", "jif" },
    {  6, "\x4A\x41\x52\x43\x53\x00", "jar" },
    {  6, "\x49\x54\x52\x30\x30\x31", "itr" },
    {  6, "\x49\x49\x02\x04\x20\xB4", "sch" },
    {  6, "\x49\x43\x01\x02\x01\x00", "ice" },
    {  6, "\x48\xE7\xFF\xFE\x4D\xFA", "sun" },
    {  6, "\x48\x4C\x53\x51\x5A\x31", "sqz" },
    {  6, "\x48\x4C\x44\x45\x4D\x4F", "dem" },
    {  6, "\x48\x42\x41\x53\x64\x00", "bas" },
    {  6, "\x47\x53\x50\x63\x0E\x00", "gss" },
    {  6, "\x47\x49\x46\x38\x39\x61", "gif" },
    {  6, "\x47\x49\x46\x38\x37\x61", "gif" },
    {  6, "\x47\x43\x53\x41\x56\x45", "gcs" },
    {  6, "\x47\x41\x50\x50\x07\x02", "gam" },
    {  6, "\x47\x41\x4D\x45\x26\x01", "gam" },
    //{  6, "\x46\x72\x6F\x6D\x3A\x20", "eml" },
    {  6, "\x46\x72\x61\x6D\x65\x20", "out" },
    {  6, "\x46\x6C\x6F\x77\x4A\x6F", "jo" },
    {  6, "\x46\x69\x6C\x65\x3A\x20", "xif" },
    {  6, "\x46\x4F\x52\x4D\x41\x54", "tim" },
    {  6, "\x46\x4F\x52\x4D\x00\x00", "aifc" },
    {  6, "\x46\x49\x4C\x45\x20\x22", "cue" },
    {  6, "\x45\x86\x00\x00\x06\x00", "qbb" },
    {  6, "\x45\x5A\x42\x49\x4E\x44", "arc" },
    {  6, "\x45\x59\x45\x53\x00\x01", "ce2" },
    {  6, "\x45\x59\x45\x53\x00\x00", "ce1" },
    {  6, "\x45\x47\x50\x52\x4F\x50", "egp" },
    {  6, "\x44\x53\x49\x47\x44\x43", "pac" },
    {  6, "\x44\x52\x57\x47\x44\x32", "" },
    {  6, "\x44\x4D\x57\x4D\x5A\x3A", "mz" },
    {  6, "\x44\x4C\x49\x42\x32\x00", "dcf" },
    {  6, "\x44\x44\x6F\x63\x46\x42", "wdl" },
    {  6, "\x44\x43\x54\xC3\x00\x08", "" },
    {  6, "\x43\x72\x79\x6F\x42\x46", "bf" },
    {  6, "\x43\x72\x75\x69\x73\x65", "odv" },
    {  6, "\x43\x52\x59\x50\x54\x58", "crypt" },
    {  6, "\x43\x4C\x41\x53\x53\x20", "adm" },
    {  6, "\x43\x48\x55\x49\x56\x31", "chu" },
    {  6, "\x43\x48\x50\x21\x00\x00", "chp" },
    {  6, "\x43\x42\x4D\x64\x00\x00", "" },
    {  6, "\x43\x41\x54\x20\x00\x00", "rbs" },
    {  6, "\x43\x41\x52\x75\x6C\x65", "car" },
    {  6, "\x42\x69\x74\x6D\x61\x70", "prc" },
    {  6, "\x42\x65\x67\x69\x6E\x20", "t3d" },
    {  6, "\x42\x50\x49\x4E\x50\x53", "plt" },
    {  6, "\x42\x4C\x4F\x42\x53\x20", "blob" },
    {  6, "\x42\x45\x47\x49\x4E\x3A", "vcf" },
    {  6, "\x42\x45\x47\x49\x4E\x20", "swm" },
    {  6, "\x41\x50\x46\x31\x30\x1A", "apf" },
    {  6, "\x41\x4D\x41\x50\x00\x00", "a3d" },
    {  6, "\x41\x43\x31\x30\x32\x31", "dwg" },
    {  6, "\x41\x43\x31\x30\x31\x38", "dwg" },
    {  6, "\x41\x43\x31\x30\x31\x35", "dwg" },
    {  6, "\x41\x43\x31\x30\x31\x34", "dwg" },
    {  6, "\x41\x43\x31\x30\x31\x33", "dwg" },
    {  6, "\x41\x43\x31\x30\x31\x32", "dwg" },
    {  6, "\x41\x43\x31\x30\x31\x31", "dwg" },
    {  6, "\x41\x43\x31\x30\x31\x30", "dwg" },
    {  6, "\x41\x43\x31\x30\x30\x39", "dwg" },
    {  6, "\x41\x43\x31\x30\x30\x36", "dwg" },
    {  6, "\x41\x43\x31\x30\x30\x33", "dwg" },
    {  6, "\x41\x43\x31\x30\x30\x32", "dwg" },
    {  6, "\x41\x42\x4B\x43\x01\x01", "abk" },
    {  6, "\x41\x41\x4F\x50\x31\x0D", "aop" },
    {  6, "\x41\x41\x43\x00\x01\x00", "aac" },
    {  6, "\x3C\x73\x74\x79\x6C\x65", "uifile" },
    {  6, "\x3C\x6C\x6C\x73\x64\x3E", "llsd" },
    //{  6, "\x3C\x48\x54\x4D\x4C\x3E", "snf" },
    {  6, "\x3C\x3F\x78\x6D\x6C\x3A", "mmd" },
    {  6, "\x3C\x3F\x78\x6D\x6C\x20", "aml" },
    {  6, "\x3B\x20\x46\x42\x58\x20", "fbx" },
    {  6, "\x37\x7A\xBC\xAF\x27\x1C", "7z" },
    {  6, "\x33\x44\x43\x20\x7B\x0D", "rds" },
    {  6, "\x32\x44\x4B\x47\x54\x32", "" },
    {  6, "\x32\x30\x72\x00\x8C\xA3", "dnp" },
    {  6, "\x30\x20\x48\x45\x41\x44", "ged" },
    {  6, "\x2F\x2A\x5B\x5B\x0D\x0A", "mql" },
    {  6, "\x2E\x4D\x43\x41\x44\x20", "mcd" },
    {  6, "\x2A\x54\x49\x4D\x4C\x50", "tns" },
    {  6, "\x28\x65\x64\x69\x66\x20", "edn" },
    {  6, "\x28\x44\x57\x46\x20\x56", "dwf" },
    {  6, "\x23\x54\x49\x54\x4C\x45", "gxf" },
    {  6, "\x23\x42\x52\x49\x46\x20", "bqy" },
    {  6, "\x23\x21\x41\x4D\x52\x0A", "amr" },
    {  6, "\x21\x54\x79\x70\x65\x3A", "qif" },
    {  6, "\x1A\xD1\xBD\x1A\x01\x00", "" },
    {  6, "\x1A\x46\x53\x43\x54\x53", "tst" },
    {  6, "\x16\x16\x16\x24\x00\x00", "tap" },
    {  6, "\x11\x1B\x5A\x1B\x23\x50", "mitsu" },
    {  6, "\x10\x12\x14\x20\x00\x34", "" },
    {  6, "\x07\x53\x50\x4C\x41\x4E", "spl" },
    {  6, "\x05\x32\x52\x54\x46\x46", "rtab" },
    {  6, "\x01\xDA\x01\x01\x00\x03", "rgb" },
    {  6, "\x01\xDA\x01\x01\x00\x02", "bw" },
    {  6, "\x01\xDA\x00\x03\x00\x01", "sgi" },
    {  6, "\x01\x02\x04\x02\x02\x02", "cbs" },
    {  6, "\x01\x02\x04\x02\x01\x02", "cbf" },
    {  6, "\x01\x00\x09\x00\x00\x03", "wmf" },
    {  6, "\x00\x41\x64\x53\x4F\x53", "sos" },
    {  6, "\x00\x1E\x84\x90\x00\x00", "snm" },
    {  6, "\x00\x00\x00\x00\x01\xBC", "gxf" },
    {  5, "\xFF\xFE\x31\x00\x0D", "srt" },
    {  5, "\xFF\xA0\xFF\xA8\x00", "wsq" },
    {  5, "\xFF\x4F\xFF\x51\x00", "jpc" },
    {  5, "\xFF\x46\x4F\x4E\x54", "cpi" },
    {  5, "\xFF\x42\x53\x47\x00", "bsn" },
    {  5, "\xFE\xFE\x07\x01\x00", "myi" },
    {  5, "\xFD\xFD\xFD\xFD\x00", "fdr" },
    {  5, "\xF8\xD2\xBA\x10\x00", "ist" },
    {  5, "\xAC\xED\x00\x05\x77", "lsc" },
    {  5, "\x85\xA8\x01\x01\x00", "vce" },
    {  5, "\x7B\x5C\x72\x74\x66", "rtf" },
    {  5, "\x7B\x5C\x70\x77\x69", "pwi" },
    {  5, "\x78\x73\x69\x20\x30", "xsi" },
    {  5, "\x77\x74\x6D\x3A\x20", "tbs" },
    {  5, "\x73\x6E\x6F\x6F\x70", "cap" },
    {  5, "\x72\x69\x66\x66\x2E", "sfvidcap" },
    {  5, "\x67\x26\x02\x42\x4A", "jce" },
    {  5, "\x66\x6C\x63\x32\x61", "flc" },
    {  5, "\x66\x69\x6C\x45\x1A", "" },
    {  5, "\x62\x74\x70\x63\x20", "btpc" },
    {  5, "\x5B\x76\x65\x72\x5D", "sam" },
    {  5, "\x5B\x56\x4D\x44\x5D", "vmd" },
    {  5, "\x5B\x53\x43\x43\x5D", "scc" },
    {  5, "\x59\x61\x7A\x30\x00", "arc" },
    {  5, "\x59\x21\x56\x4D\x32", "post" },
    {  5, "\x58\x46\x45\x52\x44", "xferd" },
    {  5, "\x57\x44\x5A\x49\x50", "wdz" },
    {  5, "\x56\x4F\x52\x54\x30", "vort" },
    {  5, "\x56\x45\x52\x53\x4E", "in" },
    {  5, "\x56\x42\x41\x50\x49", "apv" },
    {  5, "\x55\x52\x4C\x3A\x20", "grx" },
    {  5, "\x55\x48\x53\x0D\x0A", "uhs" },
    {  5, "\x54\x49\x54\x4C\x20", "res" },
    {  5, "\x53\x8F\x4E\x47\x2E", "uds" },
    {  5, "\x53\x57\x45\x4E\x43", "enc" },
    {  5, "\x53\x56\x46\x20\x76", "svf" },
    {  5, "\x53\x53\x42\x4F\x42", "fss" },
    {  5, "\x53\x50\x49\x53\x1A", "" },
    {  5, "\x53\x49\x54\x21\x00", "sit" },
    {  5, "\x53\x45\x4D\x68\x29", "one" },
    {  5, "\x53\x43\x46\x4D\x03", "sc" },
    {  5, "\x53\x41\x64\x54\x01", "sat" },
    {  5, "\x52\x61\x72\x21\x1A", "rar" },
    {  5, "\x52\x49\x46\x58\x00", "dxr" },
    //{  5, "\x52\x49\x46\x46\xEC", "cmv" },
    {  5, "\x52\x44\x58\x32\x0A", "rdata" },
    {  5, "\x52\x44\x4F\x46\x46", "" },
    {  5, "\x52\x43\x41\x44\x0D", "rcad" },
    {  5, "\x52\x41\x53\x47\x49", "rgs" },
    {  5, "\x50\x53\x41\x01\x03", "psa" },
    {  5, "\x50\x53\x31\x36\xFE", "ps16" },
    {  5, "\x50\x4D\x01\x00\x42", "pms" },
    {  5, "\x50\x4B\x03\x04\x14", "545" },
    {  5, "\x50\x47\x44\x4D\x50", "" },
    {  5, "\x4F\x54\x54\x4F\x00", "otf" },
    {  5, "\x4F\x50\x49\x4D\x30", "oci" },
    {  5, "\x4F\x42\x53\x53\x1A", "tsc" },
    {  5, "\x4E\x49\x54\x46\x30", "ntf" },
    {  5, "\x4D\x73\x52\x63\x66", "gdb" },
    {  5, "\x4D\x73\x52\x63\x64", "mps" },
    {  5, "\x4D\x58\x54\x58\x00", "mxtx" },
    {  5, "\x4D\x53\x57\x49\x4D", "wim" },
    {  5, "\x4D\x53\x51\x4D\x78", "sqm" },
    {  5, "\x4D\x53\x4F\x42\x00", "mso" },
    {  5, "\x4D\x50\x4C\x45\x32", "ple" },
    {  5, "\x4D\x4D\x44\x43\x00", "mmdc" },
    {  5, "\x4D\x4C\x44\x52\x57", "ems" },
    {  5, "\x4D\x41\x72\x30\x00", "mar" },
    {  5, "\x4D\x41\x52\x31\x00", "mar" },
    {  5, "\x4C\x5A\x53\x53\x00", "tk3" },
    {  5, "\x4C\x59\x4E\x58\x00", "lnx" },
    {  5, "\x4A\x53\x41\x56\x73", "sav" },
    {  5, "\x4A\x4D\x47\x20\x76", "jmg" },
    {  5, "\x49\x49\x4F\x32\x48", "pe4" },
    {  5, "\x49\x49\x02\x04\x20", "pcb" },
    {  5, "\x49\x45\x53\x4E\x41", "ies" },
    {  5, "\x49\x44\x20\x20\x20", "emb" },
    {  5, "\x48\x44\x52\x2A\x50", "pbd" },
    {  5, "\x47\x74\x61\x53\x41", "rep" },
    {  5, "\x47\x68\x69\x64\x6F", "gq" },
    {  5, "\x47\x4F\x42\x45\x20", "pve" },
    {  5, "\x47\x47\x42\x54\x00", "bsp" },
    {  5, "\x46\x72\x6F\x6D\x20", "" },
    {  5, "\x46\x54\x4D\x4E\x03", "ftm" },
    {  5, "\x46\x4F\x52\x4D\x00", "dax" },
    {  5, "\x46\x44\x42\x48\x00", "fdat" },
    {  5, "\x46\x44\x41\x54\x41", "fdd" },
    {  5, "\x45\x52\x02\x00\x00", "toast" },
    {  5, "\x43\x6E\x43\x32\x55", "cca" },
    {  5, "\x43\x58\x46\x1A\x75", "cxf" },
    {  5, "\x43\x50\x59\x41\x20", "opj" },
    {  5, "\x43\x41\x5A\x49\x50", "caz" },
    {  5, "\x43\x41\x53\x4C\x02", "csm" },
    {  5, "\x42\x6C\x75\x65\x00", "blue" },
    {  5, "\x42\x41\x47\x31\x31", "bag" },
    {  5, "\x41\x58\x53\x53\x50", "ssp" },
    {  5, "\x41\x54\x46\x09\x31", "gpr" },
    {  5, "\x41\x4B\x54\x09\x09", "akt" },
    {  5, "\x41\x44\x49\x46\x20", "adif" },
    {  5, "\x41\x26\x4C\x2D\x00", "ged" },
    {  5, "\x40\x74\x65\x78\x74", "kin" },
    {  5, "\x3F\x3F\x3F\x3F\x3F", "0" },
    {  5, "\x3C\x56\x45\x52\x20", "dgs" },
    {  5, "\x3C\x54\x72\x65\x65", "hjt" },
    {  5, "\x3C\x4F\x46\x43\x3E", "ofc" },
    //{  5, "\x3C\x3F\x78\x6D\x6C", "cd" },
    {  5, "\x39\x39\x39\x0D\x0A", "spf" },
    {  5, "\x38\x42\x47\x52\x00", "grd" },
    {  5, "\x38\x42\x41\x53\x1A", "bbf" },
    {  5, "\x34\x42\x41\x53\x1A", "bbf" },
    {  5, "\x33\x44\x43\x20\x7B", "car" },
    {  5, "\x30\x3A\x3A\x58\x53", "xs3" },
    {  5, "\x30\x37\x30\x37\x30", "cpio" },
    {  5, "\x2E\x72\x61\xFD\x00", "ra" },
    {  5, "\x25\x76\x73\x6D\x25", "vp3" },
    {  5, "\x25\x53\x4B\x33\x3A", "sks" },
    {  5, "\x25\x50\x44\x46\x2D", "pdf" },
    {  5, "\x25\x46\x44\x46\x2D", "fdf" },
    {  5, "\x25\x21\x50\x53\x2D", "ai" },
    {  5, "\x23\x50\x45\x53\x30", "pes" },
    {  5, "\x23\x4C\x79\x58\x20", "lyx" },
    {  5, "\x23\x46\x49\x47\x20", "fig" },
    {  5, "\x21\x64\x61\x72\x6B", "dark" },
    {  5, "\x20\x4F\x50\x54\x20", "spinput" },
    {  5, "\x1B\x64\x6C\x65\x51", "idol" },
    {  5, "\x1B\x4C\x75\x61\x50", "out" },
    {  5, "\x1B\x4C\x75\x61\x40", "out" },
    {  5, "\x10\x12\x14\x18\x00", "vix" },
    {  5, "\x08\x00\x00\x00\x01", "t0*" },
    {  5, "\x07\x20\x4D\x4D\x00", "cam" },
    {  5, "\x01\x0F\x00\x00\x08", "ldf" },
    {  5, "\x00\x53\x46\x5A\x41", "sfz" },
    {  5, "\x00\x4D\x5A\x46\x41", "mzf" },
    {  5, "\x00\x01\x00\x00\x00", "ttf" },
    {  5, "\x00\x00\x01\xBA\x44", "mpg" },
    {  5, "\x00\x00\x01\x00\x00", "dfont" },
    {  4, "\xFF\xFF\xFF\xFF", "dc5" },
    {  4, "\xFF\xFE\x3C\x00", "htc" },
    {  4, "\xFF\xFE\x00\x00", "txt" },
    {  4, "\xFF\x57\x50\x43", "wcm" },
    {  4, "\xFF\x42\x4C\xFF", "" },
    {  4, "\xFF\x00\xAA\x00", "ssf" },
    {  4, "\xFE\xFE\x05\x02", "ism" },
    {  4, "\xFE\xED\xFA\xCF", "" },
    {  4, "\xFE\xED\xFA\xCE", "" },
    {  4, "\xFE\x01\x07\x07", "frm" },
    {  4, "\xF9\xB2\x2A\xD1", "mxs" },
    {  4, "\xF6\x8D\x14\xFD", "b" },
    {  4, "\xF0\x0D\x00\x00", "lib" },
    {  4, "\xEF\xBB\xBF\x3C", "aum" },
    {  4, "\xED\xFF\xFE\x07", "zgt" },
    {  4, "\xED\xAB\xEE\xDB", "rpm" },
    {  4, "\xE3\x82\x85\x96", "pwl" },
    {  4, "\xE1\xE6\xD5\x1A", "bmf" },
    {  4, "\xDE\xC0\xFF\xFF", "cod" },
    {  4, "\xDE\xAD\xBE\xEF", "clmov" },
    {  4, "\xDE\x12\x04\x95", "gmo" },
    {  4, "\xDD\x73\x66\x73", "txt" },
    {  4, "\xDD\x00\x00\x0E", "dcu" },
    {  4, "\xDB\xA5\x2D\x00", "doc" },
    {  4, "\xD4\xC3\xB2\xA1", "pcap" },
    {  4, "\xD4\x43\x00\x00", "trc" },
    {  4, "\xCF\xFA\xED\xFE", "" },
    {  4, "\xCF\xAD\x12\xFE", "dbx" },
    {  4, "\xCE\xFA\xED\xFE", "" },
    {  4, "\xCA\xFE\xBA\xBE", "" },
    {  4, "\xC8\x44\x0F\x99", "cdds" },
    {  4, "\xC5\xD0\xD3\xC6", "eps" },
    {  4, "\xC4\xAB\xCD\xAB", "acf" },
    {  4, "\xC3\xAB\xCD\xAB", "acs" },
    {  4, "\xC3\x54\x56\x53", "tv4" },
    {  4, "\xC1\x83\x2A\x9E", "unr" },
    {  4, "\xBC\x40\x10\x00", "sky" },
    {  4, "\xBA\xBE\xEB\xEA", "ani" },
    {  4, "\xB8\xC9\x0C\x00", "ins" },
    {  4, "\xB7\x49\x43\x50", "icpr" },
    {  4, "\xB4\x6E\x68\x44", "tib" },
    {  4, "\xB2\x97\xE1\x69", "evy" },
    {  4, "\xB1\x68\xDE\x3A", "dcx" },
    {  4, "\xB0\xB5\xF1\x1E", "pvk" },
    {  4, "\xB0\x54\x56\x67", "tvgskin" },
    {  4, "\xB0\x4D\x46\x4E", "pwl" },
    {  4, "\xAB\xCD\x00\x05", "fnt" },
    {  4, "\xA8\x4D\x50\xA8", "" },
    {  4, "\xA5\x9D\x7A\x18", "dnl" },
    {  4, "\x9F\xC5\x8D\x48", "pk3" },
    {  4, "\x9D\xDB\xC5\x26", "vi" },
    {  4, "\x9A\x9F\xAA\x11", "plt" },
    {  4, "\x99\x4E\x0D\x0A", "pyc" },
    {  4, "\x93\xB2\x00\x00", "rlc" },
    {  4, "\x91\xD5\x12\x00", "" },
    {  4, "\x91\x33\x48\x46", "hap" },
    {  4, "\x87\xC6\x0D\x0A", "pyc" },
    {  4, "\x83\xE5\xF3\x65", "b" },
    {  4, "\x80\xE8\x00\x00", "" },
    {  4, "\x7E\x42\x4B\x00", "psp" },
    {  4, "\x7A\x62\x65\x78", "info" },
    {  4, "\x7A\x4C\x4B\x44", "lkd" },
    {  4, "\x7A\x1A\x20\x10", "sisx" },
    {  4, "\x78\x9F\x3E\x22", "tnef" },
    {  4, "\x78\x9C\xEC\xBD", "skn" },
    {  4, "\x78\x61\x72\x21", "xar" },
    {  4, "\x77\x76\x70\x6B", "wv" },
    {  4, "\x77\x64\x67\x74", "widget" },
    {  4, "\x76\x2F\x31\x01", "exr" },
    {  4, "\x75\x81\xDA\x35", "b" },
    {  4, "\x74\x74\x63\x66", "ttc" },
    {  4, "\x74\x66\x4D\x52", "fts" },
    {  4, "\x74\x42\x61\x4B", "tak" },
    {  4, "\x73\xB2\x90\xF4", "" },
    {  4, "\x73\x7A\x65\x7A", "pbd" },
    {  4, "\x73\x71\x73\x68", "sfs" },
    {  4, "\x73\x6C\x68\x2E", "dat" },
    {  4, "\x73\x6C\x68\x21", "dat" },
    {  4, "\x72\x69\x66\x66", "acd" },
    {  4, "\x72\x65\x6D\x20", "bas" },
    {  4, "\x70\x74\x61\x62", "ptb" },
    {  4, "\x70\x6D\x70\x6D", "pmp" },
    {  4, "\x70\x6C\x79\x0A", "ply" },
    {  4, "\x70\x6B\x08\x08", "bgi" },
    {  4, "\x70\x4D\x38\x36", "pac" },
    {  4, "\x70\x4D\x38\x35", "pac" },
    {  4, "\x6D\x73\x69\x64", "sid" },
    {  4, "\x6D\x6B\x77\x34", "mkw" },
    {  4, "\x6D\x66\x6C\x68", "mva" },
    {  4, "\x6C\x6C\x76\x63", "bc" },
    {  4, "\x6C\x64\x77\x67", "ldw" },
    {  4, "\x6C\x33\x33\x6C", "dbb" },
    {  4, "\x6B\x52\x41\x57", "kraw" },
    {  4, "\x69\x6D\x61\x34", "ima4" },
    {  4, "\x69\x63\x6E\x73", "icns" },
    {  4, "\x68\x73\x71\x73", "sfs" },
    {  4, "\x66\x6C\x66\x32", "flf" },
    {  4, "\x66\x66\x6E\x61", "ffna" },
    {  4, "\x66\x4C\x70\x4B", "" },
    {  4, "\x66\x4C\x61\x43", "flac" },
    {  4, "\x64\x6E\x73\x2E", "au" },
    {  4, "\x63\x61\x66\x66", "caf" },
    {  4, "\x62\x6C\x7A\x1A", "blz" },
    {  4, "\x62\x46\x4C\x54", "" },
    {  4, "\x61\x73\x6B\x77", "ask" },
    {  4, "\x61\x6A\x6B\x67", "shn" },
    {  4, "\x61\x63\x63\x3A", "acr" },
    {  4, "\x5E\x76\x45\x93", "b" },
    {  4, "\x5D\xFC\xC8\x00", "hus" },
    {  4, "\x5C\x31\x63\x77", "chi" },
    {  4, "\x5B\x74\x69\x3A", "lrc" },
    {  4, "\x5B\x50\x56\x58", "" },
    {  4, "\x5A\x58\x53\x54", "szx" },
    {  4, "\x5A\x58\x38\x32", "zx82" },
    {  4, "\x5A\x56\x52\x40", "zvr" },
    {  4, "\x5A\x4F\x4F\x20", "zoo" },
    {  4, "\x5A\x4D\x32\x53", "z3d" },
    {  4, "\x5A\x4C\x49\x42", "egrp" },
    {  4, "\x5A\x45\x58\x50", "zexp" },
    {  4, "\x59\xA6\x6A\x95", "ras" },
    {  4, "\x58\xBE\x6E\x9A", "b" },
    {  4, "\x58\x69\x6E\x65", "" },
    {  4, "\x58\x63\x75\x72", "" },
    {  4, "\x58\x59\x5A\x31", "xyz" },
    {  4, "\x58\x58\x4D\x41", "amxx" },
    {  4, "\x58\x55\x49\x5A", "xzp" },
    {  4, "\x58\x54\x01\x00", "bdr" },
    {  4, "\x58\x4D\x46\x5F", "mxmf" },
    {  4, "\x58\x46\x49\x52", "cct" },
    {  4, "\x58\x43\x50\x00", "cap" },
    {  4, "\x58\x42\x45\x48", "xbe" },
    {  4, "\x58\x41\x4A\x00", "xa" },
    {  4, "\x58\x41\x49\x00", "xa" },
    {  4, "\x57\x56\x5A\x1A", "wvz" },
    {  4, "\x57\x54\x43\x41", "wpa" },
    {  4, "\x57\x52\x44\x52", "sav" },
    {  4, "\x57\x4F\x54\x46", "wrf" },
    {  4, "\x57\x4E\x47\x5A", "wkz" },
    {  4, "\x57\x4D\x4D\x50", "dat" },
    {  4, "\x57\x44\x41\x54", "wlk" },
    {  4, "\x57\x42\x4E\x44", "xwb" },
    {  4, "\x57\x41\x44\x33", "wad" },
    {  4, "\x56\x67\x6D\x20", "vgm" },
    {  4, "\x56\x5A\x46\x30", "vz" },
    {  4, "\x56\x54\x42\x4C", "qic" },
    {  4, "\x56\x4D\x47\x50", "mpn" },
    {  4, "\x56\x42\x4D\x1A", "vbm" },
    {  4, "\x56\x41\x52\x67", "mv3" },
    {  4, "\x56\x35\x44\x0A", "v5d" },
    {  4, "\x55\xAA\x55\xAA", "d2s" },
    {  4, "\x55\x44\x53\x32", "uds" },
    {  4, "\x55\x43\x45\x58", "uce" },
    {  4, "\x55\x43\x32\x1A", "uc2" },
    {  4, "\x54\x5A\x46\x42", "zoo" },
    {  4, "\x54\x57\x49\x4E", "vqf" },
    {  4, "\x54\x50\x46\x33", "tpf" },
    {  4, "\x54\x50\x46\x30", "" },
    {  4, "\x54\x4B\x03\x04", "tbs" },
    {  4, "\x54\x49\x4D\x32", "tm2" },
    {  4, "\x54\x48\x58\x49", "ins" },
    {  4, "\x54\x48\x50\x00", "thp" },
    {  4, "\x54\x48\x4E\x4C", "thn" },
    {  4, "\x54\x45\x58\x4E", "pvr" },
    {  4, "\x54\x45\x53\x34", "esp" },
    {  4, "\x54\x45\x53\x33", "esp" },
    {  4, "\x54\x45\x52\x46", "dat" },
    {  4, "\x54\x44\x32\x5F", "pdb" },
    {  4, "\x54\x34\x1A\x00", "to4" },
    {  4, "\x53\x66\x66\x66", "sff" },
    {  4, "\x53\x5A\x0A\x04", "" },
    {  4, "\x53\x54\x52\x54", "dce" },
    {  4, "\x53\x54\x52\x4D", "ast" },
    {  4, "\x53\x50\x00\x00", "spc" },
    {  4, "\x53\x4F\x4E\x47", "son" },
    {  4, "\x53\x4F\x4C\x46", "mus" },
    {  4, "\x53\x4F\x46\x48", "spe" },
    {  4, "\x53\x4E\x54\x45", "sna" },
    {  4, "\x53\x4E\x53\x53", "" },
    {  4, "\x53\x4E\x44\x20", "sou" },
    {  4, "\x53\x4E\x43\x4F", "sn1" },
    {  4, "\x53\x4D\x56\x1A", "smv" },
    {  4, "\x53\x4D\x50\x31", "ksf" },
    {  4, "\x53\x4C\x54\x47", "tlb" },
    {  4, "\x53\x4C\x53\x1A", "wxp" },
    {  4, "\x53\x4B\x59\x20", "scn" },
    {  4, "\x53\x4B\x49\x31", "ski" },
    {  4, "\x53\x48\x50\x49", "fsh" },
    {  4, "\x53\x46\x50\x4B", "sfpack" },
    {  4, "\x53\x45\x54\x20", "aff" },
    {  4, "\x53\x45\x41\x44", "tgv" },
    {  4, "\x53\x43\x68\x46", "chz" },
    {  4, "\x53\x43\x4F\x57", "enc" },
    {  4, "\x53\x43\x4D\x49", "img" },
    {  4, "\x53\x43\x48\x6C", "asf" },
    {  4, "\x53\x42\x49\x1A", "sbi" },
    {  4, "\x53\x42\x43\x1E", "sbc" },
    {  4, "\x53\x42\x31\x00", "sb" },
    {  4, "\x52\x61\x6E\x64", "flm" },
    {  4, "\x52\x5A\x58\x21", "rzx" },
    {  4, "\x52\x5A\x49\x50", "rz" },
    {  4, "\x52\x57\x53\x44", "rwsd" },
    {  4, "\x52\x54\x53\x53", "cap" },
    {  4, "\x52\x53\x54\x4D", "brstm" },
    {  4, "\x52\x53\x49\x44", "sid" },
    {  4, "\x52\x52\x44\x00", "rrd" },
    {  4, "\x52\x50\x4B\x57", "wnk" },
    {  4, "\x52\x50\x43\x32", "rpc" },
    {  4, "\x52\x49\x58\x33", "rix" },
    {  4, "\x52\x49\x46\x58", "mtd" },
    {  4, "\x52\x47\x4D\x48", "hg1" },
    {  4, "\x52\x45\x4D\x20", "cue" },
    {  4, "\x52\x45\x4B\x4F", "reko" },
    {  4, "\x52\x44\x46\x00", "rdf" },
    {  4, "\x52\x41\x56\x1A", "rav" },
    {  4, "\x52\x41\x53\x00", "ras" },
    {  4, "\x52\x41\x52\x43", "arc" },
    {  4, "\x51\x46\x49\xFB", "img" },
    {  4, "\x51\x46\x1A\x1A", "qfc" },
    {  4, "\x50\x57\x53\x33", "psafe3" },
    {  4, "\x50\x57\x41\x44", "wad" },
    {  4, "\x50\x53\x4D\xFE", "psm" },
    {  4, "\x50\x53\x49\x44", "sid" },
    {  4, "\x50\x53\x46\x21", "miniusf" },
    {  4, "\x50\x4D\x43\x43", "grp" },
    {  4, "\x50\x4D\x34\x30", "" },
    {  4, "\x50\x4C\x4D\x1A", "plm" },
    {  4, "\x50\x49\x58\x20", "pix" },
    {  4, "\x50\x49\x4E\x41", "phr" },
    {  4, "\x50\x49\x4D\x32", "pim" },
    {  4, "\x50\x46\x46\x00", "pff" },
    {  4, "\x50\x45\x53\x54", "dat" },
    {  4, "\x50\x44\x4E\x33", "pdn" },
    {  4, "\x50\x43\x53\x00", "" },
    {  4, "\x50\x43\x52\x53", "a4r" },
    {  4, "\x50\x42\x31\x2E", "pwb" },
    {  4, "\x50\x41\x43\x4B", "" },
    {  4, "\x50\x41\x43\x47", "pac" },
    {  4, "\x50\x41\x31\x39", "" },
    {  4, "\x50\x36\x31\x41", "p61" },
    {  4, "\x50\x36\x30\x41", "p60" },
    {  4, "\x50\x35\x30\x41", "p50" },
    {  4, "\x50\x34\x31\x41", "p41" },
    {  4, "\x50\x34\x30\x42", "p40" },
    {  4, "\x50\x00\x49\x00", "ipe" },
    {  4, "\x4F\x72\x61\x20", "eli" },
    {  4, "\x4F\x56\x53\x43", "ove" },
    {  4, "\x4F\x54\x54\x5A", "sav" },
    {  4, "\x4F\x4C\x52\x57", "olrw" },
    {  4, "\x4E\x56\x42\x21", "nvb" },
    {  4, "\x4E\x53\x53\x1A", "nmv" },
    {  4, "\x4E\x51\x45\x4E", "nqi" },
    {  4, "\x4E\x50\x46\x46", "s" },
    {  4, "\x4E\x4F\x4E\x4F", "ekb" },
    {  4, "\x4E\x4D\x46\x20", "nmf" },
    {  4, "\x4E\x4C\x4D\x20", "nlm" },
    {  4, "\x4E\x46\x56\x50", "" },
    {  4, "\x4E\x46\x47\x20", "nfg" },
    {  4, "\x4E\x45\x53\x1A", "nes" },
    {  4, "\x4E\x45\x4B\x4F", "n" },
    {  4, "\x4E\x44\x46\x00", "cndf" },
    {  4, "\x4E\x42\x2A\x00", "jnt" },
    {  4, "\x4E\x41\x52\x43", "narc" },
    {  4, "\x4D\x54\x32\x30", "mt2" },
    {  4, "\x4D\x53\x52\x42", "psw" },
    {  4, "\x4D\x53\x50\x31", "kmp" },
    {  4, "\x4D\x52\x56\x4E", "nvram" },
    {  4, "\x4D\x50\x51\x1A", "mpq" },
    {  4, "\x4D\x50\x2B\x07", "mpc" },
    {  4, "\x4D\x4F\x56\x49", "mv" },
    {  4, "\x4D\x4D\x4D\x44", "mmf" },
    {  4, "\x4D\x4D\x00\x2B", "tif" },
    {  4, "\x4D\x4D\x00\x2A", "tif" },
    {  4, "\x4D\x4C\x53\x57", "mls" },
    {  4, "\x4D\x48\x57\x4B", "mhk" },
    {  4, "\x4D\x43\x44\x46", "dxm" },
    {  4, "\x4D\x41\x52\x43", "mar" },
    {  4, "\x4D\x41\x49\x4E", "mpf" },
    {  4, "\x4D\x41\x43\x20", "ape" },
    {  4, "\x4D\x36\x34\x1A", "m64" },
    {  4, "\x4C\xDC\x1D\x64", "b" },
    {  4, "\x4C\x5A\x58\x00", "lzx" },
    {  4, "\x4C\x5A\x49\x50", "lz" },
    {  4, "\x4C\x59\x52\x32", "lyr" },
    {  4, "\x4C\x57\x53\x43", "lws" },
    {  4, "\x4C\x50\x41\x43", "pac" },
    {  4, "\x4C\x49\x56\x45", "" },
    {  4, "\x4C\x48\x56\x4D", "chl" },
    {  4, "\x4C\x41\x30\x34", "la" },
    {  4, "\x4C\x41\x30\x33", "la" },
    {  4, "\x4C\x41\x30\x32", "la" },
    {  4, "\x4B\x53\x56\x31", "ksv" },
    {  4, "\x4B\x4F\x52\x47", "pcg" },
    {  4, "\x4B\x4D\x80\x00", "chn" },
    {  4, "\x4B\x4C\x73\x77", "key" },
    {  4, "\x4B\x45\x58\x53", "kxs" },
    {  4, "\x4B\x44\x4D\x56", "vmdk" },
    {  4, "\x4B\x44\x48\x20", "kdh" },
    {  4, "\x4A\x5A\x4A\x5A", "zjs" },
    {  4, "\x4A\x52\x32\x00", "jr2" },
    {  4, "\x4A\x49\x47\x43", "jig" },
    {  4, "\x4A\x44\x46\x20", "npl" },
    {  4, "\x4A\x44\x42\x47", "jdbg" },
    {  4, "\x49\x57\x43\x01", "iwc" },
    {  4, "\x49\x57\x41\x44", "wad" },
    {  4, "\x49\x54\x53\x46", "chm" },
    {  4, "\x49\x53\x63\x28", "hdr" },
    {  4, "\x49\x52\x45\x5A", "gm" },
    {  4, "\x49\x4D\x50\x4D", "it" },
    {  4, "\x49\x4D\x50\x0A", "imp" },
    {  4, "\x49\x4C\x44\x41", "ild" },
    {  4, "\x49\x49\x2A\x00", "tif" },
    {  4, "\x49\x46\x58\x00", "w3d" },
    {  4, "\x49\x44\x53\x54", "mdl" },
    {  4, "\x49\x44\x53\x50", "spr" },
    {  4, "\x49\x44\x3B\x50", "slk" },
    {  4, "\x49\x44\x33\x03", "mp3" },
    {  4, "\x49\x42\x4D\x01", "mbi" },
    {  4, "\x49\x42\x4C\x4B", "cin" },
    {  4, "\x49\x42\x4B\x1A", "ibk" },
    {  4, "\x48\x53\x4D\x44", "dmz" },
    {  4, "\x48\x4D\x33\x57", "w3m" },
    {  4, "\x48\x45\x53\x4D", "hes" },
    {  4, "\x48\x44\x4F\x43", "hyp" },
    {  4, "\x48\x41\x50\x49", "hpi" },
    {  4, "\x47\x59\x4D\x58", "gym" },
    {  4, "\x47\x53\x50\x34", "gsp" },
    {  4, "\x47\x53\x43\x4E", "gsn" },
    {  4, "\x47\x52\x55\x53", "rus" },
    {  4, "\x47\x52\x49\x42", "grb" },
    {  4, "\x47\x4E\x54\x4D", "nm2" },
    {  4, "\x47\x4D\x56\x00", "gir" },
    {  4, "\x47\x4D\x4F\x56", "gmv" },
    {  4, "\x47\x4D\x42\x55", "cap" },
    {  4, "\x47\x45\x4B\x56", "peg" },
    {  4, "\x47\x44\x42\x00", "gdb" },
    {  4, "\x47\x43\x41\x58", "gca" },
    {  4, "\x47\x42\x58\x06", "gbx" },
    {  4, "\x47\x42\x53\x01", "gbs" },
    {  4, "\x47\x42\x4F\x58", "gbx" },
    {  4, "\x47\x42\x48\x44", "egp" },
    {  4, "\x47\x41\x4D\x45", "gam" },
    {  4, "\x46\x7A\x7A\x58", "" },
    {  4, "\x46\x58\x53\x4D", "fxm" },
    {  4, "\x46\x57\x4D\x50", "fw" },
    {  4, "\x46\x53\x50\x41", "psf" },
    {  4, "\x46\x53\x4D\xFE", "fsm" },
    {  4, "\x46\x53\x42\x33", "fsb" },
    {  4, "\x46\x52\x41\x43", "car" },
    {  4, "\x46\x50\x54\xFE", "fpt" },
    {  4, "\x46\x50\x52\x54", "fpr" },
    //{  4, "\x46\x4F\x52\x4D", "amff" },
    {  4, "\x46\x4F\x52\x34", "iff" },
    {  4, "\x46\x4E\x54\x46", "ffn" },
    {  4, "\x46\x4D\x56\x1A", "fmv" },
    {  4, "\x46\x4C\x53\x48", "cfg" },
    {  4, "\x46\x49\x4C\x4D", "film" },
    {  4, "\x46\x47\x52\x4B", "ovl" },
    {  4, "\x46\x46\x46\x46", "fff" },
    {  4, "\x46\x43\x2D\x4D", "fcm" },
    {  4, "\x46\x43\x00\x00", "" },
    {  4, "\x46\x42\x31\x20", "fr" },
    {  4, "\x46\x41\x52\xFE", "far" },
    {  4, "\x46\x33\x44\x31", "f3d" },
    {  4, "\x45\x59\x42\x24", "eyb" },
    {  4, "\x45\x58\x50\x20", "e00" },
    {  4, "\x45\x53\x50\x3E", "esp" },
    {  4, "\x45\x52\x55\x50", "" },
    {  4, "\x45\x50\x46\x48", "lpd" },
    {  4, "\x45\x4E\x42\x30", "enb" },
    {  4, "\x45\x4D\x4F\x44", "emd" },
    {  4, "\x45\x4A\x50\x30", "ejp" },
    {  4, "\x45\x47\x33\x32", "egr" },
    {  4, "\x45\x46\x47\x20", "efg" },
    {  4, "\x45\x43\x4D\x00", "ecm" },
    {  4, "\x45\x43\x4C\x57", "ecw" },
    {  4, "\x44\x5A\x02\x09", "dz" },
    {  4, "\x44\x54\x4C\x47", "log" },
    {  4, "\x44\x53\x6D\x1A", "dsm" },
    {  4, "\x44\x50\x4F\x47", "pog" },
    {  4, "\x44\x50\x47\x30", "dpg" },
    {  4, "\x44\x4D\x53\x21", "dms" },
    {  4, "\x44\x4C\x49\x42", "dcf" },
    {  4, "\x44\x4C\x43\x30", "dlc" },
    {  4, "\x44\x47\x43\x41", "dgc" },
    {  4, "\x44\x45\x53\x53", "" },
    {  4, "\x44\x45\x4D\x50", "dem" },
    {  4, "\x44\x44\x55\x56", "4db" },
    {  4, "\x44\x44\x53\x20", "dds" },
    {  4, "\x44\x44\x4D\x46", "dmf" },
    {  4, "\x44\x42\x50\x46", "package" },
    {  4, "\x44\x42\x46\x48", "db" },
    {  4, "\x44\x41\x58\x00", "dax" },
    {  4, "\x43\x5A\x49\x50", "czip" },
    {  4, "\x43\x54\x4D\x46", "cmf" },
    //{  4, "\x43\x52\x45\x47", "dat" },
    {  4, "\x43\x50\x43\xB2", "cpc" },
    {  4, "\x43\x4F\x4E\x5F", "" },
    {  4, "\x43\x4F\x4D\x2B", "clb" },
    {  4, "\x43\x4F\x4C\x4C", "col" },
    {  4, "\x43\x49\x53\x4F", "cso" },
    {  4, "\x43\x41\x53\x4C", "csp" },
    {  4, "\x42\x53\x56\x01", "bootskin" },
    {  4, "\x42\x52\x4F\x43", "pvn" },
    {  4, "\x42\x4F\x41\x00", "boa" },
    {  4, "\x42\x4D\xCB\x03", "vbm" },
    {  4, "\x42\x4D\x44\x0A", "bmd" },
    {  4, "\x42\x4C\x50\x32", "blp" },
    {  4, "\x42\x4C\x50\x31", "blp" },
    {  4, "\x42\x49\x4B\x69", "bik" },
    {  4, "\x42\x49\x47\x46", "big" },
    {  4, "\x42\x44\x69\x63", "bdic" },
    {  4, "\x41\x75\x74\x53", "aus" },
    {  4, "\x41\x75\x74\x52", "aur" },
    {  4, "\x41\x72\x43\x01", "arc" },
    {  4, "\x41\x6D\x42\x6B", "abk" },
    {  4, "\x41\x59\x4D\x30", "aym" },
    {  4, "\x41\x57\x42\x4D", "bmp" },
    {  4, "\x41\x54\x46\x09", "gal" },
    {  4, "\x41\x52\x44\x53", "duc" },
    {  4, "\x41\x50\x54\x00", "airports" },
    {  4, "\x41\x50\x41\x43", "apc" },
    {  4, "\x41\x50\x21\x00", "ap" },
    {  4, "\x41\x4E\x42\x52", "anb" },
    {  4, "\x41\x4C\x5A\x01", "alz" },
    {  4, "\x41\x4C\x44\x4F", "aeh" },
    {  4, "\x41\x49\x43\x0A", "aic" },
    {  4, "\x41\x43\x33\x44", "ac" },
    {  4, "\x41\x43\x31\x30", "dwg" },
    {  4, "\x41\x42\x49\x46", "ab1" },
    {  4, "\x40\x43\x54\x20", "602" },
    //{  4, "\x3F\x5F\x03\x00", "gid" },
    {  4, "\x3F\x4C\x44\x32", "ld2" },
    {  4, "\x3F\x32\x32\x33", "aza" },
    {  4, "\x3C\x21\x2D\x2D", "wdproj" },
    {  4, "\x3B\x50\x6F\x73", "xpf" },
    {  4, "\x37\x04\x10\x00", "ark" },
    {  4, "\x37\x00\x00\x10", "mbm" },
    {  4, "\x33\x67\x6D\x49", "img3" },
    {  4, "\x33\x41\x4E\x1A", "dat" },
    {  4, "\x32\x49\x4D\x47", "2img" },
    {  4, "\x31\x6B\x61\x70", "pak" },
    {  4, "\x31\x67\x69\x4D", "mig" },
    {  4, "\x2F\x2F\x2B\x2D", "mq4" },
    {  4, "\x2E\x52\x4D\x58", "rmx" },
    {  4, "\x2E\x4D\x44\x50", "mdp" },
    {  4, "\x2E\x4D\x44\x41", "mda" },
    {  4, "\x2D\xED\x0D\x0A", "pyc" },
    {  4, "\x2A\xEB\x0D\x0A", "pyc" },
    {  4, "\x2A\x74\x73\x74", "tst" },
    {  4, "\x2A\x2A\x54\x49", "" },
    {  4, "\x28\xCD\x3D\x45", "cmg" },
    {  4, "\x27\x06\xA4\xD0", "caf" },
    {  4, "\x25\x4F\x50\x25", "pd" },
    {  4, "\x25\x04\x19\x69", "spc" },
    {  4, "\x24\x52\x58\x4E", "rxn" },
    {  4, "\x23\x56\x42\x44", "mw4" },
    {  4, "\x23\x50\x48\x43", "phc" },
    {  4, "\x22\xCC\x31\x5D", "b" },
    {  4, "\x21\x42\x4D\x41", "bma" },
    //{  4, "\x21\x42\x44\x4E", "ost" },
    {  4, "\x21\x00\x25\x00", "mxd" },
    {  4, "\x20\x77\x00\x02", "cbd" },
    {  4, "\x20\x20\x00\x00", "vz" },
    {  4, "\x1F\x8B\x08\x08", "kpr" },
    {  4, "\x1F\x8B\x08\x00", "pdn" },
    {  4, "\x1E\xF1\xD0\xBA", "npk" },
    {  4, "\x1E\x00\x00\x00", "opy" },
    {  4, "\x1C\x01\x00\x00", "btr" },
    {  4, "\x1B\x4C\x75\x61", "out" },
    {  4, "\x1A\x48\x50\x25", "hyp" },
    {  4, "\x1A\x46\x44\x4D", "fdm" },
    {  4, "\x14\x46\x49\x47", "fig" },
    {  4, "\x13\x50\x4E\x54", "pnt" },
    {  4, "\x10\x43\x4C\x50", "clp" },
    {  4, "\x10\x00\x00\x00", "cl5" },
    {  4, "\x0E\x57\x4B\x53", "wks" },
    {  4, "\x0D\x44\x4F\x43", "doc" },
    {  4, "\x0C\x53\x4E\x47", "sng" },
    {  4, "\x0A\x47\x4C\x02", "blu" },
    {  4, "\x09\x28\x90\x1B", "rep" },
    {  4, "\x07\x53\x4B\x46", "skf" },
    {  4, "\x06\x00\x47\x53", "btg" },
    {  4, "\x05\x6C\x00\x20", "dig" },
    {  4, "\x05\x04\x05\x01", "mpz" },
    {  4, "\x03\x64\x73\x73", "dss" },
    {  4, "\x03\x53\x4B\x46", "sks" },
    {  4, "\x03\x4A\x42\x4F", "tbk" },
    {  4, "\x03\x46\x49\x4C", "fil" },
    {  4, "\x03\x31\x2E\x34", "akm" },
    {  4, "\x03\x00\x00\x00", "nfc" },
    {  4, "\x02\xD6\xEB\xF8", "egisenc" },
    {  4, "\x02\x64\x73\x73", "dss" },
    {  4, "\x02\x00\x00\x00", "sdb" },
    {  4, "\x01\xCA\x50\x04", "plan" },
    {  4, "\x01\x09\xFF\xFE", "fxo" },
    {  4, "\x01\x00\x39\x30", "fdb" },
    {  4, "\x01\x00\x00\x00", "vap" },
    {  4, "\x00\x50\x54\x46", "ptf" },
    {  4, "\x00\x50\x53\x46", "psf" },
    {  4, "\x00\x4D\x52\x4D", "mrw" },
    {  4, "\x00\x10\xBA\xBA", "tpp" },
    {  4, "\x00\x0C\x00\x00", "ctw" },
    {  4, "\x00\x05\x43\x52", "pbr" },
    {  4, "\x00\x05\x16\x07", "ad" },
    {  4, "\x00\x05\x16\x00", "as" },
    {  4, "\x00\x01\x42\x44", "dba" },
    {  4, "\x00\x01\x42\x41", "aba" },
    {  4, "\x00\x00\xFE\xFF", "txt" },
    {  4, "\x00\x00\x80\x00", "m99" },
    {  4, "\x00\x00\x01\xBA", "vob" },
    {  4, "\x00\x00\x01\x00", "ico" },
    {  4, "\x00\x00\x00\x00", "neo" },
    {  3, "\xFF\xFF\xFF", "fnc" },
    {  3, "\xFF\xFB\x90", "mp3" },
    {  3, "\xFF\xFB\x30", "mp3" },
    {  3, "\xFF\xD8\xFF", "jpg" },
    {  3, "\xFF\x0A\x00", "qrp" },
    {  3, "\xFB\xEE\x28", "txt" },
    {  3, "\xEF\xBB\xBF", "txt" },
    {  3, "\xEB\xFE\x90", "dsk" },
    {  3, "\xCB\x0A\x01", "wp" },
    {  3, "\xBA\xBA\xFF", "mny" },
    {  3, "\xAD\x36\x22", "oop" },
    {  3, "\x8F\x81\x01", "wpt" },
    {  3, "\x81\x8A\x32", "bmf" },
    {  3, "\x81\x8A\x31", "bmf" },
    {  3, "\x7A\x50\x51", "zpaq" },
    {  3, "\x78\x01\xEC", "aswcs" },
    {  3, "\x76\xFF\x31", "" },
    {  3, "\x74\x64\x00", "td0" },
    {  3, "\x73\x6D\x5F", "pdb" },
    {  3, "\x73\x6C\x68", "dat" },
    {  3, "\x73\x52\x02", "sr2" },
    {  3, "\x6E\x66\x66", "nff" },
    {  3, "\x64\x6E\x6C", "m4" },
    {  3, "\x61\x70\x74", "apt" },
    {  3, "\x5D\x00\x00", "lzma" },
    {  3, "\x5A\x5A\x31", "zz" },
    {  3, "\x5A\x4F\x54", "zot" },
    {  3, "\x5A\x4E\x4F", "zno" },
    {  3, "\x5A\x4D\x56", "zmv" },
    {  3, "\x5A\x49\x58", "zix" },
    {  3, "\x59\x42\x53", "ybs" },
    {  3, "\x56\x69\x58", "vix" },
    {  3, "\x56\x69\x47", "max" },
    {  3, "\x56\x49\x30", "vi" },
    {  3, "\x55\x4E\x30", "uni" },
    {  3, "\x54\x54\x41", "tta" },
    {  3, "\x54\x53\x52", "dmf" },
    {  3, "\x54\x50\x53", "psm" },
    {  3, "\x54\x48\x58", "ahx" },
    {  3, "\x54\x48\x52", "thr" },
    {  3, "\x54\x44\x00", "td0" },
    {  3, "\x53\x52\x56", "prefs" },
    {  3, "\x53\x50\x52", "spr" },
    {  3, "\x53\x50\x4A", "spj" },
    {  3, "\x53\x4D\x4B", "smk" },
    {  3, "\x53\x42\x49", "sbi" },
    {  3, "\x52\x4B\x41", "rka" },
    {  3, "\x52\x45\x53", "res" },
    {  3, "\x51\x52\x42", "query" },
    {  3, "\x51\x43\x46", "qcf" },
    {  3, "\x50\x53\x59", "psy" },
    {  3, "\x50\x50\x46", "ppf" },
    {  3, "\x50\x4B\x03", "sdt" },
    {  3, "\x50\x47\x01", "pgf" },
    {  3, "\x50\x41\x58", "pax" },
    {  3, "\x50\x36\x0A", "pnm" },
    {  3, "\x50\x35\x0A", "pgm" },
    {  3, "\x50\x34\x0A", "pbm" },
    {  3, "\x50\x00\x00", "czd" },
    {  3, "\x4E\x53\x4B", "nsk" },
    {  3, "\x4E\x47\x47", "ngg" },
    {  3, "\x4D\x54\x4D", "mtm" },
    {  3, "\x4D\x50\x2B", "mpc" },
    {  3, "\x4D\x4D\x44", "med" },
    {  3, "\x4D\x4C\x42", "mlb" },
    {  3, "\x4D\x44\x4C", "mdl" },
    {  3, "\x4C\x41\x3A", "dst" },
    {  3, "\x4B\x44\x4D", "vmdk" },
    {  3, "\x4B\x30\x00", "kts" },
    {  3, "\x49\x49\xBC", "hdp" },
    {  3, "\x49\x49\x52", "orf" },
    {  3, "\x49\x44\x3D", "pna" },
    {  3, "\x49\x44\x33", "atp" },
    {  3, "\x47\x54\x32", "gt2" },
    {  3, "\x47\x52\x5A", "grz" },
    {  3, "\x47\x4E\x4D", "gnm" },
    {  3, "\x47\x49\x46", "gif" },
    {  3, "\x46\x57\x53", "swf" },
    {  3, "\x46\x57\x44", "swd" },
    {  3, "\x46\x49\x4E", "fp" },
    {  3, "\x46\x49\x46", "fif" },
    {  3, "\x46\x44\x49", "fdi" },
    {  3, "\x44\x56\x52", "dvr" },
    {  3, "\x44\x56\x4D", "dvm" },
    {  3, "\x44\x4F\x53", "adf" },
    {  3, "\x44\x48\x46", "hog" },
    {  3, "\x44\x43\x41", "dca" },
    {  3, "\x43\x44\x46", "nc" },
    {  3, "\x42\x65\x65", "bee" },
    { -1, "BZh91AY&SY", "bz2" },
    {  3, "\x42\x57\x54", "b5t" },
    {  3, "\x41\x57\x44", "awd" },
    {  3, "\x41\x56\x5A", "pva" },
    {  3, "\x41\x53\x44", "asd" },
    {  3, "\x41\x47\x44", "" },
    {  3, "\x41\x46\x46", "aff" },
    {  3, "\x3C\x2D\x2D", "tmpl" },
    {  3, "\x37\x37\x37", "777" },
    {  3, "\x2F\x33\x2E", "apr" },
    {  3, "\x2B\x2F\x76", "txt" },
    {  3, "\x24\x47\x50", "nmea" },
    {  3, "\x1F\x9D\x90", "z" },
    {  3, "\x1F\x8B\x08", "gz" },
    {  3, "\x13\x00\x00", "tap" },
    {  3, "\x12\x34\x00", "bdc" },
    {  3, "\x0E\xFE\xFF", "txt" },
    {  3, "\x0E\x0F\x00", "msa" },
    {  3, "\x02\x14\x01", "" },
    {  3, "\x00\xC0\x4C", "ldr" },
    {  3, "\x00\xAB\xCD", "vc6" },
    {  3, "\x00\x3F\x00", "cgm" },
    {  3, "\x00\x05\x16", "webloc" },
    {  3, "\x00\x01\x01", "flt" },
    {  3, "\x00\x01\x00", "img" },
    //{  2, "\xFF\xFF", "zzt" },
    //{  2, "\xFF\xFE", "prx" },
    {  2, "\xFF\xFB", "mp3" },
    {  2, "\xFF\xF1", "aac" },
    {  2, "\xFE\xFF", "txt" },
    {  2, "\xFE\xF2", "app" },
    {  2, "\xFE\x37", "mcw" },
    {  2, "\xFE\x01", "frm" },
    {  2, "\xFD\xFF", "mdl" },
    {  2, "\xEC\xBD", "gax" },
    {  2, "\xEB\x0A", "com" },
    //{  2, "\xEA\x02", "pea" },
    //{  2, "\xEA\x01", "pea" },
    //{  2, "\xE0\x01", "scd" },
    //{  2, "\xDC\xFE", "efx" },
    //{  2, "\xDC\xDC", "cpl" },
    //{  2, "\xDA\x35", "" },
    //{  2, "\xD0\x0B", "kdb" },
    //{  2, "\xCD\x07", "tvc" },
    //{  2, "\xC0\x45", "" },
    //{  2, "\xAC\xED", "pumpkin" },
    //{  2, "\xA4\x93", "dur" },
    //{  2, "\x80\x00", "adx" },
    //{  2, "\x7E\x56", "las" },
    //{  2, "\x79\x7A", "yz1" },
    //{  2, "\x78\xDA", "piv" },
    //{  2, "\x76\x20", "obj" },
    //{  2, "\x70\x51", "lpaq" },
    //{  2, "\x69\x66", "669" },
    //{  2, "\x64\x00", "sor" },
    //{  2, "\x60\xEA", "arj" },
    //{  2, "\x60\x1A", "tos" },
    //{  2, "\x60\x00", "bd" },
    //{  2, "\x57\x61", "c3d" },
    //{  2, "\x57\x57", "gsm" },
    //{  2, "\x55\x4E", "edi" },
    {  2, "\x4D\x5A", "dll" },
    {  2, "\x4D\x4D", "3ds" },
    //{  2, "\x4D\x02", "edb" },
    //{  2, "\x4C\x53", "srf" },
    //{  2, "\x4C\x41", "la" },
    {  2, "\x4B\x46", "cdw" },
    //{  2, "\x4A\x4E", "669" },
    {  2, "\x49\x43", "smi" },
    {  2, "\x48\xE7", "dz" },
    //{  2, "\x48\x41", "ha" },
    //{  2, "\x46\x52", "ice" },
    {  2, "\x45\x50", "mdi" },
    {  2, "\x44\x53", "q" },
    //{  2, "\x44\x4C", "exm" },
    //{  2, "\x43\x4D", "cmmf" },
    {  2, "\x42\x4D", "bmp" },
    {  2, "\x42\x41", "ico" },
    //{  2, "\x41\x56", "pva" },
    //{  2, "\x41\x54", "trc" },
    //{  2, "\x41\x50", "apw" },
    {  2, "\x3C\x4D", "mv" },
    //{  2, "\x3C\x3C", "joboptions" },
    //{  2, "\x3C\x21", "htm" },
    {  2, "\x34\x12", "pic" },
    //{  2, "\x30\x20", "ldr" },
    //{  2, "\x2F\x2F", "mup" },
    {  2, "\x2F\x2A", "txt" },
    {  2, "\x23\x21", "sh" },
    //{  2, "\x21\x2A", "sqr" },
    {  2, "\x1B\x5B", "ans" },
    {  2, "\x1B\x4B", "nec" },
    //{  2, "\x10\x00", "idx" },
    //{  2, "\x0B\x23", "fxr" },
    //{  2, "\x08\x00", "sdb" },
    //{  2, "\x01\xFF", "drw" },
    //{  2, "\x01\x50", "blob" },
    //{  2, "\x01\x01", "csp" },
    //{  2, "\x01\x00", "els" },
    //{  2, "\x00\xBF", "sol" },
    //{  2, "\x00\x7D", "ast" },
    //{  2, "\x00\x58", "drz" },
    //{  2, "\x00\x08", "ens" },
    //{  2, "\x00\x00", "als" },
    {  9, "\x81\x81\x02\x00\x02\x00\x07\x01\x04", "avb" },
    { 10, "\x81\x81\x03\x00\x02\x00\x07\x01\x04\x00", "bgb" },
    { 10, "\x3B\x20\x68\x65\x6C\x70\x2E\x68\x70\x66", "hpf" },
    { 14, "\x4C\x44\x42\x58\x00\x01\x01\x00\x00\x00\x00\x20\x00\x00", "ldb" },
    {  5, "\x54\x56\x44\x42\x27", "log" },
    {  5, "\x99\x01\xA2\x04\x3C", "pkr" },
    { 10, "\x3C\x68\x74\x6D\x6C\x3E\x0D\x0A\x3C\x62", "plg" },
    {  5, "\x95\x01\xCF\x04\x36", "skr" },
    { 10, "\x74\x57\x62\x63\x00\x00\x00\x00\x00\x00", "syd" },
    {  4, "\x53\x5A\x44\x44", "??_" },
    {  4, "\x4B\x57\x41\x4A", "??_" },
    {  2, "\x60\xEA", "arj" },
    {  3, "\x42\x41\x47", "bag" },
    {  3, "\x42\x5A\x68", "bz" },
    {  4, "\x4D\x53\x43\x46", "cab" },
    {  4, "\x4D\x4D\x53\x20", "ckit" },
    {  6, "\x30\x37\x30\x37\x30\x37", "cpio" },
    {  5, "\x43\x52\x55\x53\x48", "cru" },
    {  2, "\x48\x41", "ha" },
    { 10, "\x28\x54\x68\x69\x73\x20\x66\x69\x6C\x65", "hqx" },
    {  4, "\x5F\x27\xA8\x89", "jar" },
    {  5, "\x2D\x6C\x68\x35\x2D", "lha" },
    {  8, "\x52\x61\x72\x21\x1A\x07\x00\x3B", "rar" },
    {  4, "\x53\x49\x54\x21", "sit" },
    {  7, "\x53\x74\x75\x66\x66\x49\x74", "sit" },
    {  5, "\x48\x4C\x53\x51\x5A", "sqz" },
    {  9, "\x41\x70\x70\x20\x4E\x61\x6D\x65\x09", "stf" },
    {  3, "\x55\x46\x41", "ufa" },
    {  8, "\x78\x63\x72\x20\x46\x69\x6C\x65", "xcr" },
    {  4, "\x2E\x73\x6E\x64", "au" },
    {  7, "\x4D\x50\x33\x44\x41\x54\x41", "m3d" },
    {  4, "\x4D\x54\x68\x64", "mid" },
    {  4, "\x2E\x72\x61\xFD", "ram" },
    {  4, "\x2E\x52\x4D\x46", "rm" },
    {  8, "\x53\x54\x45\x56\x45\x02\x48\x80", "snd" },
    { 20, "\x43\x72\x65\x61\x74\x69\x76\x65\x20\x56\x6F\x69\x63\x65\x20\x46\x69\x6C\x65\x1A", "voc" },
    {  4, "\x52\x49\x46\x46", "wav" },
    {  4, "\x3B\x0D\x0A\x3B", "asm" },
    {  7, "\x00\x00\x00\x0C\x00\x00\x00", "atn" },
    { 10, "\x40\x65\x63\x68\x6F\x20\x6F\x66\x66\x0D", "btm" },
    { 10, "\x23\x21\x2F\x62\x69\x6E\x2F\x73\x68\x0A", "cgi" },
    { 10, "\x2F\x2A\x20\x2A\x20\x2A\x20\x2A\x20\x2A", "h" },
    { 10, "\x48\x4F\xF3\xC9\x76\x33\x2E\x39\x39\x2E", "obs" },
    { 10, "\x56\x43\x50\x43\x48\x30\x00\x00\x00\x00", "pch" },
    { 10, "\x00\x00\x01\x00\x00\x00\x01\x48\x00\x00", "rsc" },
    {  2, "\xDC\xFE", "efx" },
    {  4, "\x03\x63\x08\x0A", "dbf" },
    { 10, "\x00\x01\x00\x00\x53\x74\x61\x6E\x64\x61", "mdb" },
    { 10, "\x00\x00\x00\x41\x42\x43\x00\x00\x00\x00", "abc" },
    //{  8, "\x51\x57\x20\x56\x65\x72\x2E\x20", "abd" },
    {  7, "\x30\x00\x00\x04\x15\x05\x05", "adx" },
    { 10, "\x25\x21\x50\x53\x2D\x41\x64\x6F\x62\x65", "ai" },
    {  2, "\x50\x08", "app" },
    { 10, "\x49\x54\x53\x46\x03\x00\x00\x00\x60\x00", "chm" },
    {  7, "\x46\x41\x58\x43\x4F\x56\x45", "cpe" },
    //{  8, "\xD0\xCF\x11\xE0\xA1\xB1\x1A\xE1", "doc" },
    { 10, "\x50\x4B\x03\x04\x14\x00\x00\x00\x00\x00", "doc" },
    {  8, "\x31\xBE\x00\x00\x00\xAB\x00\x00", "doc" },
    {  6, "\x12\x34\x56\x78\x90\xFF", "doc" },
    {  4, "\x7F\xFE\x34\x0A", "doc" },
    {  8, "\x4D\x47\x58\x20\x69\x74\x70\x64", "ds4" },
    { 10, "\x4D\x56\x00\xFF\x0C\x00\x10\x00\x00\x00", "dst" },
    {  8, "\x3C\x21\x45\x4E\x54\x49\x54\x59", "dtd" },
    {  8, "\x00\x00\x1A\x00\x07\x80\x01\x00", "fm3" },
    {  5, "\x20\x00\x68\x00\x20", "fmt" },
    {  6, "\x3C\x68\x74\x6D\x6C\x3E", "htm" },
    {  6, "\x3C\x48\x54\x4D\x4C\x3E", "htm" },
    {  6, "\x3C\x21\x44\x4F\x43\x54", "htm" },
    {  6, "\x1A\x00\x00\x03\x00\x00", "nsf" },
    { 10, "\x1A\x00\x00\x03\x00\x00\x11\x00\x01\x00", "ntf" },
    { 14, "\x25\x50\x44\x46\x2D\x31\x2E\x32\x0D\x0A\x25\xE2\xE3\xCF", "pdf" },
    {  4, "\xAC\x9E\xBD\x8F", "qdf" },
    { 14, "\xD0\xCF\x11\xE0\xA1\xB1\x1A\xE1\x00\x00\x00\x00\x00\x00", "sdw" },
    { 10, "\xC3\x54\x56\x53\x62\xBD\x8A\xFF\x00\x00", "tv4" },
    //{  5, "\x20\x00\x60\x40\x60", "wk1" },
    {  8, "\x00\x00\x1A\x00\x00\x10\x04\x00", "wk3" },
    {  8, "\x00\x00\x1A\x00\x02\x10\x04\x00", "wk4" },
    {  6, "\x00\x00\x1A\x00\x10\x04", "wks" },
    {  5, "\x20\x00\x60\x40\x60", "wks" },
    //{  4, "\xFF\x57\x50\x43", "wp" },
    {  9, "\x09\x08\x08\x00\x00\x05\x00\x04\x33", "xlb" },
    {  8, "\x09\x04\x06\x00\x00\x00\x40\x00", "xlm" },
    { 12, "\x09\x02\x06\x00\x00\x00\x10\x00\xB9\x04\x5C\x00", "xls" },
    { 12, "\x09\x04\x06\x00\x00\x00\x10\x00\xF6\x05\x5C\x00", "xls" },
    { 19, "\xFF\xFE\x3C\x00\x52\x00\x4F\x00\x4F\x00\x54\x00\x53\x00\x54\x00\x55\x00\x42", "xml" },
    //{  5, "\x3C\x3F\x78\x6D\x6C", "xml" },
    {  2, "\x3D\x02", "3d2" },
    {  4, "\x33\x44\x4D\x46", "3dmf" },
    { 14, "\x2A\x2A\x54\x49\x39\x32\x2A\x2A\x01\x00\x58\x6E\x56\x69", "92i" },
    {  7, "\x4A\x47\x04\x0E\x00\x00\x00", "art" },
    {  7, "\x4A\x47\x03\x0E\x00\x00\x00", "art" },
    {  9, "\xBB\x01\x00\x01\xC8\x00\xC8\x00\x01", "brk" },
    {  4, "\x07\x20\x4D\x4D", "cam" },
    {  4, "\x45\x59\x45\x53", "ce1" },
    { 14, "\x80\x2A\x5F\xD7\x00\x00\x08\x00\x00\x00\x04\x00\x00\x00", "cin" },
    {  8, "\x43\x61\x6C\x69\x67\x61\x72\x69", "cob" },
    {  7, "\x43\x50\x54\x46\x49\x4C\x45", "cpt" },
    {  4, "\x3A\xDE\x68\xB1", "dcx" },
    {  3, "\x42\x4D\x36", "dib" },
    {  4, "\x53\x44\x50\x58", "dpx" },
    {  6, "\x01\xFF\x02\x04\x03\x02", "drw" },
    {  4, "\x65\x02\x01\x02", "ecw" },
    {  8, "\x01\x00\x00\x00\x58\x00\x00\x00", "emf" },
    {  9, "\xD0\xCF\x11\xE0\xA1\xB1\x1A\xE1\x00", "fpx" },
    {  9, "\x53\x49\x4D\x50\x4C\x45\x20\x20\x3D", "fts" },
    {  4, "\x47\x49\x46\x38", "gif" },
    { 10, "\x48\x50\x48\x50\x34\x38\x2D\x45\x1E\x2B", "gro" },
    {  5, "\x6E\x63\x6F\x6C\x73", "hdr" },
    { 14, "\x35\x4B\x50\x35\x31\x5D\x2A\x67\x72\x72\x80\x83\x85\x63", "hru" },
    {  4, "\xEB\x3C\x90\x2A", "img" },
    {  4, "\x65\x6C\x6D\x6F", "infini-d" },
    {  7, "\x80\x3E\x44\x53\x43\x49\x4D", "j6i" },
    { 12, "\x00\x00\x00\x0C\x6A\x50\x20\x20\x0D\x0A\x87\x0A", "jp2" },
    {  4, "\xFF\xD8\xFF\xE1", "jpg" },
    {  4, "\xFF\xD8\xFF\xE0", "jpg" },
    { 14, "\xFF\xD8\xFF\xE1\x4E\xD8\x45\x78\x69\x66\x00\x00\x49\x49", "jpg" },
    //{  4, "\x4D\x4D\x00\x2A", "kdc" },
    { 13, "\x36\x34\x4C\x41\x4E\x20\x49\x44\x42\x4C\x4F\x43\x4B", "l64" },
    {  4, "\x46\x4F\x52\x4D", "lbm" },
    { 14, "\x49\x49\x2A\x00\x08\x00\x00\x00\x0E\x00\x00\x01\x04\x00", "ldf" },
    {  8, "\x57\x56\x02\x00\x47\x45\x00\x0E", "lwf" },
    { 14, "\x37\x00\x00\x10\x42\x00\x00\x10\x00\x00\x00\x00\x39\x64", "mbm" },
    {  3, "\x4D\x47\x4C", "mgl" },
    { 11, "\x7B\x0A\x20\x20\x43\x72\x65\x61\x74\x65\x64", "mif" },
    {  8, "\x8A\x4D\x4E\x47\x0D\x0A\x1A\x0A", "mng" },
    {  3, "\x4D\x50\x46", "mpw" },
    {  4, "\x44\x61\x6E\x4D", "msp" },
    {  3, "\x43\x36\x34", "n64" },
    {  6, "\x6E\x6E\x0A\x00\x5E\x00", "ncr" },
    {  6, "\x4E\x47\x47\x00\x01\x00", "ngg" },
    {  7, "\x4E\x4C\x4D\x20\x01\x02\x00", "nlm" },
    {  2, "\x41\x48", "pal" },
    {  8, "\x00\x00\x00\x20\x00\x00\x00\x01", "pat" },
    {  8, "\x63\x52\x01\x01\x38\x09\x3D\x00", "pcd" },
    { 14, "\x1B\x45\x1B\x26\x6C\x30\x4F\x1B\x26\x6C\x30\x45\x1B\x26", "pcl" },
    {  4, "\x0A\x05\x01\x08", "pcx" },
    {  2, "\x50\x32", "pgm" },
    {  6, "\x53\x80\xF6\x34\x40\x20", "pic" },
    {  8, "\x50\x49\x43\xDC\x30\x30\x01\x00", "pic" },
    {  2, "\x91\x19", "pic" },
    {  8, "\x89\x50\x4E\x47\x0D\x0A\x1A\x0A", "png" },
    {  4, "\x88\x9A\x0D\x12", "png" },
    {  4, "\x89\x9A\x0D\x12", "png" },
    { 10, "\x50\x4F\x4C\x20\x46\x6F\x72\x6D\x61\x74", "pol" },
    {  2, "\x50\x33", "ppm" },
    { 10, "\x38\x42\x50\x53\x00\x01\x00\x00\x00\x00", "psd" },
    { 25, "\x50\x61\x69\x6E\x74\x20\x53\x68\x6F\x70\x20\x50\x72\x6F\x20\x49\x6D\x61\x67\x65\x20\x46\x69\x6C\x65", "psp" },
    {  7, "\x51\x4C\x49\x49\x46\x41\x58", "qfx" },
    {  4, "\x6D\x6F\x6F\x76", "qtm" },
    {  7, "\x46\x4F\x52\x4D\x41\x54\x3D", "rad" },
    {  7, "\x23\x20\x24\x49\x64\x3A\x20", "sid" },
    { 13, "\x41\x75\x74\x6F\x43\x41\x44\x20\x53\x6C\x69\x64\x65", "slb" },
    {  7, "\x53\x74\x6F\x72\x6D\x33\x44", "sod" },
    {  3, "\x4D\x4D\x2A", "tif" },
    {  6, "\xFA\xDE\xBA\xBE\x01\x01", "wic" },
    {  4, "\xD7\xCD\xC6\x9A", "wmf" },
    {  5, "\xFF\x57\x50\x43\x10", "wpg" },
    { 10, "\x23\x56\x52\x4D\x4C\x20\x56\x32\x2E\x30", "wrl" },
    {  7, "\x23\x64\x65\x66\x69\x6E\x65", "xbm" },
    {  9, "\x2F\x2A\x20\x58\x50\x4D\x20\x2A\x2F", "xpm" },
    { 14, "\x43\x6C\x69\x65\x6E\x74\x20\x55\x72\x6C\x43\x61\x63\x68", "dat" },
    {  7, "\x55\x52\x4C\x20\x02\x00\x00", "dat" },
    {  7, "\x55\x52\x4C\x20\x03\x00\x00", "dat" },
    {  7, "\x5B\x50\x68\x6F\x6E\x65\x5D", "dun" },
    {  6, "\xCF\xAD\x12\xFE\xC5\xFD", "dbx" },
    { 21, "\x3C\x21\x64\x6F\x63\x74\x79\x70\x65\x20\x68\x74\x6D\x6C\x20\x70\x75\x62\x6C\x69\x63", "dci" },
    { 14, "\x52\x65\x74\x75\x72\x6E\x2D\x50\x61\x74\x68\x3A\x20\x3C", "eml" },
    {  7, "\x46\x72\x6F\x6D\x20\x2D\x20", "eml" },
    {  6, "\x46\x72\x6F\x6D\x3A\x20", "eml" },
    {  4, "\x21\x42\x44\x4E", "pst" },
    { 14, "\x00\x06\x15\x61\x00\x00\x00\x02\x00\x00\x04\xD2\x00\x00", "hst" },
    {  3, "\x57\x45\x42", "igy" },
    { 14, "\x57\x45\x42\x0D\x0A\x31\x0D\x0A\x68\x74\x74\x70\x3A\x2F", "iqy" },
    {  6, "\x5F\x43\x41\x53\x45\x5F", "cas" },
    {  3, "\xFE\xEF\x01", "gho" },
    { 20, "\x43\x36\x34\x53\x20\x74\x61\x70\x65\x20\x69\x6D\x61\x67\x65\x20\x66\x69\x6C\x65", "t64" },
    { 13, "\x43\x36\x34\x20\x43\x41\x52\x54\x52\x49\x44\x47\x45", "crt" },
    //{  4, "\xBA\xBE\xEB\xEA", "ani" },
    {  4, "\x4C\x50\x46\x20", "anm" },
    { 14, "\x30\x26\xB2\x75\x8E\x66\xCF\x11\xA6\xD9\x00\xAA\x00\x62", "asf" },
    {  4, "\x41\x56\x49\x20", "avi" },
    //{  4, "\x52\x49\x46\x46", "avi" },
    {  4, "\x56\x44\x56\x49", "avs" },
    //{  3, "\x44\x56\x4D", "dvm" },
    {  4, "\x52\x41\x4E\x44", "filmstrip" },
    {  2, "\xAF\x12", "flc" },
    {  4, "\x49\x4D\x44\x43", "ic1" },
    //{  6, "\x4C\x5A\x41\x4E\x49\x4D", "lza" },
    { 10, "\x07\x01\x01\x00\x43\x6F\x70\x79\x72\x69", "mmm" },
    {  8, "\x00\x00\x07\xB5\x6D\x6F\x6F\x76", "mov" },
    {  4, "\x6D\x64\x61\x74", "mov;qt" },
    {  4, "\x00\x00\x01\xB3", "mpeg" },
    //{  4, "\x52\x49\x46\x46", "ani" },
    //{  8, "\xB5\xA2\xB0\xB3\xB3\xB0\xA2\xB5", "cal" },
    //{  4, "\x52\x54\x53\x53", "cap" },
    //{  8, "\x4D\x53\x43\x46\x00\x00\x00\x00", "cdm" },
    {  7, "\x50\xC3\x01\x00\x08\x00\x28", "clp" },
    {  4, "\x43\x52\x45\x47", "dat" },
    {  5, "\x53\x48\x43\x43\x33", "dat" },
    { 10, "\x20\x20\x20\x20\x20\x20\x69\x6E\x74\x65", "fon" },
    //{  4, "\x3F\x5F\x03\x00", "gid" },
    //{  4, "\x50\x4D\x43\x43", "grp" },
    {  4, "\x3F\x5F\x03\x00", "hlp" },
    {  4, "\x4C\x4E\x02\x00", "hlp" },
    { 10, "\x48\x79\x70\x65\x72\x54\x65\x72\x6D\x69", "ht" },
    { 14, "\x5B\x45\x78\x74\x53\x68\x65\x6C\x6C\x46\x6F\x6C\x64\x65", "ini" },
    {  4, "\x47\x04\x01\x00", "job" },
    {  7, "\x7B\x0D\x0A\x6F\x20\x63\x31", "lgc" },
    {  8, "\x4C\x00\x00\x00\x01\x14\x02\x00", "lnk" },
    {  6, "\x4C\x54\x41\x52\x00\x01", "ltr" },
    { 10, "\x2A\x50\x50\x44\x2D\x41\x64\x6F\x62\x65", "ppd" },
    {  7, "\xE3\x82\x85\x96\x01\x00\x00", "pwl" },
    {  6, "\x0D\x0A\x5B\x53\x68\x65", "scf" },
    { 13, "\x3B\x0D\x0A\x3B\x20\x54\x68\x69\x73\x20\x69\x73\x20", "scp" },
    { 14, "\x4D\x5A\x90\x00\x03\x00\x00\x00\x04\x00\x00\x00\xFF\xFF", "scr" },
    {  5, "\x67\x49\x00\x00\x78", "shd" },
    {  4, "\x4B\x49\x00\x00", "shd" },
    //{  8, "\x52\x45\x47\x45\x44\x49\x54\x34", "sud" },
    {  8, "\xFF\x4B\x45\x59\x42\x20\x20\x20", "sys" },
    // possibly others
    {  4, "IDSV", "vvd" },
    {  4, "ERTM", "d3dtx" },
    {  4, "IDAG", "ani" },
    { -1 , "\r\nRez", "rez" },
    {  5, "Asura", "asr" },
    { 16, "\x07\x00\x00\x00\x18\x00\x00\x00\x35\x00\x09\x00\x03\x00\x00\x00", "vtx" },
    {  4, "PIFF", "vram" },
    {  4, "\xb8\x67\xb0\xca", "gr2" },
    //{  4, "\x1e\x00\x00\x00", "bsp" },
    { -1, "-----BEGIN", "pem" },
    {  8, "\xD0\xCF\x11\xE0\xA1\xB1\x1A\xE1", "msi" },
    { -1, "#!/usr/bin/", "sh" },
    // end of list
    { -1, NULL, NULL }
};



// from NetBSD
void *mymemmem(const void *b1, const void *b2, size_t len1, size_t len2) {
    unsigned char *sp  = (unsigned char *) b1;
    unsigned char *pp  = (unsigned char *) b2;
    unsigned char *eos = sp + len1 - len2;

    if(!(b1 && b2 && len1 && len2))
        return NULL;

    while (sp <= eos) {
        if (*sp == *pp)
            if (memcmp(sp, pp, len2) == 0)
                return sp;
        sp++;
    }
    return NULL;
}



#define MAX_EXT_CHECK   8
unsigned char *sign_ext(unsigned char *data, int datalen) {
    static char     last_ext[MAX_EXT_CHECK + 1] = "";
    sign_ext_db_t   *p;
    int             i;
    unsigned char   *t;
    char            tmp[256 + 1],
                    c;

    if(data) {
        if((datalen > 3) && !memcmp(data, "\xef\xbb\xbf", 3)) { // utf8
            data += 3;
            datalen -= 3;
        }
        if((datalen > 2) && !memcmp(data, "\xff\xfe", 2)) { // unicode to string
            data += 2;
            datalen -= 2;
            for(i = 0; i < (sizeof(tmp) - 1); i++) {
                c = *data++;
                if(!c) c = *data++;
                tmp[i] = c;
            }
            tmp[i] = 0;
            datalen = i;
            data = tmp;
        }
        if(datalen > MAX_EXT_CHECK) { // give it a minimum size
            for(p = sign_ext_db; p->sign; p++) {
                //if(!p->ext[0]) continue;  // never enable it
                if(p->signlen < 0) p->signlen = strlen(p->sign);    // automatic for later
                if(datalen >= p->signlen) {
                    if(!memcmp(data, p->sign, p->signlen)) {
                        if(!p->ext[0]) return("dat");
                        //t = strchr(p->ext, '/');  // for ext1/ext2
                        //if(t) *t = 0;   // automatic for later
                        //if(!stricmp(p->ext, "exe")) return("dll");  // it's more used in games
                        return(p->ext);
                    }
                }
            }
            if((datalen > 18) && !memcmp(data + datalen - 18, "TRUEVISION-XFILE.\0", 18)) return("tga");
            if(!strnicmp(data, "<?xml", 5)) return("xml");
            if(!strnicmp(data, "<html", 5)) return("htm");
            if(!strnicmp(data, "<DOC",  4)) return("htm");
            for(i = 0; i < MAX_EXT_CHECK; i++) {
                if(!isprint(data[i])) break;
            }
            if(i >= MAX_EXT_CHECK) {
                if((data[0] == '#') || (data[0] == '/')) return("txt");
                if((data[0] == '[') || (data[0] == ';')) return("ini");
            }
            t = data;
            if(!t[0]) t++;
            if(isalnum(t[0]) && isalnum(t[1]) && isalnum(t[2])) {
                for(i = 0; (i < 3) && t[i]; i++) {
                    last_ext[i] = tolower(t[i]);
                }
                last_ext[i] = 0;
                if(last_ext[0]) return(last_ext);
            }
            if((data[2] == '\r') && (data[3] == '\n')) return("pyc");
            if(!memcmp(data, "'''", 3)) return("py");
            if(data[0] == '<') return("xml");
        }
    }
    return("dat");
}

